/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logtransfer.util;

import com.clustercontrol.commons.util.CommonSendTopic;
import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import java.util.ArrayList;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TopicPublisher;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendTopic
extends CommonSendTopic {
    protected static Log m_log = LogFactory.getLog(SendTopic.class);

    public SendTopic(String topicName) throws NamingException, JMSException {
        super(topicName);
    }

    public void put(String facilityId, ArrayList<LogTransferFileInfo> fileInfoList, boolean initFlg) throws JMSException {
        TopicPublisher publisher = null;
        try {
            publisher = this.m_session.createPublisher(this.m_topic);
            ObjectMessage message = this.m_session.createObjectMessage(fileInfoList);
            message.setStringProperty("FacilityId", facilityId);
            message.setBooleanProperty("Init", initFlg);
            publisher.publish((Message)message);
            m_log.debug((Object)("put() topic: FacilityId = " + facilityId));
        }
        catch (JMSException e) {
            throw e;
        }
        finally {
            try {
                if (publisher != null) {
                    publisher.close();
                }
            }
            catch (JMSException e) {}
        }
    }
}

