/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.sql.ejb.session;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.sql.factory.AddMonitorSql;
import com.clustercontrol.sql.factory.AddMonitorSqlString;
import com.clustercontrol.sql.factory.DeleteMonitorSql;
import com.clustercontrol.sql.factory.DeleteMonitorSqlString;
import com.clustercontrol.sql.factory.ModifyMonitorSql;
import com.clustercontrol.sql.factory.ModifyMonitorSqlString;
import com.clustercontrol.sql.factory.SelectMonitorSql;
import com.clustercontrol.sql.factory.SelectMonitorSqlString;
import java.rmi.RemoteException;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public abstract class MonitorSqlControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(MonitorSqlControllerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public boolean addSql(MonitorInfo info) throws InvalidTransactionException, IllegalStateException, CreateException, FinderException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {
        Principal pri = this.m_context.getCallerPrincipal();
        Object sql = null;
        if (info.getMonitorType() == 1) {
            sql = new AddMonitorSql();
        } else if (info.getMonitorType() == 2) {
            sql = new AddMonitorSqlString();
        } else {
            return false;
        }
        return sql.add(info, pri.getName());
    }

    public boolean modifySql(MonitorInfo info) throws InvalidTransactionException, IllegalStateException, CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {
        Principal pri = this.m_context.getCallerPrincipal();
        Object sql = null;
        if (info.getMonitorType() == 1) {
            sql = new ModifyMonitorSql();
        } else if (info.getMonitorType() == 2) {
            sql = new ModifyMonitorSqlString();
        } else {
            return false;
        }
        return sql.modify(info, pri.getName());
    }

    public boolean deleteSql(String monitorId, int monitorType) throws InvalidTransactionException, IllegalStateException, FinderException, RemoveException, SchedulerException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException, CreateException, JMSException {
        Object sql = null;
        if (monitorType == 1) {
            sql = new DeleteMonitorSql();
        } else if (monitorType == 2) {
            sql = new DeleteMonitorSqlString();
        } else {
            return false;
        }
        return sql.delete("MON_SQL", monitorId);
    }

    public MonitorInfo getSqlInfo(String monitorId, int monitorType) throws CreateException, FinderException, SchedulerException, NamingException {
        Object sql = null;
        if (monitorType == 1) {
            sql = new SelectMonitorSql();
        } else if (monitorType == 2) {
            sql = new SelectMonitorSqlString();
        } else {
            return null;
        }
        MonitorInfo info = sql.getMonitor("MON_SQL", monitorId);
        return info;
    }

    public ArrayList getSqlList() throws CreateException, FinderException, SchedulerException, NamingException {
        SelectMonitorSql sql = new SelectMonitorSql();
        ArrayList list = sql.getMonitorList("MON_SQL");
        return list;
    }

    public ArrayList getSqlListTableDefine(Locale locale) {
        SelectMonitorSql sql = new SelectMonitorSql();
        ArrayList tableDefine = sql.getMonitorListTableDefine(locale);
        return tableDefine;
    }

    public ArrayList getSqlStringValueListTableDefine(Locale locale) {
        SelectMonitorSqlString sql = new SelectMonitorSqlString();
        ArrayList tableDefine = sql.getStringValueListTableDefine(locale);
        return tableDefine;
    }
}

