/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.parser.coretypes;

import java.util.ArrayList;
import java.util.HashMap;
import org.jfree.util.Log;
import org.jfree.xml.parser.AbstractXmlReadHandler;
import org.jfree.xml.parser.RootXmlReadHandler;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.jfree.xml.parser.coretypes.ObjectRefHandler;
import org.jfree.xml.util.AttributeDefinition;
import org.jfree.xml.util.ConstructorDefinition;
import org.jfree.xml.util.GenericObjectFactory;
import org.jfree.xml.util.LookupDefinition;
import org.jfree.xml.util.ObjectDescriptionException;
import org.jfree.xml.util.PropertyDefinition;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GenericReadHandler
extends AbstractXmlReadHandler {
    private Object object;
    private GenericObjectFactory objectFactory;
    private ArrayList objectRefHandlers;
    private HashMap createdHandler = new HashMap();

    public GenericReadHandler(GenericObjectFactory genericObjectFactory) {
        this.objectRefHandlers = new ArrayList();
        this.objectFactory = genericObjectFactory;
    }

    protected void startParsing(Attributes attributes) throws SAXException {
        try {
            AttributeDefinition[] attributeDefinitionArray = this.objectFactory.getAttributeDefinitions();
            for (int i = 0; i < attributeDefinitionArray.length; ++i) {
                AttributeDefinition attributeDefinition = attributeDefinitionArray[i];
                String string = attributes.getValue(attributeDefinition.getAttributeName());
                if (string == null) continue;
                Object object = attributeDefinition.getHandler().toPropertyValue(string);
                this.objectFactory.setProperty(attributeDefinition.getPropertyName(), object);
            }
        }
        catch (ObjectDescriptionException objectDescriptionException) {
            throw new SAXException(objectDescriptionException);
        }
    }

    protected XmlReadHandler getHandlerForChild(String string, Attributes attributes) throws SAXException {
        try {
            if (string.equals("objectRef")) {
                ObjectRefHandler objectRefHandler = new ObjectRefHandler();
                this.objectRefHandlers.add(objectRefHandler);
                return objectRefHandler;
            }
            XmlReadHandler xmlReadHandler = this.rootHandler.createHandler(this.objectFactory.getTypeForTagName(string), string, attributes);
            if (xmlReadHandler != null) {
                this.createdHandler.put(string, xmlReadHandler);
            }
            return xmlReadHandler;
        }
        catch (ObjectDescriptionException objectDescriptionException) {
            Log.debug("Failed to get handler for child: ", objectDescriptionException);
            throw new SAXException(objectDescriptionException);
        }
    }

    public Object getObject() throws XmlReaderException {
        if (this.object != null) {
            return this.object;
        }
        RootXmlReadHandler rootXmlReadHandler = this.getRootHandler();
        try {
            Object object;
            Object object2;
            LookupDefinition[] lookupDefinitionArray;
            for (int i = 0; i < this.objectRefHandlers.size(); ++i) {
                lookupDefinitionArray = (LookupDefinition[])this.objectRefHandlers.get(i);
                this.objectFactory.setProperty(lookupDefinitionArray.getPropertyName(), lookupDefinitionArray.getObject());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            lookupDefinitionArray = this.objectFactory.getLookupDefinitions();
            for (int i = 0; i < lookupDefinitionArray.length; ++i) {
                LookupDefinition lookupDefinition = lookupDefinitionArray[i];
                arrayList.add(lookupDefinition.getPropertyName());
                Log.debug("lookup object: " + lookupDefinition.getPropertyName());
                object2 = rootXmlReadHandler.getObject(lookupDefinition.getRegistryKey());
                if (object2 == null) {
                    Log.warn("Failed to lookup object: " + object2);
                    continue;
                }
                this.objectFactory.setProperty(lookupDefinition.getPropertyName(), object2);
            }
            ConstructorDefinition[] constructorDefinitionArray = this.objectFactory.getConstructorDefinitions();
            for (int i = 0; i < constructorDefinitionArray.length; ++i) {
                PropertyDefinition propertyDefinition;
                object2 = constructorDefinitionArray[i];
                if (arrayList.contains(object2.getPropertyName()) || !this.objectFactory.isPropertyDefinition(object2.getPropertyName()) || (object = (XmlReadHandler)this.createdHandler.get((propertyDefinition = this.objectFactory.getPropertyDefinitionByPropertyName(object2.getPropertyName())).getElementName())) == null) continue;
                this.objectFactory.setProperty(propertyDefinition.getPropertyName(), object.getObject());
            }
            this.object = this.objectFactory.createObject();
            Object object3 = null;
            if (this.objectFactory.getRegisterName() != null) {
                object3 = rootXmlReadHandler.getObject(this.objectFactory.getRegisterName());
                rootXmlReadHandler.putObject(this.objectFactory.getRegisterName(), this.object);
            }
            object2 = this.objectFactory.getPropertyDefinitions();
            for (int i = 0; i < ((PropertyDefinition[])object2).length; ++i) {
                object = object2[i];
                XmlReadHandler xmlReadHandler = (XmlReadHandler)this.createdHandler.get(((PropertyDefinition)object).getElementName());
                if (xmlReadHandler == null) continue;
                this.objectFactory.setProperty(((PropertyDefinition)object).getPropertyName(), xmlReadHandler.getObject());
            }
            this.objectFactory.writeObjectProperties(this.object);
            if (this.objectFactory.getRegisterName() != null) {
                rootXmlReadHandler.putObject(this.objectFactory.getRegisterName(), object3);
            }
        }
        catch (ObjectDescriptionException objectDescriptionException) {
            Log.error("Unable to create object.", objectDescriptionException);
            throw new XmlReaderException("Unable to create object.", objectDescriptionException);
        }
        return this.object;
    }
}

