/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.maintenance.bean.ScheduleInfo;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import com.clustercontrol.quartzmanager.util.QuartzUtil;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

public class ModifySchedule {
    protected static Log m_log = LogFactory.getLog(ModifySchedule.class);

    public void addSchedule(ScheduleInfo info, String user) throws ParseException, NamingException, SchedulerException, RemoteException {
        m_log.debug((Object)("addSchedule() : id=" + info.getId() + ", jobId=" + info.getJobId()));
        AccessLock.lock((String)"JOB");
        JobDetail job = new JobDetail(info.getId(), "MAINTENANCE", EJBInvokerJob.class);
        job.setDescription(info.getName());
        job.setDurability(true);
        job.setRequestsRecovery(true);
        job.getJobDataMap().put("ejb", "MaintenanceController");
        job.getJobDataMap().put("method", "scheduleRunMaintenance");
        String serverName = System.getProperty("jboss.server.name");
        if (serverName.equals("all")) {
            job.getJobDataMap().put("java.naming.provider.url", "jnp://localhost:1100");
        }
        Object[] jdArgs = new Object[2];
        Class[] jdArgsType = new Class[2];
        jdArgs[0] = info.getJobId();
        job.getJobDataMap().put((Object)"args", (Object)jdArgs);
        jdArgsType[0] = String.class;
        job.getJobDataMap().put((Object)"argTypes", (Object)jdArgsType);
        jdArgs[1] = info.getCalendarId();
        job.getJobDataMap().put((Object)"args", (Object)jdArgs);
        jdArgsType[1] = String.class;
        job.getJobDataMap().put((Object)"argTypes", (Object)jdArgsType);
        if (info.getValid() == 1) {
            job.getJobDataMap().put((Object)"valid", (Object)new Integer(1));
        } else {
            job.getJobDataMap().put((Object)"valid", (Object)new Integer(0));
        }
        Date now = new Date();
        job.getJobDataMap().put("maintenanceName", info.getJobName());
        job.getJobDataMap().put("createUser", user);
        job.getJobDataMap().put((Object)"createDate", (Object)now);
        job.getJobDataMap().put("updateUser", user);
        job.getJobDataMap().put((Object)"updateDate", (Object)now);
        job.getJobDataMap().put((Object)"schedule", (Object)info.getSchedule());
        CronTrigger cronTrigger = new CronTrigger(info.getId(), "MAINTENANCE");
        cronTrigger.setMisfireInstruction(2);
        cronTrigger.setCronExpression(this.getCronString(info.getSchedule()));
        QuartzManager manager = QuartzUtil.getQuartzManager();
        manager.addSchedule(job, (Trigger)cronTrigger);
        if (info.getValid() == 0) {
            manager.pauseSchedule(job.getName(), "MAINTENANCE");
        }
    }

    public void modifySchedule(ScheduleInfo info, String user) throws NamingException, SchedulerException, ParseException, RemoteException {
        m_log.debug((Object)("modifySchedule() : id=" + info.getId() + ", jobId=" + info.getJobId()));
        AccessLock.lock((String)"JOB");
        QuartzManager manager = QuartzUtil.getQuartzManager();
        JobDetail job = null;
        try {
            job = manager.getJobDetail(info.getId(), "MAINTENANCE");
        }
        catch (RemoteException e) {
            // empty catch block
        }
        job.setDescription(info.getName());
        job.setDurability(true);
        job.setRequestsRecovery(true);
        Object[] jdArgs = new Object[2];
        Class[] jdArgsType = new Class[2];
        jdArgs[0] = info.getJobId();
        job.getJobDataMap().put((Object)"args", (Object)jdArgs);
        jdArgsType[0] = String.class;
        job.getJobDataMap().put((Object)"argTypes", (Object)jdArgsType);
        jdArgs[1] = info.getCalendarId();
        job.getJobDataMap().put((Object)"args", (Object)jdArgs);
        jdArgsType[1] = String.class;
        job.getJobDataMap().put((Object)"argTypes", (Object)jdArgsType);
        if (info.getValid() == 1) {
            job.getJobDataMap().put((Object)"valid", (Object)new Integer(1));
        } else {
            job.getJobDataMap().put((Object)"valid", (Object)new Integer(0));
        }
        job.getJobDataMap().put("maintenanceName", info.getJobName());
        job.getJobDataMap().put("createUser", info.getCreateUser());
        job.getJobDataMap().put((Object)"createDate", (Object)info.getCreateTime());
        job.getJobDataMap().put("updateUser", user);
        job.getJobDataMap().put((Object)"updateDate", (Object)new Date());
        job.getJobDataMap().put((Object)"schedule", (Object)info.getSchedule());
        CronTrigger cronTrigger = new CronTrigger(info.getId(), "MAINTENANCE");
        cronTrigger.setMisfireInstruction(2);
        cronTrigger.setCronExpression(this.getCronString(info.getSchedule()));
        this.deleteSchedule(info.getId());
        manager.addSchedule(job, (Trigger)cronTrigger);
        if (info.getValid() == 0) {
            manager.pauseSchedule(job.getName(), job.getGroup());
        }
    }

    public void deleteSchedule(String scheduleId) throws NamingException, SchedulerException, RemoteException {
        m_log.debug((Object)("deleteSchedule() : id=" + scheduleId));
        AccessLock.lock((String)"JOB");
        QuartzManager manager = QuartzUtil.getQuartzManager();
        manager.deleteSchedule(scheduleId, "MAINTENANCE");
    }

    protected String getCronString(Schedule schedule) {
        m_log.debug((Object)"getCronString()");
        StringBuffer cron = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(schedule.getDate());
        if (schedule.getType() == 0) {
            cron.append(calendar.get(13));
            cron.append(" ");
            cron.append(calendar.get(12));
            cron.append(" ");
            cron.append(calendar.get(11));
            cron.append(" ");
            cron.append(calendar.get(5));
            cron.append(" ");
            cron.append(calendar.get(2) + 1);
            cron.append(" ? *");
        } else if (schedule.getType() == 1) {
            cron.append(calendar.get(13));
            cron.append(" ");
            cron.append(calendar.get(12));
            cron.append(" ");
            cron.append(calendar.get(11));
            cron.append(" ");
            cron.append(calendar.get(5));
            cron.append(" * ? *");
        } else if (schedule.getType() == 2) {
            cron.append(calendar.get(13));
            cron.append(" ");
            cron.append(calendar.get(12));
            cron.append(" ");
            cron.append(calendar.get(11));
            cron.append(" * * ? *");
        } else if (schedule.getType() == 3) {
            cron.append(calendar.get(13));
            cron.append(" ");
            cron.append(calendar.get(12));
            cron.append(" * * * ? *");
        } else if (schedule.getType() == 4) {
            cron.append(calendar.get(13));
            cron.append(" ");
            cron.append(calendar.get(12));
            cron.append(" ");
            cron.append(calendar.get(11));
            cron.append(" ? * ");
            cron.append(calendar.get(7));
            cron.append(" *");
        } else {
            cron.append(calendar.get(13));
            cron.append(" ");
            cron.append(calendar.get(12));
            cron.append(" ");
            cron.append(calendar.get(11));
            cron.append(" ");
            cron.append(calendar.get(5));
            cron.append(" ");
            cron.append(calendar.get(2) + 1);
            cron.append(" ? ");
            cron.append(calendar.get(1));
        }
        return cron.toString();
    }
}

