/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.mq.Connection;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.il.ClientIL;
import org.jboss.mq.il.ClientILService;
import org.jboss.mq.il.oil.OILClientIL;

public final class OILClientILService
implements Runnable,
ClientILService {
    private static final Logger cat = Logger.getLogger((Class)OILClientILService.class);
    private OILClientIL clientIL;
    private Thread worker;
    private Socket socket = null;
    private Connection connection;
    private boolean running;
    private ServerSocket serverSocket;
    private static int threadNumber = 0;
    private boolean enableTcpNoDelay = false;

    public ClientIL getClientIL() throws Exception {
        return this.clientIL;
    }

    public void init(Connection connection, Properties props) throws Exception {
        this.connection = connection;
        this.serverSocket = new ServerSocket(0);
        String t = props.getProperty("OIL_TCPNODELAY_KEY");
        if (t != null) {
            this.enableTcpNoDelay = t.equals("yes");
        }
        this.clientIL = new OILClientIL(InetAddress.getLocalHost(), this.serverSocket.getLocalPort(), this.enableTcpNoDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int serverPort;
        ObjectInputStream in;
        ObjectOutputStream out;
        byte code;
        block43: {
            code = 0;
            out = null;
            in = null;
            this.socket = null;
            serverPort = this.serverSocket.getLocalPort();
            try {
                if (cat.isDebugEnabled()) {
                    cat.debug((Object)("Waiting for the server to connect to me on port " + this.serverSocket.getLocalPort()));
                }
                this.serverSocket.setSoTimeout(1000);
                while (this.running && this.socket == null) {
                    try {
                        this.socket = this.serverSocket.accept();
                    }
                    catch (InterruptedIOException e) {
                    }
                    catch (IOException e) {
                        block42: {
                            if (this.running) {
                                this.connection.asynchFailure("Error accepting connection from server in OILClientILService.", e);
                            }
                            try {
                                this.serverSocket.close();
                                this.serverSocket = null;
                            }
                            catch (IOException e2) {
                                if (!cat.isDebugEnabled()) break block42;
                                cat.debug((Object)"run: an error occured closing the server socket", (Throwable)e2);
                            }
                        }
                        return;
                    }
                }
                if (this.running) {
                    this.socket.setTcpNoDelay(this.enableTcpNoDelay);
                    this.socket.setSoTimeout(0);
                    out = new ObjectOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                    out.flush();
                    in = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
                    break block43;
                }
                return;
            }
            catch (IOException e) {
                this.connection.asynchFailure("Could not initialize the OILClientIL Service.", e);
                return;
            }
            finally {
                block44: {
                    try {
                        this.serverSocket.close();
                        this.serverSocket = null;
                    }
                    catch (IOException e) {
                        if (!cat.isDebugEnabled()) break block44;
                        cat.debug((Object)"run: an error occured closing the server socket", (Throwable)e);
                    }
                }
            }
        }
        while (this.running) {
            try {
                code = in.readByte();
            }
            catch (InterruptedIOException e) {
                continue;
            }
            catch (IOException e) {
                break;
            }
            try {
                switch (code) {
                    case 19: {
                        int numReceives = in.readInt();
                        ReceiveRequest[] messages = new ReceiveRequest[numReceives];
                        for (int i = 0; i < numReceives; ++i) {
                            messages[i] = new ReceiveRequest();
                            messages[i].readExternal(in);
                        }
                        this.connection.asynchDeliver(messages);
                        break;
                    }
                    case 15: {
                        this.connection.asynchDeleteTemporaryDestination((SpyDestination)in.readObject());
                        break;
                    }
                    case 29: {
                        this.connection.asynchClose();
                        break;
                    }
                    case 28: {
                        this.connection.asynchPong(in.readLong());
                        break;
                    }
                    default: {
                        throw new RemoteException("Bad method code !");
                    }
                }
                try {
                    out.writeByte(0);
                    out.flush();
                    continue;
                }
                catch (IOException e) {
                    this.connection.asynchFailure("Connection failure(1)", e);
                }
            }
            catch (Exception e) {
                if (!this.running) break;
                try {
                    cat.error((Object)"Exception handling server request", (Throwable)e);
                    out.writeByte(2);
                    out.writeObject(e);
                    out.reset();
                    out.flush();
                    continue;
                }
                catch (IOException e2) {
                    this.connection.asynchFailure("Connection failure(2)", e2);
                }
            }
            break;
        }
        try {
            cat.debug((Object)("Closing receiver connections on port: " + serverPort));
            out.close();
            in.close();
            this.socket.close();
            this.socket = null;
        }
        catch (IOException e) {
            this.connection.asynchFailure("Connection failure", e);
        }
        this.running = false;
    }

    public void start() throws Exception {
        this.running = true;
        this.worker = new Thread(Connection.getThreadGroup(), this, "OILClientILService-" + threadNumber++);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    public void stop() throws Exception {
        cat.trace((Object)"Stop called on OILClientService");
        this.running = false;
        this.worker.interrupt();
    }
}

