/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import java.util.HashSet;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.jboss.mq.Connection;
import org.jboss.mq.GenericConnectionFactory;
import org.jboss.mq.SpyConnectionConsumer;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyQueueSession;
import org.jboss.mq.SpySession;
import org.jboss.mq.SpyTemporaryQueue;
import org.jboss.mq.SpyTemporaryTopic;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.SpyTopicSession;
import org.jboss.util.UnreachableStatementException;

public class SpyConnection
extends Connection
implements Serializable,
TopicConnection,
QueueConnection {
    private static final long serialVersionUID = -6227193901482445607L;
    public static final int UNIFIED = 0;
    public static final int QUEUE = 1;
    public static final int TOPIC = 2;
    private int type = 0;

    public SpyConnection(String userId, String password, GenericConnectionFactory gcf) throws JMSException {
        super(userId, password, gcf);
    }

    public SpyConnection(GenericConnectionFactory gcf) throws JMSException {
        super(gcf);
    }

    public SpyConnection(int type, String userId, String password, GenericConnectionFactory gcf) throws JMSException {
        super(userId, password, gcf);
        this.type = type;
    }

    public SpyConnection(int type, GenericConnectionFactory gcf) throws JMSException {
        super(gcf);
        this.type = type;
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        if (destination == null) {
            throw new InvalidDestinationException("Null destination");
        }
        this.checkTemporary(destination);
        return new SpyConnectionConsumer(this, destination, messageSelector, sessionPool, maxMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        this.checkClientID();
        if (transacted) {
            acknowledgeMode = 0;
        }
        SpySession session = new SpySession(this, transacted, acknowledgeMode, false);
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            this.createdSessions.add(session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        this.checkClientID();
        if (transacted) {
            acknowledgeMode = 0;
        }
        SpyTopicSession session = new SpyTopicSession(this, transacted, acknowledgeMode);
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            this.createdSessions.add(session);
        }
        return session;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        if (this.type == 1) {
            throw new IllegalStateException("Cannot create a topic consumer on a QueueConnection");
        }
        if (topic == null) {
            throw new InvalidDestinationException("Null topic");
        }
        this.checkClientID();
        this.checkTemporary((Destination)topic);
        return new SpyConnectionConsumer(this, (Destination)topic, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        if (this.type == 1) {
            throw new IllegalStateException("Cannot create a topic consumer on a QueueConnection");
        }
        if (topic == null) {
            throw new InvalidDestinationException("Null topic");
        }
        if (topic instanceof TemporaryTopic) {
            throw new InvalidDestinationException("Attempt to create a durable subscription for a temporary topic");
        }
        if (subscriptionName == null || subscriptionName.trim().length() == 0) {
            throw new JMSException("Null or empty subscription");
        }
        SpyTopic t = new SpyTopic((SpyTopic)topic, this.getClientID(), subscriptionName, messageSelector);
        return new SpyConnectionConsumer(this, t, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        if (this.type == 2) {
            throw new IllegalStateException("Cannot create a queue consumer on a TopicConnection");
        }
        if (queue == null) {
            throw new InvalidDestinationException("Null queue");
        }
        this.checkTemporary((Destination)queue);
        return new SpyConnectionConsumer(this, (Destination)queue, messageSelector, sessionPool, maxMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        this.checkClientID();
        if (transacted) {
            acknowledgeMode = 0;
        }
        SpyQueueSession session = new SpyQueueSession(this, transacted, acknowledgeMode);
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            this.createdSessions.add(session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TemporaryTopic getTemporaryTopic() throws JMSException {
        this.checkClosed();
        this.checkClientID();
        try {
            SpyTemporaryTopic temp = (SpyTemporaryTopic)this.serverIL.getTemporaryTopic(this.connectionToken);
            temp.setConnection(this);
            HashSet hashSet = this.temps;
            synchronized (hashSet) {
                this.temps.add(temp);
            }
            return temp;
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot create a Temporary Topic", t);
            throw new UnreachableStatementException();
        }
    }

    Topic createTopic(String name) throws JMSException {
        this.checkClosed();
        this.checkClientID();
        try {
            return this.serverIL.createTopic(this.connectionToken, name);
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot get the Topic from the provider", t);
            throw new UnreachableStatementException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TemporaryQueue getTemporaryQueue() throws JMSException {
        this.checkClosed();
        this.checkClientID();
        try {
            SpyTemporaryQueue temp = (SpyTemporaryQueue)this.serverIL.getTemporaryQueue(this.connectionToken);
            temp.setConnection(this);
            HashSet hashSet = this.temps;
            synchronized (hashSet) {
                this.temps.add(temp);
            }
            return temp;
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot create a Temporary Queue", t);
            throw new UnreachableStatementException();
        }
    }

    Queue createQueue(String name) throws JMSException {
        this.checkClosed();
        this.checkClientID();
        try {
            return this.serverIL.createQueue(this.connectionToken, name);
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot get the Queue from the provider", t);
            throw new UnreachableStatementException();
        }
    }
}

