/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.ImageArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class DvdCover
extends AbstractTool {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DvdCover() {
        this.menuoptions = 7;
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the PDF has to be written", true, new PdfFilter()));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.arguments.add(new ToolArgument(this, "title", "The title of the DVD", clazz.getName()));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.arguments.add(new ToolArgument(this, "backgroundcolor", "The backgroundcolor of the DVD Cover (for instance 0xFFFFFF)", clazz2.getName()));
        this.arguments.add(new ImageArgument(this, "front", "The front image of the DVD Cover"));
        this.arguments.add(new ImageArgument(this, "back", "The back image of the DVD Cover"));
        this.arguments.add(new ImageArgument(this, "side", "The side image of the DVD Cover"));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Make your own DVD Cover", true, true, true);
        this.internalFrame.setSize(500, 300);
        this.internalFrame.setJMenuBar(this.getMenubar());
    }

    public void execute() {
        try {
            Rectangle pageSize = new Rectangle(780.0f, 525.0f);
            if (this.getValue("backgroundcolor") != null) {
                pageSize.setBackgroundColor((Color)this.getValue("backgroundcolor"));
            }
            Document document = new Document(pageSize);
            if (this.getValue("destfile") == null) {
                throw new DocumentException("You must provide a destination file!");
            }
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream((File)this.getValue("destfile")));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            if (this.getValue("title") != null) {
                cb.setFontAndSize(BaseFont.createFont("Helvetica", "Cp1252", false), 24.0f);
                cb.beginText();
                if (this.getValue("front") == null) {
                    cb.showTextAligned(1, (String)this.getValue("title"), 595.0f, 262.0f, 0.0f);
                }
                if (this.getValue("side") == null) {
                    cb.showTextAligned(1, (String)this.getValue("title"), 385.0f, 262.0f, 270.0f);
                }
                cb.endText();
            }
            cb.moveTo(370.0f, 0.0f);
            cb.lineTo(370.0f, 525.0f);
            cb.moveTo(410.0f, 525.0f);
            cb.lineTo(410.0f, 0.0f);
            cb.stroke();
            if (this.getValue("front") != null) {
                Image front = (Image)this.getValue("front");
                front.scaleToFit(370.0f, 525.0f);
                front.setAbsolutePosition(410.0f + (370.0f - front.scaledWidth()) / 2.0f, (525.0f - front.scaledHeight()) / 2.0f);
                document.add(front);
            }
            if (this.getValue("back") != null) {
                Image back = (Image)this.getValue("back");
                back.scaleToFit(370.0f, 525.0f);
                back.setAbsolutePosition((370.0f - back.scaledWidth()) / 2.0f, (525.0f - back.scaledHeight()) / 2.0f);
                document.add(back);
            }
            if (this.getValue("side") != null) {
                Image side = (Image)this.getValue("side");
                side.scaleToFit(40.0f, 525.0f);
                side.setAbsolutePosition(370.0f + (40.0f - side.scaledWidth()) / 2.0f, (525.0f - side.scaledHeight()) / 2.0f);
                document.add(side);
            }
            document.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        DvdCover tool = new DvdCover();
        if (args.length == 0) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

