/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.RectangleAnimation;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.internal.progress.ProgressRegion;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.views.IViewDescriptor;

public class ProgressManagerUtil {
    public static long SHORT_OPERATION_TIME = 250L;
    private static String ellipsis = ProgressMessages.ProgressFloatingWindow_EllipsisValue;

    static IStatus exceptionStatus(Throwable exception) {
        return StatusUtil.newStatus(4, exception.getMessage() == null ? "" : exception.getMessage(), exception);
    }

    static void logException(Throwable exception) {
        BundleUtility.log("org.eclipse.ui", exception);
    }

    static ViewerSorter getProgressViewerSorter() {
        return new ViewerSorter(){

            public int compare(Viewer testViewer, Object e1, Object e2) {
                return ((Comparable)e1).compareTo(e2);
            }
        };
    }

    static void openProgressView(WorkbenchWindow window) {
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        try {
            IViewDescriptor reference = WorkbenchPlugin.getDefault().getViewRegistry().find("org.eclipse.ui.views.ProgressView");
            if (reference == null) {
                return;
            }
            page.showView("org.eclipse.ui.views.ProgressView");
        }
        catch (PartInitException exception) {
            ProgressManagerUtil.logException((Throwable)((Object)exception));
        }
    }

    static String shortenText(String textValue, Control control) {
        int pivot;
        if (textValue == null) {
            return null;
        }
        Display display = control.getDisplay();
        GC gc = new GC((Drawable)display);
        int maxWidth = control.getBounds().width - 5;
        if (gc.textExtent((String)textValue).x < maxWidth) {
            gc.dispose();
            return textValue;
        }
        int length = textValue.length();
        int ellipsisWidth = gc.textExtent((String)ProgressManagerUtil.ellipsis).x;
        int secondWord = ProgressManagerUtil.findSecondWhitespace(textValue, gc, maxWidth);
        int start = pivot = (length - secondWord) / 2 + secondWord;
        int end = pivot + 1;
        while (start >= secondWord && end < length) {
            String s1 = textValue.substring(0, start);
            String s2 = textValue.substring(end, length);
            int l1 = gc.textExtent((String)s1).x;
            int l2 = gc.textExtent((String)s2).x;
            if (l1 + ellipsisWidth + l2 < maxWidth) {
                gc.dispose();
                return String.valueOf(s1) + ellipsis + s2;
            }
            --start;
            ++end;
        }
        gc.dispose();
        return textValue;
    }

    private static int findSecondWhitespace(String textValue, GC gc, int maxWidth) {
        int firstCharacter = 0;
        char[] chars = textValue.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (Character.isWhitespace(chars[i])) {
                firstCharacter = i;
                break;
            }
            ++i;
        }
        if (firstCharacter == 0) {
            return 0;
        }
        int secondCharacter = firstCharacter;
        int i2 = firstCharacter;
        while (i2 < chars.length) {
            if (Character.isWhitespace(chars[i2])) {
                secondCharacter = i2;
                break;
            }
            ++i2;
        }
        if (gc.textExtent((String)textValue.substring((int)0, (int)secondCharacter)).x > maxWidth) {
            if (gc.textExtent((String)textValue.substring((int)0, (int)firstCharacter)).x > maxWidth) {
                return 0;
            }
            return firstCharacter;
        }
        return secondCharacter;
    }

    public static boolean rescheduleIfModalShellOpen(Job openJob) {
        Shell modal = ProgressManagerUtil.getModalShellExcluding(null);
        if (modal == null) {
            return false;
        }
        openJob.schedule((long)PlatformUI.getWorkbench().getProgressService().getLongOperationTime());
        return true;
    }

    public static boolean safeToOpen(ProgressMonitorJobsDialog dialog, Shell excludedShell) {
        Shell modal = ProgressManagerUtil.getModalShellExcluding(excludedShell);
        if (modal == null) {
            return true;
        }
        dialog.watchTicks();
        return false;
    }

    public static Shell getModalShellExcluding(Shell shell) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell[] shells = workbench.getDisplay().getShells();
        int modal = 229376;
        int i = 0;
        while (i < shells.length) {
            int style;
            if (shells[i].equals(shell)) break;
            if (shells[i].isVisible() && ((style = shells[i].getStyle()) & modal) != 0) {
                return shells[i];
            }
            ++i;
        }
        return null;
    }

    public static Shell getDefaultParent() {
        Shell modal = ProgressManagerUtil.getModalShellExcluding(null);
        if (modal != null) {
            return modal;
        }
        return ProgressManagerUtil.getNonModalShell();
    }

    public static Shell getNonModalShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void animateDown(Rectangle startPosition) {
        IWorkbenchWindow currentWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (currentWindow == null) {
            return;
        }
        WorkbenchWindow internalWindow = (WorkbenchWindow)currentWindow;
        ProgressRegion progressRegion = internalWindow.getProgressRegion();
        if (progressRegion == null) {
            return;
        }
        Rectangle endPosition = progressRegion.getControl().getBounds();
        Point windowLocation = internalWindow.getShell().getLocation();
        endPosition.x += windowLocation.x;
        endPosition.y += windowLocation.y;
        RectangleAnimation animation = new RectangleAnimation(internalWindow.getShell(), startPosition, endPosition);
        animation.schedule();
    }

    public static void animateUp(Rectangle endPosition) {
        IWorkbenchWindow currentWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (currentWindow == null) {
            return;
        }
        WorkbenchWindow internalWindow = (WorkbenchWindow)currentWindow;
        Point windowLocation = internalWindow.getShell().getLocation();
        ProgressRegion progressRegion = internalWindow.getProgressRegion();
        if (progressRegion == null) {
            return;
        }
        Rectangle startPosition = progressRegion.getControl().getBounds();
        startPosition.x += windowLocation.x;
        startPosition.y += windowLocation.y;
        RectangleAnimation animation = new RectangleAnimation(internalWindow.getShell(), startPosition, endPosition);
        animation.schedule();
    }

    static IShellProvider getShellProvider() {
        return new IShellProvider(){

            public Shell getShell() {
                return ProgressManagerUtil.getDefaultParent();
            }
        };
    }
}

