/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.defaultpresentation;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.layout.CellLayout;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.layout.Row;
import org.eclipse.ui.internal.layout.SizeCache;
import org.eclipse.ui.internal.presentations.defaultpresentation.DetachedViewTabItem;
import org.eclipse.ui.internal.presentations.util.AbstractTabFolder;
import org.eclipse.ui.internal.presentations.util.AbstractTabItem;
import org.eclipse.ui.internal.presentations.util.PartInfo;
import org.eclipse.ui.internal.presentations.util.ProxyControl;
import org.eclipse.ui.internal.util.Util;

public class DetachedViewTabFolder
extends AbstractTabFolder {
    private Composite control;
    private CTabFolder folder;
    private Control viewToolBar;
    private ViewForm viewForm;
    private ProxyControl toolbarProxy;
    private Composite topLeftControl;
    private SizeCache toolbarCache;
    private Cursor dragCursor;
    private static final String FULL_TITLE = "part_title";
    private CTabFolder2Adapter expandListener = new CTabFolder2Adapter(){

        public void close(CTabFolderEvent event) {
            event.doit = false;
            DetachedViewTabFolder.this.fireEvent(6, DetachedViewTabFolder.this.getTab(event.item));
        }

        public void showList(CTabFolderEvent event) {
            event.doit = false;
            DetachedViewTabFolder.this.fireEvent(11);
        }
    };
    private Listener selectionListener = new Listener(){

        public void handleEvent(Event e) {
            DetachedViewTabFolder.this.fireEvent(8, DetachedViewTabFolder.this.getTab(e.item));
        }
    };
    private IPropertyListener systemToolbarListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            Point location = propId == 1 ? DetachedViewTabFolder.this.getPaneMenuLocation() : new Point(0, 0);
            DetachedViewTabFolder.this.fireEvent(propId, DetachedViewTabFolder.this.getSelection(), location);
        }
    };
    private DisposeListener tabDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (e.widget == DetachedViewTabFolder.this.control) {
                DetachedViewTabFolder.this.disposed();
            }
        }
    };

    public DetachedViewTabFolder(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.addDisposeListener(this.tabDisposeListener);
        CellLayout layout = new CellLayout(1).setDefaultRow(Row.fixed()).setDefaultColumn(Row.growing()).setRow(0, Row.growing()).setSpacing(0, 0).setMargins(0, 0);
        this.control.setLayout((Layout)layout);
        this.dragCursor = parent.getDisplay().getSystemCursor(5);
        this.viewForm = new ViewForm(this.control, 0x800000);
        this.attachListeners((Control)this.viewForm, false);
        this.topLeftControl = new Composite((Composite)this.viewForm, 0);
        this.topLeftControl.setLayout((Layout)new CellLayout(0).setDefaultColumn(Row.fixed()).setSpacing(0, 0).setMargins(0, 0));
        this.topLeftControl.setCursor(this.dragCursor);
        this.attachListeners((Control)this.topLeftControl, false);
        this.toolbarProxy = new ProxyControl(this.topLeftControl);
        this.viewForm.setTopLeft((Control)this.topLeftControl);
        this.toolbarCache = new SizeCache();
        this.folder = new CTabFolder(this.control, 1024);
        this.folder.setMinimizeVisible(false);
        this.folder.setMaximizeVisible(false);
        this.folder.setUnselectedCloseVisible(true);
        this.folder.setUnselectedImageVisible(true);
        this.folder.addListener(13, this.selectionListener);
        this.folder.addCTabFolder2Listener((CTabFolder2Listener)this.expandListener);
        this.attachListeners((Control)this.folder, false);
        ToolBar actualToolBar = new ToolBar((Composite)this.viewForm, 0x840000);
        this.viewToolBar = actualToolBar;
        ToolItem pullDownButton = new ToolItem(actualToolBar, 8);
        Image hoverImage = WorkbenchImages.getImage("IMG_LCL_RENDERED_VIEW_MENU");
        pullDownButton.setDisabledImage(hoverImage);
        pullDownButton.setImage(hoverImage);
        pullDownButton.setToolTipText(WorkbenchMessages.Menu);
        actualToolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DetachedViewTabFolder.this.fireEvent(1, DetachedViewTabFolder.this.getSelection(), DetachedViewTabFolder.this.getPaneMenuLocation());
            }
        });
        this.viewForm.setTopRight(this.viewToolBar);
    }

    protected void disposed() {
    }

    public Point computeSize(int widthHint, int heightHint) {
        return new Point(50, 50);
    }

    public AbstractTabItem add(int index, int flags) {
        DetachedViewTabItem item = new DetachedViewTabItem(this, index, flags);
        item.getWidget().setData((Object)item);
        item.getWidget().addDisposeListener(this.tabDisposeListener);
        if (this.folder.getItemCount() == 2) {
            this.layout(true);
        }
        return item;
    }

    public void layout(boolean flushCache) {
        Rectangle oldBounds = this.viewForm.getBounds();
        CellLayout layout = (CellLayout)this.control.getLayout();
        if (this.folder.getItemCount() < 2) {
            layout.setRow(1, Row.fixed(0));
        } else {
            layout.setRow(1, Row.fixed(this.folder.getTabHeight() + 2));
        }
        super.layout(flushCache);
        this.control.layout(flushCache);
        Rectangle newBounds = this.viewForm.getBounds();
        if (Util.equals(oldBounds, newBounds)) {
            this.viewForm.layout(flushCache);
        }
    }

    public Rectangle getClientArea() {
        Control content = this.viewForm.getContent();
        if (content == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return Geometry.toControl((Control)this.control, (Rectangle)DragUtil.getDisplayBounds(content));
    }

    public AbstractTabItem[] getItems() {
        CTabItem[] items = this.folder.getItems();
        AbstractTabItem[] result = new AbstractTabItem[items.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getTab((Widget)items[i]);
            ++i;
        }
        return result;
    }

    private AbstractTabItem getTab(Widget item) {
        return (AbstractTabItem)item.getData();
    }

    public void setSelection(AbstractTabItem toSelect) {
        if (toSelect == null) {
            return;
        }
        DetachedViewTabItem tab = (DetachedViewTabItem)toSelect;
        this.folder.setSelection((CTabItem)tab.getWidget());
    }

    public void setSelectedInfo(PartInfo info) {
    }

    public Composite getToolbarParent() {
        return this.viewForm;
    }

    public Rectangle getTabArea() {
        return Geometry.toDisplay((Control)this.folder.getParent(), (Rectangle)this.folder.getBounds());
    }

    public void setToolbar(Control toolbarControl) {
        if (toolbarControl == this.getToolbar()) {
            return;
        }
        if (toolbarControl != null) {
            this.toolbarCache.setControl(toolbarControl);
            this.toolbarProxy.setTarget(this.toolbarCache);
            this.toolbarProxy.getControl().getParent().changed(new Control[]{this.toolbarProxy.getControl()});
            LayoutUtil.resize(this.toolbarProxy.getControl());
            this.toolbarProxy.layout();
        } else {
            this.toolbarCache.setControl(null);
            this.toolbarProxy.setTarget(null);
        }
        super.setToolbar(toolbarControl);
    }

    public Control getControl() {
        return this.control;
    }

    public boolean isOnBorder(Point globalPos) {
        Point localPos = this.getControl().toControl(globalPos);
        Rectangle clientArea = this.getClientArea();
        return localPos.y > clientArea.y && localPos.y < clientArea.y + clientArea.height;
    }

    public AbstractTabItem getSelection() {
        CTabItem sel = this.folder.getSelection();
        if (sel == null) {
            return null;
        }
        return this.getTab((Widget)sel);
    }

    public Composite getContentParent() {
        return this.viewForm;
    }

    public void setContent(Control newContent) {
        this.viewForm.setContent(newContent);
    }

    public CTabFolder getTabFolder() {
        return this.folder;
    }

    protected void handleDragStarted(Point displayPos, Event e) {
        if (this.isOnBorder(displayPos)) {
            return;
        }
        AbstractTabItem tab = null;
        tab = DragUtil.getDisplayBounds((Control)this.viewForm).contains(displayPos) ? this.getSelection() : this.getItem(displayPos);
        this.fireEvent(10, tab, displayPos);
    }

    public Point getPartListLocation() {
        int numItems = this.folder.getItemCount();
        CTabItem item = null;
        CTabItem tempItem = null;
        int i = 0;
        while (i < numItems) {
            tempItem = this.folder.getItem(i);
            if (tempItem.isShowing()) {
                item = tempItem;
            }
            ++i;
        }
        if (item == null) {
            return new Point(0, 0);
        }
        Rectangle itemBounds = item.getBounds();
        int x = itemBounds.x + itemBounds.width;
        int y = itemBounds.y + itemBounds.height;
        return this.folder.toDisplay(new Point(x, y));
    }

    public Point getPaneMenuLocation() {
        Point toolbarSize = this.viewToolBar.getSize();
        return this.viewToolBar.toDisplay(0, toolbarSize.y);
    }

    public void enablePaneMenu(boolean enabled) {
        if (enabled) {
            this.viewToolBar.setVisible(true);
        } else {
            this.viewToolBar.setVisible(false);
        }
    }

    public void itemRemoved() {
        if (this.folder.getItemCount() == 1 && !this.control.isDisposed() && !this.viewForm.isDisposed()) {
            this.layout(true);
        }
    }
}

