/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.components.registry;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.internal.components.framework.ClassIdentifier;
import org.eclipse.ui.internal.components.framework.ComponentFactory;
import org.eclipse.ui.internal.components.registry.ComponentScope;
import org.eclipse.ui.internal.components.registry.ScopeDefinition;

public class ComponentRegistry {
    private Map scopes = new HashMap();

    public ComponentScope getScope(String scopeId) {
        return (ComponentScope)this.scopes.get(scopeId);
    }

    public void loadScope(String scopeId, ScopeDefinition def) {
        ComponentScope scope = this.createScope(scopeId);
        scope.load(def, this);
    }

    public void unloadScope(String scopeId) {
        ComponentScope scope = (ComponentScope)this.scopes.get(scopeId);
        if (scope != null) {
            scope.unload(this);
            if (scope.isRedundant()) {
                this.scopes.remove(scopeId);
            }
        }
    }

    public void addType(String scopeId, ClassIdentifier type, ComponentFactory factory) {
        ComponentScope scope = this.createScope(scopeId);
        scope.put(type, factory);
    }

    public void removeType(String scopeId, ClassIdentifier type) {
        ComponentScope scope = (ComponentScope)this.scopes.get(scopeId);
        if (scope != null) {
            scope.remove(type);
            if (scope.isRedundant()) {
                this.scopes.remove(scopeId);
            }
        }
    }

    public ComponentScope linkSubScope(String parentScope, ComponentScope child, int relationship) {
        ComponentScope scope = this.createScope(parentScope);
        scope.addChild(child, relationship);
        return scope;
    }

    public void unlinkSubScope(String parentScope, ComponentScope child) {
        ComponentScope scope = this.getScope(parentScope);
        if (scope != null) {
            scope.removeChild(child);
            if (scope.isRedundant()) {
                this.scopes.remove(parentScope);
            }
        }
    }

    private ComponentScope createScope(String scopeId) {
        ComponentScope result = this.getScope(scopeId);
        if (result == null) {
            result = new ComponentScope(scopeId);
            this.scopes.put(scopeId, result);
        }
        return result;
    }
}

