/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewLayout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.FastViewPane;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PageLayout;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PerspectiveHelper;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewLayoutRec;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewSashContainer;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveExtensionReader;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.views.IStickyViewDescriptor;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class Perspective {
    private PerspectiveDescriptor descriptor;
    protected WorkbenchPage page;
    protected LayoutPart editorArea;
    private PartPlaceholder editorHolder;
    private ViewFactory viewFactory;
    private ArrayList alwaysOnActionSets;
    private ArrayList alwaysOffActionSets;
    private ArrayList newWizardShortcuts;
    private ArrayList showViewShortcuts;
    private ArrayList perspectiveShortcuts;
    private ArrayList fastViews;
    private Map mapIDtoViewLayoutRec;
    private boolean fixed;
    private ArrayList showInPartIds;
    private HashMap showInTimes = new HashMap();
    private IViewReference activeFastView;
    private IMemento memento;
    protected PerspectiveHelper presentation;
    private static final String VERSION_STRING = "0.016";
    private FastViewPane fastViewPane = new FastViewPane();
    private static final int FASTVIEW_HIDE_STEPS = 5;
    private IWorkbenchPartReference oldPartRef = null;
    private boolean shouldHideEditorsOnActivate = false;

    public Perspective(PerspectiveDescriptor desc, WorkbenchPage page) throws WorkbenchException {
        this(page);
        this.descriptor = desc;
        if (desc != null) {
            this.createPresentation(desc);
        }
    }

    protected Perspective(WorkbenchPage page) throws WorkbenchException {
        this.page = page;
        this.editorArea = page.getEditorPresentation().getLayoutPart();
        this.viewFactory = page.getViewFactory();
        this.alwaysOnActionSets = new ArrayList(2);
        this.alwaysOffActionSets = new ArrayList(2);
        this.fastViews = new ArrayList(2);
        this.mapIDtoViewLayoutRec = new HashMap();
    }

    public void addFastView(IViewReference ref) {
        ViewPane pane = (ViewPane)((WorkbenchPartReference)((Object)ref)).getPane();
        if (!this.isFastView(ref)) {
            if (this.presentation.hasPlaceholder(ref.getId(), ref.getSecondaryId()) || pane.getContainer() != null) {
                this.presentation.removePart(pane);
            }
            this.fastViews.add(ref);
            pane.setFast(true);
            Control ctrl = pane.getControl();
            if (ctrl != null) {
                ctrl.setEnabled(false);
            }
        }
    }

    public boolean bringToTop(IViewReference ref) {
        if (this.isFastView(ref)) {
            this.setActiveFastView(ref);
            return true;
        }
        return this.presentation.bringPartToTop(this.getPane(ref));
    }

    public boolean canCloseView(IViewPart view) {
        ISaveablePart saveable;
        if (view instanceof ISaveablePart && (saveable = (ISaveablePart)((Object)view)).isSaveOnCloseNeeded()) {
            IWorkbenchWindow window = view.getSite().getWorkbenchWindow();
            return SaveableHelper.savePart(saveable, view, window, true);
        }
        return true;
    }

    public boolean containsView(IViewPart view) {
        IViewSite site = view.getViewSite();
        IViewReference ref = this.findView(site.getId(), site.getSecondaryId());
        if (ref == null) {
            return false;
        }
        return view == ref.getPart(false);
    }

    private void createInitialActionSets(List outputList, List stringList) {
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        Iterator iter = stringList.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            IActionSetDescriptor desc = reg.findActionSet(id);
            if (desc != null) {
                outputList.add(desc);
                continue;
            }
            WorkbenchPlugin.log("Unable to find Action Set: " + id);
        }
    }

    private void createPresentation(PerspectiveDescriptor persp) throws WorkbenchException {
        if (persp.hasCustomDefinition()) {
            this.loadCustomPersp(persp);
        } else {
            this.loadPredefinedPersp(persp);
        }
    }

    public void dispose() {
        if (this.presentation == null) {
            return;
        }
        this.presentation.deactivate();
        this.presentation.disposeSashes();
        this.fastViewPane.dispose();
        IViewReference[] refs = this.getViewReferences();
        int i = 0;
        int length = refs.length;
        while (i < length) {
            this.getViewFactory().releaseView(refs[i]);
            ++i;
        }
        this.mapIDtoViewLayoutRec.clear();
    }

    public IViewReference findView(String viewId) {
        return this.findView(viewId, null);
    }

    public IViewReference findView(String id, String secondaryId) {
        IViewReference[] refs = this.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IViewReference ref = refs[i];
            if (id.equals(ref.getId()) && (secondaryId == null ? ref.getSecondaryId() == null : secondaryId.equals(ref.getSecondaryId()))) {
                return ref;
            }
            ++i;
        }
        return null;
    }

    private Composite getClientComposite() {
        return this.page.getClientComposite();
    }

    public IPerspectiveDescriptor getDesc() {
        return this.descriptor;
    }

    Rectangle getFastViewBounds(IViewReference ref) {
        Rectangle bounds = this.page.getClientComposite().getBounds();
        float ratio = this.getFastViewWidthRatio(ref);
        bounds.width = (int)(ratio * (float)this.getClientComposite().getSize().x);
        return bounds;
    }

    public IViewReference[] getFastViews() {
        IViewReference[] array = new IViewReference[this.fastViews.size()];
        this.fastViews.toArray(array);
        return array;
    }

    public String[] getNewWizardShortcuts() {
        return this.newWizardShortcuts.toArray(new String[this.newWizardShortcuts.size()]);
    }

    private ViewPane getPane(IViewReference ref) {
        return (ViewPane)((WorkbenchPartReference)((Object)ref)).getPane();
    }

    public String[] getPerspectiveShortcuts() {
        return this.perspectiveShortcuts.toArray(new String[this.perspectiveShortcuts.size()]);
    }

    public PerspectiveHelper getPresentation() {
        return this.presentation;
    }

    private float getFastViewWidthRatio(IViewReference ref) {
        ViewLayoutRec rec = this.getViewLayoutRec(ref, true);
        if (rec.fastViewWidthRatio == -1.0f) {
            IViewRegistry reg = WorkbenchPlugin.getDefault().getViewRegistry();
            IViewDescriptor desc = reg.find(ref.getId());
            rec.fastViewWidthRatio = desc != null ? desc.getFastViewWidthRatio() : 0.3f;
        }
        return rec.fastViewWidthRatio;
    }

    public ArrayList getShowInPartIds() {
        return this.showInPartIds;
    }

    public long getShowInTime(String partId) {
        Long t = (Long)this.showInTimes.get(partId);
        return t == null ? 0L : t;
    }

    public String[] getShowViewShortcuts() {
        return this.showViewShortcuts.toArray(new String[this.showViewShortcuts.size()]);
    }

    private ViewFactory getViewFactory() {
        return this.viewFactory;
    }

    public void openTracker(ViewPane pane) {
        this.presentation.openTracker(pane);
    }

    public IViewReference[] getViewReferences() {
        if (this.presentation == null) {
            return new IViewReference[0];
        }
        ArrayList panes = new ArrayList(5);
        this.presentation.collectViewPanes(panes);
        IViewReference[] resultArray = new IViewReference[panes.size() + this.fastViews.size()];
        int nView = 0;
        int i = 0;
        while (i < this.fastViews.size()) {
            resultArray[nView] = (IViewReference)this.fastViews.get(i);
            ++nView;
            ++i;
        }
        i = 0;
        while (i < panes.size()) {
            ViewPane pane = (ViewPane)panes.get(i);
            resultArray[nView] = pane.getViewReference();
            ++nView;
            ++i;
        }
        return resultArray;
    }

    protected void hideEditorArea() {
        if (!this.isEditorAreaVisible()) {
            return;
        }
        this.editorHolder = new PartPlaceholder(this.editorArea.getID());
        this.presentation.getLayout().replace(this.editorArea, this.editorHolder);
    }

    private void hideFastView(IViewReference ref, int steps) {
        this.setFastViewIconSelection(ref, false);
        if (ref == this.activeFastView) {
            this.saveFastViewWidthRatio();
            this.fastViewPane.hideView();
        }
    }

    void hideFastViewSash() {
        this.fastViewPane.hideFastViewSash();
    }

    public boolean hideView(IViewReference ref) {
        ViewPane pane = this.getPane(ref);
        if (this.isFastView(ref)) {
            this.fastViews.remove(ref);
            if (pane != null) {
                pane.setFast(false);
            }
            if (this.activeFastView == ref) {
                this.setActiveFastView(null);
            }
            if (pane != null) {
                pane.getControl().setEnabled(true);
            }
        } else {
            this.presentation.removePart(pane);
        }
        this.getViewFactory().releaseView(ref);
        return true;
    }

    protected boolean isEditorAreaVisible() {
        return this.editorHolder == null;
    }

    public boolean isFastView(IViewReference ref) {
        return this.fastViews.contains(ref);
    }

    private ViewLayoutRec getViewLayoutRec(IViewReference ref, boolean create) {
        return this.getViewLayoutRec(ViewFactory.getKey(ref), create);
    }

    private ViewLayoutRec getViewLayoutRec(String viewId, boolean create) {
        ViewLayoutRec rec = (ViewLayoutRec)this.mapIDtoViewLayoutRec.get(viewId);
        if (rec == null && create) {
            rec = new ViewLayoutRec();
            this.mapIDtoViewLayoutRec.put(viewId, rec);
        }
        return rec;
    }

    public boolean isFixedLayout() {
        return this.fixed;
    }

    public boolean isStandaloneView(IViewReference ref) {
        ViewLayoutRec rec = this.getViewLayoutRec(ref, false);
        return rec != null && rec.isStandalone;
    }

    public boolean getShowTitleView(IViewReference ref) {
        ViewLayoutRec rec = this.getViewLayoutRec(ref, false);
        return rec != null && rec.showTitle;
    }

    private void loadCustomPersp(PerspectiveDescriptor persp) {
        PerspectiveRegistry perspRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        try {
            IMemento memento = perspRegistry.getCustomPersp(persp.getId());
            MultiStatus status = new MultiStatus("org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.Perspective_unableToRestorePerspective, (Object)persp.getLabel()), null);
            status.merge(this.restoreState(memento));
            status.merge(this.restoreState());
            if (status.getSeverity() != 0) {
                this.unableToOpenPerspective(persp, (IStatus)status);
            }
        }
        catch (IOException iOException) {
            this.unableToOpenPerspective(persp, null);
        }
        catch (WorkbenchException e) {
            this.unableToOpenPerspective(persp, e.getStatus());
        }
    }

    private void unableToOpenPerspective(PerspectiveDescriptor persp, IStatus status) {
        PerspectiveRegistry perspRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        perspRegistry.deletePerspective(persp);
        persp.deleteCustomDefinition();
        String title = WorkbenchMessages.Perspective_problemRestoringTitle;
        String msg = WorkbenchMessages.Perspective_errorReadingState;
        if (status == null) {
            MessageDialog.openError(null, (String)title, (String)msg);
        } else {
            ErrorDialog.openError(null, (String)title, (String)msg, (IStatus)status);
        }
    }

    private void loadPredefinedPersp(PerspectiveDescriptor persp) throws WorkbenchException {
        IPerspectiveFactory factory = null;
        try {
            factory = persp.createFactory();
        }
        catch (CoreException coreException) {
            throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.Perspective_unableToLoad, (Object)persp.getId()));
        }
        if (factory == null) {
            throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.Perspective_unableToLoad, (Object)persp.getId()));
        }
        ViewSashContainer container = new ViewSashContainer(this.page);
        PageLayout layout = new PageLayout(container, this.getViewFactory(), this.editorArea, this.descriptor);
        layout.setFixed(this.descriptor.getFixed());
        IPlaceholderFolderLayout stickyFolderRight = null;
        IPlaceholderFolderLayout stickyFolderLeft = null;
        IPlaceholderFolderLayout stickyFolderTop = null;
        IPlaceholderFolderLayout stickyFolderBottom = null;
        IStickyViewDescriptor[] descs = WorkbenchPlugin.getDefault().getViewRegistry().getStickyViews();
        int i = 0;
        while (i < descs.length) {
            IStickyViewDescriptor stickyViewDescriptor = descs[i];
            String id = stickyViewDescriptor.getId();
            switch (stickyViewDescriptor.getLocation()) {
                case 2: {
                    if (stickyFolderRight == null) {
                        stickyFolderRight = layout.createPlaceholderFolder("stickyFolderRight", 2, 0.75f, "org.eclipse.ui.editorss");
                    }
                    stickyFolderRight.addPlaceholder(id);
                    break;
                }
                case 1: {
                    if (stickyFolderLeft == null) {
                        stickyFolderLeft = layout.createPlaceholderFolder("stickyFolderLeft", 1, 0.25f, "org.eclipse.ui.editorss");
                    }
                    stickyFolderLeft.addPlaceholder(id);
                    break;
                }
                case 3: {
                    if (stickyFolderTop == null) {
                        stickyFolderTop = layout.createPlaceholderFolder("stickyFolderTop", 3, 0.25f, "org.eclipse.ui.editorss");
                    }
                    stickyFolderTop.addPlaceholder(id);
                    break;
                }
                case 4: {
                    if (stickyFolderBottom == null) {
                        stickyFolderBottom = layout.createPlaceholderFolder("stickyFolderBottom", 4, 0.75f, "org.eclipse.ui.editorss");
                    }
                    stickyFolderBottom.addPlaceholder(id);
                }
            }
            IViewLayout viewLayout = layout.getViewLayout(id);
            viewLayout.setCloseable(stickyViewDescriptor.isCloseable());
            viewLayout.setMoveable(stickyViewDescriptor.isMoveable());
            ++i;
        }
        factory.createInitialLayout(layout);
        PerspectiveExtensionReader extender = new PerspectiveExtensionReader();
        extender.extendLayout(this.page.getExtensionTracker(), this.descriptor.getId(), layout);
        this.mapIDtoViewLayoutRec.putAll(layout.getIDtoViewLayoutRecMap());
        ArrayList temp = new ArrayList();
        this.createInitialActionSets(temp, layout.getActionSets());
        Iterator iter = temp.iterator();
        while (iter.hasNext()) {
            IActionSetDescriptor descriptor = (IActionSetDescriptor)iter.next();
            this.addAlwaysOn(descriptor);
        }
        this.newWizardShortcuts = layout.getNewWizardShortcuts();
        this.showViewShortcuts = layout.getShowViewShortcuts();
        this.perspectiveShortcuts = layout.getPerspectiveShortcuts();
        this.showInPartIds = layout.getShowInPartIds();
        this.fastViews = layout.getFastViews();
        this.fixed = layout.isFixed();
        this.presentation = new PerspectiveHelper(this.page, container, this);
        if (!layout.isEditorAreaVisible()) {
            this.hideEditorArea();
        }
    }

    private void removeAlwaysOn(IActionSetDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        if (!this.alwaysOnActionSets.contains(descriptor)) {
            return;
        }
        this.alwaysOnActionSets.remove(descriptor);
        if (this.page != null) {
            this.page.perspectiveActionSetChanged(this, descriptor, 3);
        }
    }

    private void addAlwaysOff(IActionSetDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        if (this.alwaysOffActionSets.contains(descriptor)) {
            return;
        }
        this.alwaysOffActionSets.add(descriptor);
        if (this.page != null) {
            this.page.perspectiveActionSetChanged(this, descriptor, 0);
        }
        this.removeAlwaysOn(descriptor);
    }

    private void addAlwaysOn(IActionSetDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        if (this.alwaysOnActionSets.contains(descriptor)) {
            return;
        }
        this.alwaysOnActionSets.add(descriptor);
        if (this.page != null) {
            this.page.perspectiveActionSetChanged(this, descriptor, 2);
        }
        this.removeAlwaysOff(descriptor);
    }

    private void removeAlwaysOff(IActionSetDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        if (!this.alwaysOffActionSets.contains(descriptor)) {
            return;
        }
        this.alwaysOffActionSets.remove(descriptor);
        if (this.page != null) {
            this.page.perspectiveActionSetChanged(this, descriptor, 1);
        }
    }

    protected void onActivate() {
        if (this.editorArea.getControl() != null) {
            this.editorArea.setVisible(this.isEditorAreaVisible());
        }
        int i = 0;
        while (i < this.fastViews.size()) {
            ViewPane pane = this.getPane((IViewReference)this.fastViews.get(i));
            if (pane != null) {
                Control ctrl = pane.getControl();
                if (ctrl == null) {
                    pane.createControl(this.getClientComposite());
                    ctrl = pane.getControl();
                }
                ctrl.setEnabled(false);
            }
            ++i;
        }
        this.setAllPinsVisible(true);
        this.presentation.activate(this.getClientComposite());
        if (this.shouldHideEditorsOnActivate) {
            this.hideEditorArea();
            this.shouldHideEditorsOnActivate = false;
        }
    }

    protected void onDeactivate() {
        this.presentation.deactivate();
        this.setActiveFastView(null);
        this.setAllPinsVisible(false);
        int i = 0;
        while (i < this.fastViews.size()) {
            Control ctrl;
            ViewPane pane = this.getPane((IViewReference)this.fastViews.get(i));
            if (pane != null && (ctrl = pane.getControl()) != null) {
                ctrl.setEnabled(true);
            }
            ++i;
        }
    }

    public void partActivated(IWorkbenchPart activePart) {
        if (this.activeFastView != null && this.activeFastView.getPart(false) != activePart) {
            this.setActiveFastView(null);
        }
    }

    public void performedShowIn(String partId) {
        this.showInTimes.put(partId, new Long(System.currentTimeMillis()));
    }

    public void removeFastView(IViewReference ref) {
        ViewPane pane = this.getPane(ref);
        if (this.isFastView(ref)) {
            if (this.activeFastView == ref) {
                this.setActiveFastView(null);
            }
            this.fastViews.remove(ref);
            pane.setFast(false);
            Control ctrl = pane.getControl();
            if (ctrl != null) {
                ctrl.setEnabled(true);
            }
            this.presentation.addPart(pane);
        }
    }

    public IStatus restoreState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsRestoringPerspective, null);
        this.descriptor = new PerspectiveDescriptor(null, null, null);
        result.add(this.descriptor.restoreState(memento));
        PerspectiveDescriptor desc = (PerspectiveDescriptor)WorkbenchPlugin.getDefault().getPerspectiveRegistry().findPerspectiveWithId(this.descriptor.getId());
        if (desc != null) {
            this.descriptor = desc;
        }
        this.memento = memento;
        IMemento[] views = memento.getChildren("view");
        result.merge(this.createReferences(views));
        memento = memento.getChild("fastViews");
        if (memento != null) {
            views = memento.getChildren("view");
            result.merge(this.createReferences(views));
        }
        return result;
    }

    private IStatus createReferences(IMemento[] views) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsRestoringViews, null);
        int x = 0;
        while (x < views.length) {
            IMemento childMem = views[x];
            String id = childMem.getString("id");
            if (!id.equals("org.eclipse.ui.internal.introview")) {
                String secondaryId = ViewFactory.extractSecondaryId(id);
                if (secondaryId != null) {
                    id = ViewFactory.extractPrimaryId(id);
                }
                try {
                    if (!"true".equals(childMem.getString("removed"))) {
                        this.viewFactory.createView(id, secondaryId);
                    }
                }
                catch (PartInitException e) {
                    childMem.putString("removed", "true");
                    result.add(StatusUtil.newStatus(4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)((Object)e)));
                }
            }
            ++x;
        }
        return result;
    }

    public IStatus restoreState() {
        String id;
        IActionSetDescriptor d;
        String actionSetID;
        if (this.memento == null) {
            return new Status(0, "org.eclipse.ui", 0, "", null);
        }
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsRestoringPerspective, null);
        IMemento memento = this.memento;
        this.memento = null;
        IMemento boundsMem = memento.getChild("window");
        if (boundsMem != null) {
            Rectangle r = new Rectangle(0, 0, 0, 0);
            r.x = boundsMem.getInteger("x");
            r.y = boundsMem.getInteger("y");
            r.height = boundsMem.getInteger("height");
            r.width = boundsMem.getInteger("width");
            if (this.page.getWorkbenchWindow().getPages().length == 0) {
                this.page.getWorkbenchWindow().getShell().setBounds(r);
            }
        }
        ViewSashContainer mainLayout = new ViewSashContainer(this.page);
        PerspectiveHelper pres = new PerspectiveHelper(this.page, mainLayout, this);
        result.merge(pres.restoreState(memento.getChild("layout")));
        pres.replacePlaceholderWithPart(this.editorArea);
        IMemento[] views = memento.getChildren("view");
        int x = 0;
        while (x < views.length) {
            IMemento childMem = views[x];
            String id2 = childMem.getString("id");
            String secondaryId = ViewFactory.extractSecondaryId(id2);
            if (secondaryId != null) {
                id2 = ViewFactory.extractPrimaryId(id2);
            }
            if (!id2.equals("org.eclipse.ui.internal.introview")) {
                IViewReference viewRef = this.viewFactory.getView(id2, secondaryId);
                WorkbenchPartReference ref = (WorkbenchPartReference)((Object)viewRef);
                if (ref == null) {
                    String key = ViewFactory.getKey(id2, secondaryId);
                    result.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.Perspective_couldNotFind, (Object)key), null));
                } else {
                    boolean willPartBeVisible = pres.willPartBeVisible(ref.getId(), secondaryId);
                    if (willPartBeVisible) {
                        IViewPart view = (IViewPart)ref.getPart(true);
                        if (view != null) {
                            ViewSite site = (ViewSite)view.getSite();
                            ViewPane pane = (ViewPane)site.getPane();
                            pres.replacePlaceholderWithPart(pane);
                        }
                    } else {
                        pres.replacePlaceholderWithPart(ref.getPane());
                    }
                }
            }
            ++x;
        }
        IMemento fastViewsMem = memento.getChild("fastViews");
        if (fastViewsMem != null) {
            views = fastViewsMem.getChildren("view");
            int x2 = 0;
            while (x2 < views.length) {
                IViewReference viewRef;
                WorkbenchPartReference ref;
                IMemento childMem = views[x2];
                String viewID = childMem.getString("id");
                String secondaryId = ViewFactory.extractSecondaryId(viewID);
                if (secondaryId != null) {
                    viewID = ViewFactory.extractPrimaryId(viewID);
                }
                if ((ref = (WorkbenchPartReference)((Object)(viewRef = this.viewFactory.getView(viewID, secondaryId)))) == null) {
                    String key = ViewFactory.getKey(viewID, secondaryId);
                    WorkbenchPlugin.log("Could not create view: '" + key + "'.");
                    result.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.Perspective_couldNotFind, (Object)key), null));
                } else {
                    Float ratio = childMem.getFloat("ratio");
                    if (ratio == null) {
                        Integer viewWidth = childMem.getInteger("width");
                        ratio = viewWidth == null ? new Float(0.3f) : new Float((float)viewWidth.intValue() / (float)this.getClientComposite().getSize().x);
                    }
                    ViewLayoutRec rec = this.getViewLayoutRec(viewRef, true);
                    rec.fastViewWidthRatio = ratio.floatValue();
                    this.fastViews.add(ref);
                }
                ++x2;
            }
        }
        IMemento[] recMementos = memento.getChildren("viewLayoutRec");
        int i = 0;
        while (i < recMementos.length) {
            IMemento recMemento = recMementos[i];
            String compoundId = recMemento.getString("id");
            if (compoundId != null) {
                ViewLayoutRec rec = this.getViewLayoutRec(compoundId, true);
                if ("false".equals(recMemento.getString("closeable"))) {
                    rec.isCloseable = false;
                }
                if ("false".equals(recMemento.getString("moveable"))) {
                    rec.isMoveable = false;
                }
                if ("true".equals(recMemento.getString("standalone"))) {
                    rec.isStandalone = true;
                    rec.showTitle = !"false".equals(recMemento.getString("showTitle"));
                }
            }
            ++i;
        }
        HashSet<String> knownActionSetIds = new HashSet<String>();
        IMemento[] actions = memento.getChildren("alwaysOnActionSet");
        int x3 = 0;
        while (x3 < actions.length) {
            actionSetID = actions[x3].getString("id");
            d = WorkbenchPlugin.getDefault().getActionSetRegistry().findActionSet(actionSetID);
            if (d != null) {
                this.addAlwaysOn(d);
                knownActionSetIds.add(actionSetID);
            }
            ++x3;
        }
        actions = memento.getChildren("alwaysOffActionSet");
        x3 = 0;
        while (x3 < actions.length) {
            actionSetID = actions[x3].getString("id");
            d = WorkbenchPlugin.getDefault().getActionSetRegistry().findActionSet(actionSetID);
            if (d != null) {
                this.addAlwaysOff(d);
                knownActionSetIds.add(actionSetID);
            }
            ++x3;
        }
        actions = memento.getChildren("show_view_action");
        this.showViewShortcuts = new ArrayList(actions.length);
        x3 = 0;
        while (x3 < actions.length) {
            id = actions[x3].getString("id");
            this.showViewShortcuts.add(id);
            ++x3;
        }
        actions = memento.getChildren("show_in_time");
        x3 = 0;
        while (x3 < actions.length) {
            id = actions[x3].getString("id");
            String timeStr = actions[x3].getString("time");
            if (id != null && timeStr != null) {
                try {
                    long time = Long.parseLong(timeStr);
                    this.showInTimes.put(id, new Long(time));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++x3;
        }
        this.showInPartIds = this.getShowInIdsFromRegistry();
        actions = memento.getChildren("new_wizard_action");
        this.newWizardShortcuts = new ArrayList(actions.length);
        x3 = 0;
        while (x3 < actions.length) {
            id = actions[x3].getString("id");
            this.newWizardShortcuts.add(id);
            ++x3;
        }
        actions = memento.getChildren("perspective_action");
        this.perspectiveShortcuts = new ArrayList(actions.length);
        x3 = 0;
        while (x3 < actions.length) {
            id = actions[x3].getString("id");
            this.perspectiveShortcuts.add(id);
            ++x3;
        }
        ArrayList extActionSets = this.getPerspectiveExtensionActionSets();
        int i2 = 0;
        while (i2 < extActionSets.size()) {
            IActionSetDescriptor d2;
            String actionSetID2 = (String)extActionSets.get(i2);
            if (!knownActionSetIds.contains(actionSetID2) && (d2 = WorkbenchPlugin.getDefault().getActionSetRegistry().findActionSet(actionSetID2)) != null) {
                this.addAlwaysOn(d2);
                knownActionSetIds.add(d2.getId());
            }
            ++i2;
        }
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] array = reg.getActionSets();
        int count = array.length;
        int i3 = 0;
        while (i3 < count) {
            IActionSetDescriptor desc = array[i3];
            if (!knownActionSetIds.contains(desc.getId()) && desc.isInitiallyVisible()) {
                this.addActionSet(desc);
            }
            ++i3;
        }
        this.presentation = pres;
        Integer areaVisible = memento.getInteger("editorAreaVisible");
        this.shouldHideEditorsOnActivate = areaVisible != null && areaVisible == 0;
        Integer isFixed = memento.getInteger("fixed");
        this.fixed = isFixed != null && isFixed == 1;
        return result;
    }

    private ArrayList getPerspectiveExtensionActionSets() {
        PerspectiveExtensionReader reader = new PerspectiveExtensionReader();
        reader.setIncludeOnlyTags(new String[]{"actionSet"});
        PageLayout layout = new PageLayout();
        reader.extendLayout(null, this.descriptor.getOriginalId(), layout);
        return layout.getActionSets();
    }

    private ArrayList getShowInIdsFromRegistry() {
        PerspectiveExtensionReader reader = new PerspectiveExtensionReader();
        reader.setIncludeOnlyTags(new String[]{"showInPart"});
        PageLayout layout = new PageLayout();
        reader.extendLayout(null, this.descriptor.getOriginalId(), layout);
        return layout.getShowInPartIds();
    }

    public void saveDesc() {
        this.saveDescAs(this.descriptor);
    }

    public void saveDescAs(IPerspectiveDescriptor desc) {
        PerspectiveDescriptor realDesc = (PerspectiveDescriptor)desc;
        PerspectiveRegistry perspRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        XMLMemento memento = XMLMemento.createWriteRoot("perspective");
        IStatus status = this.saveState(memento, realDesc, false);
        if (status.getSeverity() == 4) {
            ErrorDialog.openError(null, (String)WorkbenchMessages.Perspective_problemSavingTitle, (String)WorkbenchMessages.Perspective_problemSavingMessage, (IStatus)status);
            return;
        }
        try {
            perspRegistry.saveCustomPersp(realDesc, memento);
            this.descriptor = realDesc;
        }
        catch (IOException iOException) {
            perspRegistry.deletePerspective(realDesc);
            MessageDialog.openError(null, (String)WorkbenchMessages.Perspective_problemSavingTitle, (String)WorkbenchMessages.Perspective_problemSavingMessage);
        }
    }

    public IStatus saveState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsSavingPerspective, null);
        result.merge(this.saveState(memento, this.descriptor, true));
        return result;
    }

    private IStatus saveState(IMemento memento, PerspectiveDescriptor p, boolean saveInnerViewState) {
        IMemento childMem;
        IMemento viewMemento;
        IViewReference ref;
        String str;
        IMemento child;
        IActionSetDescriptor desc;
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsSavingPerspective, null);
        if (this.memento != null) {
            memento.putMemento(this.memento);
            return result;
        }
        memento.putString("version", VERSION_STRING);
        result.add(p.saveState(memento));
        if (!saveInnerViewState) {
            Rectangle bounds = this.page.getWorkbenchWindow().getShell().getBounds();
            IMemento boundsMem = memento.createChild("window");
            boundsMem.putInteger("x", bounds.x);
            boundsMem.putInteger("y", bounds.y);
            boundsMem.putInteger("height", bounds.height);
            boundsMem.putInteger("width", bounds.width);
        }
        Iterator<Object> itr = this.alwaysOnActionSets.iterator();
        while (itr.hasNext()) {
            desc = (IActionSetDescriptor)itr.next();
            child = memento.createChild("alwaysOnActionSet");
            child.putString("id", desc.getId());
        }
        itr = this.alwaysOffActionSets.iterator();
        while (itr.hasNext()) {
            desc = (IActionSetDescriptor)itr.next();
            child = memento.createChild("alwaysOffActionSet");
            child.putString("id", desc.getId());
        }
        itr = this.showViewShortcuts.iterator();
        while (itr.hasNext()) {
            str = (String)itr.next();
            child = memento.createChild("show_view_action");
            child.putString("id", str);
        }
        itr = this.showInTimes.keySet().iterator();
        while (itr.hasNext()) {
            String id = (String)itr.next();
            Long time = (Long)this.showInTimes.get(id);
            IMemento child2 = memento.createChild("show_in_time");
            child2.putString("id", id);
            child2.putString("time", time.toString());
        }
        itr = this.newWizardShortcuts.iterator();
        while (itr.hasNext()) {
            str = (String)itr.next();
            child = memento.createChild("new_wizard_action");
            child.putString("id", str);
        }
        itr = this.perspectiveShortcuts.iterator();
        while (itr.hasNext()) {
            str = (String)itr.next();
            child = memento.createChild("perspective_action");
            child.putString("id", str);
        }
        ArrayList viewPanes = new ArrayList(5);
        this.presentation.collectViewPanes(viewPanes);
        itr = viewPanes.iterator();
        int errors = 0;
        while (itr.hasNext()) {
            ViewPane pane = (ViewPane)itr.next();
            ref = pane.getViewReference();
            viewMemento = memento.createChild("view");
            viewMemento.putString("id", ViewFactory.getKey(ref));
        }
        if (this.fastViews.size() > 0) {
            childMem = memento.createChild("fastViews");
            itr = this.fastViews.iterator();
            while (itr.hasNext()) {
                ref = (IViewReference)itr.next();
                viewMemento = childMem.createChild("view");
                String id = ViewFactory.getKey(ref);
                viewMemento.putString("id", id);
                float ratio = this.getFastViewWidthRatio(ref);
                viewMemento.putFloat("ratio", ratio);
            }
        }
        Iterator i = this.mapIDtoViewLayoutRec.keySet().iterator();
        while (i.hasNext()) {
            String compoundId = (String)i.next();
            ViewLayoutRec rec = (ViewLayoutRec)this.mapIDtoViewLayoutRec.get(compoundId);
            if (rec == null || rec.isCloseable && rec.isMoveable && !rec.isStandalone) continue;
            IMemento layoutMemento = memento.createChild("viewLayoutRec");
            layoutMemento.putString("id", compoundId);
            if (!rec.isCloseable) {
                layoutMemento.putString("closeable", "false");
            }
            if (!rec.isMoveable) {
                layoutMemento.putString("moveable", "false");
            }
            if (!rec.isStandalone) continue;
            layoutMemento.putString("standalone", "true");
            layoutMemento.putString("showTitle", String.valueOf(rec.showTitle));
        }
        if (errors > 0) {
            String message = WorkbenchMessages.Perspective_multipleErrors;
            if (errors == 1) {
                message = WorkbenchMessages.Perspective_oneError;
            }
            MessageDialog.openError(null, (String)WorkbenchMessages.Error, (String)message);
        }
        childMem = memento.createChild("layout");
        result.add(this.presentation.saveState(childMem));
        if (this.isEditorAreaVisible()) {
            memento.putInteger("editorAreaVisible", 1);
        } else {
            memento.putInteger("editorAreaVisible", 0);
        }
        if (this.fixed) {
            memento.putInteger("fixed", 1);
        } else {
            memento.putInteger("fixed", 0);
        }
        return result;
    }

    public void turnOnActionSets(IActionSetDescriptor[] newArray) {
        int i = 0;
        while (i < newArray.length) {
            IActionSetDescriptor descriptor = newArray[i];
            this.addAlwaysOn(descriptor);
            ++i;
        }
    }

    public void turnOffActionSets(IActionSetDescriptor[] toDisable) {
        int i = 0;
        while (i < toDisable.length) {
            IActionSetDescriptor descriptor = toDisable[i];
            this.turnOffActionSet(descriptor);
            ++i;
        }
    }

    public void turnOffActionSet(IActionSetDescriptor toDisable) {
        this.addAlwaysOff(toDisable);
    }

    public IViewReference getActiveFastView() {
        return this.activeFastView;
    }

    void setActiveFastView(IViewReference ref, int steps) {
        ViewPane pane;
        if (this.activeFastView == ref) {
            return;
        }
        if (this.activeFastView != null && (pane = this.getPane(this.activeFastView)) != null) {
            if (pane.isZoomed()) {
                this.presentation.zoomOut();
            }
            this.hideFastView(this.activeFastView, steps);
        }
        this.activeFastView = ref;
        try {
            if (this.activeFastView != null && !this.showFastView(this.activeFastView)) {
                this.activeFastView = null;
            }
        }
        catch (RuntimeException runtimeException) {
            this.activeFastView = null;
        }
    }

    void setActiveFastView(IViewReference ref) {
        this.setActiveFastView(ref, 5);
    }

    private void setAllPinsVisible(boolean visible) {
        Iterator iter = this.fastViews.iterator();
        while (iter.hasNext()) {
            ViewPane pane = this.getPane((IViewReference)iter.next());
            if (pane == null) continue;
            pane.setFast(visible);
        }
    }

    private void setFastViewIconSelection(IViewReference ref, boolean selected) {
        WorkbenchWindow window = (WorkbenchWindow)this.page.getWorkbenchWindow();
        FastViewBar bar = window.getFastViewBar();
        if (bar != null) {
            if (selected) {
                bar.setSelection(ref);
            } else if (ref == bar.getSelection()) {
                bar.setSelection(null);
            }
        }
    }

    public void setNewWizardActionIds(ArrayList newList) {
        this.newWizardShortcuts = newList;
    }

    public void setPerspectiveActionIds(ArrayList list) {
        this.perspectiveShortcuts = list;
    }

    public void setShowInPartIds(ArrayList list) {
        this.showInPartIds = list;
    }

    public void setShowViewActionIds(ArrayList list) {
        this.showViewShortcuts = list;
    }

    protected void showEditorArea() {
        if (this.isEditorAreaVisible()) {
            return;
        }
        this.presentation.getLayout().replace(this.editorHolder, this.editorArea);
        this.editorHolder = null;
    }

    boolean showFastView(IViewReference ref) {
        if (ref.getPart(true) == null) {
            return false;
        }
        ViewPane pane = this.getPane(ref);
        if (pane == null) {
            return false;
        }
        this.saveFastViewWidthRatio();
        WorkbenchWindow window = (WorkbenchWindow)this.page.getWorkbenchWindow();
        FastViewBar bar = window.getFastViewBar();
        if (bar == null) {
            return false;
        }
        int side = bar.getViewSide(ref);
        this.fastViewPane.showView(this.getClientComposite(), pane, side, this.getFastViewWidthRatio(ref));
        this.setFastViewIconSelection(ref, true);
        return true;
    }

    private void saveFastViewWidthRatio() {
        ViewPane pane = this.fastViewPane.getCurrentPane();
        if (pane != null) {
            ViewLayoutRec rec = this.getViewLayoutRec(pane.getViewReference(), true);
            rec.fastViewWidthRatio = this.fastViewPane.getCurrentRatio();
        }
    }

    public IViewPart showView(String viewId, String secondaryId) throws PartInitException {
        ViewFactory factory = this.getViewFactory();
        IViewReference ref = factory.createView(viewId, secondaryId);
        IViewPart part = (IViewPart)ref.getPart(true);
        if (part == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.ViewFactory_couldNotCreate, (Object)ref.getId()));
        }
        ViewSite site = (ViewSite)part.getSite();
        ViewPane pane = (ViewPane)site.getPane();
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        int openViewMode = store.getInt("OPEN_VIEW_MODE");
        if (openViewMode == 1) {
            this.showFastView(ref);
            this.addFastView(ref);
        } else if (openViewMode == 2 && this.presentation.canDetach()) {
            this.presentation.addDetachedPart(pane);
        } else {
            this.presentation.addPart(pane);
        }
        return part;
    }

    public void toggleFastView(IViewReference ref) {
        if (ref == this.activeFastView) {
            this.setActiveFastView(null);
        } else {
            this.setActiveFastView(ref);
        }
    }

    public IWorkbenchPartReference getOldPartRef() {
        return this.oldPartRef;
    }

    public void setOldPartRef(IWorkbenchPartReference oldPartRef) {
        this.oldPartRef = oldPartRef;
    }

    void moveFastView(IViewReference draggedView, IViewReference destinationView) {
        if (draggedView == destinationView) {
            return;
        }
        int insertIdx = this.fastViews.indexOf(destinationView);
        this.fastViews.remove(draggedView);
        if (insertIdx < 0 || insertIdx >= this.fastViews.size()) {
            this.fastViews.add(draggedView);
        } else {
            this.fastViews.add(insertIdx, draggedView);
        }
    }

    void addActionSet(IActionSetDescriptor newDesc) {
        int i = 0;
        while (i < this.alwaysOnActionSets.size()) {
            IActionSetDescriptor desc = (IActionSetDescriptor)this.alwaysOnActionSets.get(i);
            if (desc.getId().equals(newDesc.getId())) {
                this.removeAlwaysOn(desc);
                this.removeAlwaysOff(desc);
                break;
            }
            ++i;
        }
        this.addAlwaysOn(newDesc);
    }

    void removeActionSet(String id) {
        IActionSetDescriptor desc;
        int i = 0;
        while (i < this.alwaysOnActionSets.size()) {
            desc = (IActionSetDescriptor)this.alwaysOnActionSets.get(i);
            if (desc.getId().equals(id)) {
                this.removeAlwaysOn(desc);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.alwaysOffActionSets.size()) {
            desc = (IActionSetDescriptor)this.alwaysOffActionSets.get(i);
            if (desc.getId().equals(id)) {
                this.removeAlwaysOff(desc);
                break;
            }
            ++i;
        }
    }

    void removeActionSet(IActionSetDescriptor toRemove) {
        this.removeAlwaysOn(toRemove);
        this.removeAlwaysOff(toRemove);
    }

    public void setFastViewState(int newState) {
        this.fastViewPane.setState(newState);
    }

    public int getFastViewState() {
        return this.fastViewPane.getState();
    }

    public boolean isCloseable(IViewReference reference) {
        ViewLayoutRec rec = this.getViewLayoutRec(reference, false);
        if (rec != null) {
            return rec.isCloseable;
        }
        return true;
    }

    public boolean isMoveable(IViewReference reference) {
        ViewLayoutRec rec = this.getViewLayoutRec(reference, false);
        if (rec != null) {
            return rec.isMoveable;
        }
        return true;
    }

    public void describeLayout(StringBuffer buf) {
        IViewReference[] fastViews = this.getFastViews();
        if (fastViews.length != 0) {
            buf.append("fastviews (");
            int idx = 0;
            while (idx < fastViews.length) {
                IViewReference ref = fastViews[idx];
                if (idx > 0) {
                    buf.append(", ");
                }
                buf.append(ref.getPartName());
                ++idx;
            }
            buf.append("), ");
        }
        this.getPresentation().describeLayout(buf);
    }

    public void testInvariants() {
        this.getPresentation().getLayout().testInvariants();
    }

    public IActionSetDescriptor[] getAlwaysOnActionSets() {
        return this.alwaysOnActionSets.toArray(new IActionSetDescriptor[this.alwaysOnActionSets.size()]);
    }

    public IActionSetDescriptor[] getAlwaysOffActionSets() {
        return this.alwaysOffActionSets.toArray(new IActionSetDescriptor[this.alwaysOffActionSets.size()]);
    }

    FastViewPane getFastViewPane() {
        return this.fastViewPane;
    }
}

