/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logtransfer.ejb.mdb;

import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.factory.SelectLogTransfer;
import com.clustercontrol.logtransfer.message.DeleteLogTransferInfo;
import com.clustercontrol.logtransfer.util.SendTopic;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.repository.message.UpdateRepositoryInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageLogTransferFileBean
implements MessageDrivenBean,
MessageListener {
    protected static Log m_log = LogFactory.getLog(ManageLogTransferFileBean.class);
    private static HashMap<String, ArrayList<String>> m_facilityIdsMap = null;
    private static HashMap<String, ArrayList<LogTransferFileInfo>> m_fileInfoMap = null;
    private MessageDrivenContext messageContext = null;

    public void setMessageDrivenContext(MessageDrivenContext messageContext) throws EJBException {
        this.messageContext = messageContext;
    }

    public void ejbCreate() {
        this.refreshCache();
    }

    public void ejbRemove() {
        this.messageContext = null;
    }

    public void onMessage(Message message) {
        m_log.debug((Object)("Message Driven Bean got message " + message));
        if (m_facilityIdsMap == null || m_fileInfoMap == null) {
            this.refreshCache();
        }
        try {
            if (message instanceof ObjectMessage) {
                ObjectMessage objectMessage = (ObjectMessage)message;
                Serializable obj = objectMessage.getObject();
                if (obj instanceof LogTransferInfo) {
                    m_log.debug((Object)"onMessage(): ObjectMessage is LogTransferInfo.");
                    LogTransferInfo info = (LogTransferInfo)obj;
                    this.merge(info);
                } else if (obj instanceof DeleteLogTransferInfo) {
                    m_log.debug((Object)"onMessage(): ObjectMessage is DeleteLogTransferInfo.");
                    DeleteLogTransferInfo info = (DeleteLogTransferInfo)obj;
                    this.merge(info);
                } else if (obj instanceof UpdateRepositoryInfo) {
                    m_log.debug((Object)"onMessage(): ObjectMessage is UpdateReopsitoryInfo.");
                    UpdateRepositoryInfo info = (UpdateRepositoryInfo)obj;
                    this.mergeRepositoryInfo(info);
                } else {
                    m_log.debug((Object)("onMessage(): ObjectMessage is not an expected instance. " + obj.toString()));
                }
            } else if (message instanceof TextMessage) {
                m_log.debug((Object)"onMessage(): ObjectMessage is TextMessage.");
                TextMessage textMessage = (TextMessage)message;
                String facilityId = textMessage.getText();
                this.notify(facilityId);
            }
        }
        catch (JMSException e) {
            m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
        }
        catch (EJBException e) {
            m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
        }
    }

    public void merge(LogTransferInfo info) {
        if (info == null) {
            return;
        }
        String transferId = info.getTransferId();
        String facilityId = info.getFacilityId();
        ArrayList<LogTransferFileInfo> fileInfoList = info.getFileInfo();
        ArrayList<LogTransferFileInfo> fileInfoListCache = m_fileInfoMap.get(transferId);
        ArrayList<String> facilityIdListCache = m_facilityIdsMap.get(transferId);
        try {
            ArrayList facilityIdList = null;
            RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
            if (repository.isNode(facilityId)) {
                facilityIdList = new ArrayList();
                facilityIdList.add(facilityId);
            } else {
                facilityIdList = repository.getNodeFacilityIdList(facilityId, 0);
            }
            ArrayList<String> delFacilityIdList = new ArrayList<String>();
            if (facilityIdListCache != null) {
                delFacilityIdList.addAll(facilityIdListCache);
                delFacilityIdList.removeAll(facilityIdList);
            }
            ArrayList<LogTransferFileInfo> updateFileInfoList = new ArrayList<LogTransferFileInfo>();
            if (fileInfoListCache != null) {
                boolean targetFlg = false;
                for (LogTransferFileInfo logFileInfoCache : fileInfoListCache) {
                    String filePath = logFileInfoCache.getFilePath();
                    for (LogTransferFileInfo fileInfo : fileInfoList) {
                        if (!filePath.equals(fileInfo.getFilePath())) continue;
                        targetFlg = true;
                        break;
                    }
                    if (!targetFlg) {
                        updateFileInfoList.add(logFileInfoCache);
                    }
                    targetFlg = false;
                }
                if (updateFileInfoList.size() != 0) {
                    updateFileInfoList = this.setValid(updateFileInfoList, 0);
                }
            }
            if (fileInfoListCache != null) {
                if (info.getValid() == 0) {
                    delFacilityIdList.addAll(facilityIdList);
                }
                if (delFacilityIdList.size() != 0) {
                    ArrayList<LogTransferFileInfo> delFileInfoListByFacility = this.setValid(fileInfoListCache, 0);
                    m_log.debug((Object)"onMessage(): \u524a\u9664\u3059\u308b\u30ed\u30b0\u8ee2\u9001\u60c5\u5831\u3092\u9001\u4fe1");
                    this.sendTopic(delFacilityIdList, delFileInfoListByFacility, false);
                }
            }
            if (info.getValid() == 1) {
                updateFileInfoList.addAll(fileInfoList);
                m_log.debug((Object)"onMessage(): \u30ed\u30b0\u8ee2\u9001\u60c5\u5831\u3092\u9001\u4fe1(\u30ed\u30b0\u8ee2\u9001\u60c5\u5831\u304c\u6709\u52b9\u3067\u3042\u308b\u5834\u5408)");
                this.sendTopic(facilityIdList, updateFileInfoList, false);
            } else if (fileInfoListCache == null) {
                if (info.getValid() == 0) {
                    fileInfoList = this.setValid(fileInfoList, 0);
                }
                m_log.debug((Object)"onMessage(): \u30ed\u30b0\u8ee2\u9001\u60c5\u5831\u3092\u9001\u4fe1(\u30ed\u30b0\u8ee2\u9001\u60c5\u5831\u304c\u7121\u52b9\u3067\u65b0\u898f\u6295\u5165\u306e\u5834\u5408)");
                this.sendTopic(facilityIdList, fileInfoList, false);
            }
            m_log.debug((Object)"onMessage(): \u30ad\u30e3\u30c3\u30b7\u30e5\u306e\u66f4\u65b0\u3092\u884c\u3044\u307e\u3059\u3002");
            m_facilityIdsMap.put(transferId, facilityIdList);
            if (info.getValid() == 0) {
                fileInfoList = this.setValid(fileInfoList, 0);
            }
            m_fileInfoMap.put(transferId, fileInfoList);
        }
        catch (Exception e) {
            m_log.error((Object)("onMessage(): \u30ed\u30b0\u8ee2\u9001\u60c5\u5831\u78ba\u8a8d\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + e.getMessage()));
        }
    }

    public void merge(DeleteLogTransferInfo info) {
        if (info == null) {
            return;
        }
        String transferId = info.getTransferId();
        ArrayList<String> facilityIdList = m_facilityIdsMap.get(transferId);
        ArrayList<LogTransferFileInfo> fileInfoList = m_fileInfoMap.get(transferId);
        this.delete(transferId, facilityIdList, fileInfoList);
    }

    public void mergeRepositoryInfo(UpdateRepositoryInfo info) {
        if (info == null) {
            return;
        }
        HashMap<String, ArrayList<String>> facilityIdsMap = null;
        try {
            facilityIdsMap = new SelectLogTransfer().getFacilityIdsMap();
        }
        catch (CreateException e) {
            m_log.error((Object)("onMessage() : " + e.getMessage()));
        }
        catch (FinderException e) {
            m_log.error((Object)("onMessage() : " + e.getMessage()));
        }
        catch (NamingException e) {
            m_log.error((Object)("onMessage() : " + e.getMessage()));
        }
        if (facilityIdsMap == null) {
            return;
        }
        Set<String> keySet = facilityIdsMap.keySet();
        for (String transferId : keySet) {
            ArrayList<String> facilityIdList = facilityIdsMap.get(transferId);
            ArrayList<String> facilityIdListCache = m_facilityIdsMap.get(transferId);
            ArrayList<String> delFacilityIdList = new ArrayList<String>(facilityIdListCache);
            delFacilityIdList.removeAll(facilityIdList);
            ArrayList<String> addFacilityIdList = new ArrayList<String>(facilityIdList);
            addFacilityIdList.removeAll(facilityIdListCache);
            if (delFacilityIdList.size() != 0) {
                ArrayList<LogTransferFileInfo> fileInfoList = this.setValid(m_fileInfoMap.get(transferId), 0);
                this.sendTopic(delFacilityIdList, fileInfoList, false);
            }
            if (addFacilityIdList.size() == 0) continue;
            this.sendTopic(addFacilityIdList, m_fileInfoMap.get(transferId), false);
        }
        m_facilityIdsMap = facilityIdsMap;
    }

    public void notify(String facilityId) {
        if (facilityId == null || "".equals(facilityId)) {
            return;
        }
        ArrayList<LogTransferFileInfo> fileInfoList = new ArrayList<LogTransferFileInfo>();
        Set<String> keySet = m_facilityIdsMap.keySet();
        for (String transferId : keySet) {
            ArrayList<String> facilityIdList = m_facilityIdsMap.get(transferId);
            if (!facilityIdList.contains(facilityId)) continue;
            fileInfoList.addAll((Collection<LogTransferFileInfo>)m_fileInfoMap.get(transferId));
        }
        ArrayList<String> facilityIdList = new ArrayList<String>();
        facilityIdList.add(facilityId);
        this.sendTopic(facilityIdList, fileInfoList, true);
    }

    public void delete(String transferId, ArrayList<String> facilityIdList, ArrayList<LogTransferFileInfo> fileInfoList) {
        ArrayList<LogTransferFileInfo> delFileInfoList = this.setValid(fileInfoList, 0);
        this.sendTopic(facilityIdList, delFileInfoList, false);
        m_facilityIdsMap.remove(transferId);
        m_fileInfoMap.remove(transferId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTopic(ArrayList<String> facilityIdList, ArrayList<LogTransferFileInfo> fileInfoList, boolean initFlg) {
        if (facilityIdList == null || fileInfoList == null) {
            return;
        }
        SendTopic send = null;
        String facilityId = null;
        try {
            send = new SendTopic("topic/clustercontrol/Logtransfer/update");
            for (int index = 0; index < facilityIdList.size(); ++index) {
                facilityId = facilityIdList.get(index);
                if (facilityId == null || "".equals(facilityId)) continue;
                m_log.debug((Object)("onMessage() : \u30ed\u30b0\u8ee2\u9001\u60c5\u5831\u9001\u4fe1 : facilityId=" + facilityId));
                send.put(facilityId, fileInfoList, initFlg);
            }
        }
        catch (Exception e) {
            m_log.error((Object)("onMessage() : \u30ed\u30b0\u8ee2\u9001\u60c5\u5831\u9001\u4fe1\u30a8\u30e9\u30fc : facilityId=" + facilityId + ", " + e.getMessage()));
        }
        finally {
            if (send != null) {
                try {
                    send.terminate();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean refreshCache() {
        try {
            SelectLogTransfer select = new SelectLogTransfer();
            m_log.debug((Object)"refreshCache(): \u30ad\u30e3\u30c3\u30b7\u30e5\u306e\u30ea\u30d5\u30ec\u30c3\u30b7\u30e5\u3092\u884c\u3044\u307e\u3059\u3002");
            m_facilityIdsMap = select.getFacilityIdsMap();
            m_fileInfoMap = select.getLogTransferFileInfoMap();
            return true;
        }
        catch (CreateException e) {
            m_log.error((Object)("Could not get cache. " + e.getMessage()), (Throwable)e);
            return false;
        }
        catch (FinderException e) {
            m_log.error((Object)("Could not get cache. " + e.getMessage()), (Throwable)e);
            return false;
        }
        catch (NamingException e) {
            m_log.error((Object)("Could not get cache. " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public ArrayList<LogTransferFileInfo> setValid(ArrayList<LogTransferFileInfo> fileInfoList, int valid) {
        ArrayList<LogTransferFileInfo> retFileInfoList = new ArrayList<LogTransferFileInfo>();
        for (int index = 0; index < fileInfoList.size(); ++index) {
            LogTransferFileInfo oldInfo = fileInfoList.get(index);
            retFileInfoList.add(new LogTransferFileInfo(oldInfo.getTransferId(), oldInfo.getFilePath(), oldInfo.getRunInterval(), oldInfo.getExistenceFlg(), valid));
        }
        return retFileInfoList;
    }
}

