/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.ejb.mdb;

import com.clustercontrol.monitor.factory.OutputEventLog;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.monitor.message.LogOutputJobRunInfo;
import com.clustercontrol.monitor.util.RunJob;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunJobBean
implements MessageDrivenBean,
MessageListener {
    protected static Log m_log = LogFactory.getLog(RunJobBean.class);
    private MessageDrivenContext messageContext = null;

    public void setMessageDrivenContext(MessageDrivenContext messageContext) throws EJBException {
        this.messageContext = messageContext;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
        this.messageContext = null;
    }

    public void onMessage(Message message) {
        block11: {
            m_log.debug((Object)("Message Driven Bean got message " + message));
            if (message instanceof ObjectMessage) {
                ObjectMessage msg = (ObjectMessage)message;
                try {
                    Serializable objMsg = msg.getObject();
                    if (objMsg instanceof LogOutputInfo) {
                        try {
                            RunJob job = new RunJob((LogOutputInfo)objMsg);
                            job.run();
                        }
                        catch (Throwable e) {
                            LogOutputInfo info = (LogOutputInfo)objMsg;
                            LogOutputJobRunInfo jobRunInfo = info.getJobRun();
                            info.setPriority(jobRunInfo.getJobFailurePriority());
                            info.setMessageId("");
                            Object[] args1 = new String[]{jobRunInfo.getJobId()};
                            info.setMessage(Messages.getString((String)"message.monitor.41", (Object[])args1));
                            info.setMessageOrg("");
                            OutputEventLog eventLog = new OutputEventLog();
                            Date now = new Date();
                            eventLog.setOutputDate(new Timestamp(now.getTime()));
                            try {
                                eventLog.insertEventLog(info, 0);
                                break block11;
                            }
                            catch (NamingException e1) {
                                break block11;
                            }
                            catch (CreateException e1) {}
                        }
                        break block11;
                    }
                    m_log.debug((Object)("onMessage(): ObjectMessage is not an expected instance. " + objMsg.toString()));
                }
                catch (JMSException e) {
                    m_log.error((Object)("onMessage():" + e.getMessage()));
                }
                catch (EJBException e) {
                    m_log.error((Object)("onMessage():" + e.getMessage()));
                }
                catch (Exception e) {
                    m_log.error((Object)("onMessage():" + e.getMessage()));
                }
            }
        }
    }
}

