/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.dialog;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.calendar.composite.CalendarIdListComposite;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.common.composite.JobIdSelectionListener;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.syslogng.action.LogManager;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.util.Messages;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LogCreateDialog
extends CommonDialog {
    private LogFilterInfo inputData = null;
    private ValidateResult validateResult = null;
    private String logId = null;
    private int order = Integer.MAX_VALUE;
    private String facilityId = null;
    private Text textDescription = null;
    private Text textScope = null;
    private Text textPattern = null;
    private Button radioNotProcessing = null;
    private Button radioProcessing = null;
    private CalendarIdListComposite calendarId = null;
    private NotifyInfoComposite notifyInfo = null;
    private Label labelPriority = null;
    private Combo comboPriority = null;
    private Label labelMonitorId = null;
    private Text textMonitorId = null;
    private Label labelMessageId = null;
    private Text textMessageId = null;
    private Label labelLogMessage = null;
    private Text textLogMessage = null;
    private Button m_checkJobRun = null;
    private Text m_textJobId = null;
    private Button m_buttonRefer = null;
    private Button m_checkInhibitionFlg = null;
    private Combo m_comboFailurePriority = null;
    private Button confirmValid = null;
    private Date regDate = null;
    private boolean modify = false;

    public LogCreateDialog(Shell parent) {
        super(parent);
    }

    public LogCreateDialog(Shell parent, String logId) {
        super(parent);
        this.logId = logId;
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.syslog-ng.create.modefy"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        this.labelMonitorId = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.labelMonitorId.setLayoutData((Object)gridData);
        this.labelMonitorId.setText(String.valueOf(Messages.getString((String)"monitor.id")) + " : ");
        this.textMonitorId = new Text(parent, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textMonitorId.setLayoutData((Object)gridData);
        this.textMonitorId.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"description")) + " : ");
        this.textDescription = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gridData);
        this.textDescription.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        this.labelMonitorId = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.labelMonitorId.setLayoutData((Object)gridData);
        this.labelMonitorId.setText(String.valueOf(Messages.getString((String)"monitor.rule")) + " : ");
        Group monitorRuleGroup1 = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        monitorRuleGroup1.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        monitorRuleGroup1.setLayoutData((Object)gridData);
        this.calendarId = new CalendarIdListComposite((Composite)monitorRuleGroup1, 0, true);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.calendarId.setLayoutData((Object)gridData);
        label = new Label((Composite)monitorRuleGroup1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"check.rule")) + " : ");
        Group groupCheckRule = new Group((Composite)monitorRuleGroup1, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"scope")) + " : ");
        this.textScope = new Text((Composite)groupCheckRule, 18440);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textScope.setLayoutData((Object)gridData);
        Button button = new Button((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(Messages.getString((String)"refer"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeTreeDialog dialog = new ScopeTreeDialog(LogCreateDialog.this.getParentShell(), false, true);
                if (dialog.open() == 0) {
                    FacilityTreeItem item = dialog.getSelectItem();
                    FacilityInfo info = item.getData();
                    LogCreateDialog.this.facilityId = info.getFacilityId();
                    if (info.getType() == 1) {
                        LogCreateDialog.this.textScope.setText(info.getFacilityName());
                    } else {
                        FacilityPath path = new FacilityPath(ClusterControlPlugin.getDefault().getSeparator());
                        LogCreateDialog.this.textScope.setText(path.getPath(item));
                    }
                }
            }
        });
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"pattern.matching.expression")) + " : ");
        this.textPattern = new Text((Composite)groupCheckRule, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textPattern.setLayoutData((Object)gridData);
        this.textPattern.addVerifyListener((VerifyListener)new StringVerifyListener(1024));
        this.radioNotProcessing = new Button(parent, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.radioNotProcessing.setLayoutData((Object)gridData);
        this.radioNotProcessing.setText(Messages.getString((String)"don't.process.if.matched"));
        this.radioProcessing = new Button(parent, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.radioProcessing.setLayoutData((Object)gridData);
        this.radioProcessing.setText(Messages.getString((String)"process.if.matched"));
        this.radioProcessing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogCreateDialog.this.setEnabledForOutputCondition(LogCreateDialog.this.radioProcessing.getSelection());
            }
        });
        Group group1 = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        group1.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        group1.setLayoutData((Object)gridData);
        this.notifyInfo = new NotifyInfoComposite((Composite)group1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.notifyInfo.setLayoutData((Object)gridData);
        this.labelPriority = new Label((Composite)group1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.labelPriority.setLayoutData((Object)gridData);
        this.labelPriority.setText(String.valueOf(Messages.getString((String)"priority")) + " : ");
        this.comboPriority = new Combo((Composite)group1, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboPriority.setLayoutData((Object)gridData);
        this.comboPriority.add(PriorityConstant.STRING_CRITICAL);
        this.comboPriority.add(PriorityConstant.STRING_WARNING);
        this.comboPriority.add(PriorityConstant.STRING_INFO);
        this.comboPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.comboPriority.setText(PriorityConstant.STRING_CRITICAL);
        label = new Label((Composite)group1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 7;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.labelMessageId = new Label((Composite)group1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.labelMessageId.setLayoutData((Object)gridData);
        this.labelMessageId.setText(String.valueOf(Messages.getString((String)"message.id")) + " : ");
        this.textMessageId = new Text((Composite)group1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textMessageId.setLayoutData((Object)gridData);
        this.textMessageId.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        this.labelLogMessage = new Label((Composite)group1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.labelLogMessage.setLayoutData((Object)gridData);
        this.labelLogMessage.setText(String.valueOf(Messages.getString((String)"message")) + " : ");
        this.textLogMessage = new Text((Composite)group1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textLogMessage.setLayoutData((Object)gridData);
        this.textLogMessage.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        this.m_checkJobRun = new Button((Composite)group1, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_checkJobRun.setLayoutData((Object)gridData);
        this.m_checkJobRun.setText(String.valueOf(Messages.getString((String)"run")) + " : ");
        this.m_checkJobRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogCreateDialog.this.m_textJobId.setEnabled(LogCreateDialog.this.m_checkJobRun.getSelection());
                LogCreateDialog.this.m_buttonRefer.setEnabled(LogCreateDialog.this.m_checkJobRun.getSelection());
                LogCreateDialog.this.m_checkInhibitionFlg.setEnabled(LogCreateDialog.this.m_checkJobRun.getSelection());
                LogCreateDialog.this.m_comboFailurePriority.setEnabled(LogCreateDialog.this.m_checkJobRun.getSelection());
            }
        });
        Group groupRunJob = new Group((Composite)group1, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupRunJob.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupRunJob.setLayoutData((Object)gridData);
        label = new Label((Composite)groupRunJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"job.id"));
        label = new Label((Composite)groupRunJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupRunJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"couple.with.notify.inhibition"));
        label = new Label((Composite)groupRunJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupRunJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"failure.call.value"));
        label = new Label((Composite)groupRunJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_textJobId = new Text((Composite)groupRunJob, 18440);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textJobId.setLayoutData((Object)gridData);
        this.m_buttonRefer = new Button((Composite)groupRunJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonRefer.setLayoutData((Object)gridData);
        this.m_buttonRefer.setText(Messages.getString((String)"refer"));
        this.m_buttonRefer.addSelectionListener((SelectionListener)new JobIdSelectionListener(this.m_textJobId));
        label = new Label((Composite)groupRunJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_checkInhibitionFlg = new Button((Composite)groupRunJob, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.m_checkInhibitionFlg.setLayoutData((Object)gridData);
        label = new Label((Composite)groupRunJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_comboFailurePriority = new Combo((Composite)groupRunJob, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboFailurePriority.setLayoutData((Object)gridData);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_WARNING);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_INFO);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_comboFailurePriority.setText(PriorityConstant.STRING_UNKNOWN);
        label = new Label((Composite)groupRunJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.confirmValid = new Button(parent, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.confirmValid.setLayoutData((Object)gridData);
        this.confirmValid.setText(Messages.getString((String)"setting.valid.confirmed"));
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData((Object)gridData);
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        LogFilterInfo log = LogManager.getInstance().get(this.logId);
        if (log == null) {
            log = new LogFilterInfo();
            this.modify = false;
        } else {
            this.modify = true;
        }
        this.setInputData(log);
    }

    public LogFilterInfo getInputData() {
        return this.inputData;
    }

    protected void setInputData(LogFilterInfo log) {
        this.inputData = log;
        this.logId = log.getLogId();
        this.order = log.getOrderNo();
        this.facilityId = log.getFacilityId();
        if (log.getMonitorId() != null) {
            this.textMonitorId.setText(log.getMonitorId());
        }
        if (log.getDescription() != null) {
            this.textDescription.setText(log.getDescription());
        }
        if (log.getCalendarId() != null) {
            this.calendarId.setText(log.getCalendarId());
        }
        if (log.getScope() != null) {
            this.textScope.setText(log.getScope());
        }
        if (log.getPattern() != null) {
            this.textPattern.setText(log.getPattern());
        }
        if (log.getProcessType() == 1) {
            this.radioProcessing.setSelection(true);
        } else {
            this.radioNotProcessing.setSelection(true);
        }
        if (log.getNotifyId() != null) {
            this.notifyInfo.setText(log.getNotifyId());
        }
        this.comboPriority.setText(PriorityConstant.typeToString((int)log.getPriority()));
        if (log.getApplication() != null) {
            this.notifyInfo.setApplication(log.getApplication());
        }
        if (log.getMessageId() != null) {
            this.textMessageId.setText(log.getMessageId());
        }
        if (log.getMessage() != null) {
            this.textLogMessage.setText(log.getMessage());
        }
        this.m_checkJobRun.setSelection(YesNoConstant.typeToBoolean((int)log.getJobRun()));
        if (log.getJobId() != null) {
            this.m_textJobId.setText(log.getJobId());
        }
        this.m_checkInhibitionFlg.setSelection(YesNoConstant.typeToBoolean((int)log.getJobInhibitionFlg()));
        this.m_comboFailurePriority.setText(PriorityConstant.typeToString((int)log.getJobFailurePriority()));
        if (log.isValidFlg()) {
            this.confirmValid.setSelection(true);
        }
        this.regDate = log.getRegDate();
        this.setEnabledForOutputCondition(this.radioProcessing.getSelection());
    }

    protected LogFilterInfo createInputData() {
        LogFilterInfo log = new LogFilterInfo();
        log.setLogId(this.logId);
        log.setOrderNo(this.order);
        log.setFacilityId(this.facilityId);
        if (this.textMonitorId.getText() != null && !"".equals(this.textMonitorId.getText().trim())) {
            log.setMonitorId(this.textMonitorId.getText());
        } else if (this.radioProcessing.getSelection()) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.1"));
            return null;
        }
        if (this.textDescription.getText() == null || "".equals(this.textDescription.getText().trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.26"));
            return null;
        }
        log.setDescription(this.textDescription.getText());
        String calendarId = this.calendarId.getText();
        if (calendarId != null && !"".equals(calendarId.trim())) {
            log.setCalendarId(calendarId);
        }
        if (this.textScope.getText() == null || "".equals(this.textScope.getText().trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.hinemos.3"));
            return null;
        }
        log.setScope(this.textScope.getText());
        if (this.textPattern.getText() != null && !"".equals(this.textPattern.getText().trim())) {
            try {
                Pattern.compile(this.textPattern.getText());
                log.setPattern(this.textPattern.getText());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.27"));
                return null;
            }
        } else {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.27"));
            return null;
        }
        if (this.radioProcessing.getSelection()) {
            log.setProcessType(1);
        } else {
            log.setProcessType(0);
        }
        String priorityText = this.comboPriority.getText();
        log.setPriority(PriorityConstant.stringToType((String)priorityText));
        String notifyId = this.notifyInfo.getText();
        if (notifyId != null && !"".equals(notifyId.trim())) {
            log.setNotifyId(notifyId);
        }
        if (this.notifyInfo.getApplication() != null && !"".equals(this.notifyInfo.getApplication().trim())) {
            log.setApplication(this.notifyInfo.getApplication());
        } else if (this.radioProcessing.getSelection() && notifyId != null && !"".equals(notifyId.trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.10"));
            return null;
        }
        if (this.textMessageId.getText() != null && !"".equals(this.textMessageId.getText().trim())) {
            log.setMessageId(this.textMessageId.getText());
        } else if (this.radioProcessing.getSelection() && notifyId != null && !"".equals(notifyId.trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.28"));
            return null;
        }
        if (this.textLogMessage.getText() != null && !"".equals(this.textLogMessage.getText().trim())) {
            log.setMessage(this.textLogMessage.getText());
        } else if (this.radioProcessing.getSelection() && notifyId != null && !"".equals(notifyId.trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.29"));
            return null;
        }
        log.setJobRun(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_checkJobRun.getSelection())).intValue());
        if (this.m_textJobId.getText() != null && !"".equals(this.m_textJobId.getText().trim())) {
            log.setJobId(this.m_textJobId.getText());
        } else if (log.getJobRun() == 1) {
            Object[] args = new String[]{""};
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.25", (Object[])args));
            return null;
        }
        log.setJobInhibitionFlg(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_checkInhibitionFlg.getSelection())).intValue());
        log.setJobFailurePriority(PriorityConstant.stringToType((String)this.m_comboFailurePriority.getText()));
        if (this.confirmValid.getSelection()) {
            log.setValidFlg(true);
        } else {
            log.setValidFlg(false);
        }
        log.setRegDate(this.regDate);
        return log;
    }

    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return this.validateResult;
    }

    protected boolean action() {
        boolean result = false;
        LogFilterInfo info = this.inputData;
        if (info != null) {
            result = !this.modify ? LogManager.getInstance().add(info) : LogManager.getInstance().modify(info);
        }
        return result;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private void setEnabledForOutputCondition(boolean enable) {
        this.comboPriority.setEnabled(enable);
        this.notifyInfo.setEnabled(enable);
        this.textMessageId.setEnabled(enable);
        this.textLogMessage.setEnabled(enable);
        this.m_checkJobRun.setEnabled(enable);
        this.m_textJobId.setEnabled(enable);
        this.m_buttonRefer.setEnabled(enable);
        this.m_checkInhibitionFlg.setEnabled(enable);
        this.m_comboFailurePriority.setEnabled(enable);
    }

    private void setValidateResult(String id, String message) {
        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }
}

