/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.mail.dialog;

import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.composite.StyledTextComposite;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.notify.mail.action.AddMailTemplate;
import com.clustercontrol.notify.mail.action.GetMailTemplate;
import com.clustercontrol.notify.mail.action.ModifyMailTemplate;
import com.clustercontrol.notify.mail.bean.MailTemplateParameterConstant;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoData;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MailTemplateCreateDialog
extends CommonDialog {
    public static final int WIDTH = 15;
    public static final int WIDTH_LABEL = 4;
    public static final int WIDTH_TEXT = 10;
    private MailTemplateInfoData inputData = null;
    private ValidateResult validateResult = null;
    private boolean referenceFlg = false;
    private String mailTemplateId = null;
    private Text textMailTemplateId = null;
    private Text textDescription = null;
    private StyledTextComposite textSubject = null;
    private StyledTextComposite textBody = null;

    public MailTemplateCreateDialog(Shell parent) {
        super(parent);
    }

    public MailTemplateCreateDialog(Shell parent, String mailTemplateId, boolean referenceFlg) {
        super(parent);
        this.mailTemplateId = mailTemplateId;
        this.referenceFlg = referenceFlg;
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString("dialog.mail.template.create.modify"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("mail.template.id")) + " : ");
        this.textMailTemplateId = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textMailTemplateId.setLayoutData((Object)gridData);
        if (this.mailTemplateId != null && !"".equals(this.mailTemplateId.trim())) {
            this.textMailTemplateId.setEnabled(false);
        }
        this.textMailTemplateId.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("description")) + " : ");
        this.textDescription = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gridData);
        this.textDescription.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("mail.template.setting")) + " : ");
        Group groupMailTemplate = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        groupMailTemplate.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupMailTemplate.setLayoutData((Object)gridData);
        label = new Label((Composite)groupMailTemplate, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("subject")) + " : ");
        this.textSubject = new StyledTextComposite((Composite)groupMailTemplate, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 13;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textSubject.setLayoutData(gridData);
        this.textSubject.setColor(new Color((Device)groupMailTemplate.getDisplay(), new RGB(0, 0, 255)));
        this.textSubject.setKeywords(MailTemplateParameterConstant.getParameterList());
        this.textSubject.setInputUpper(256);
        label = new Label((Composite)groupMailTemplate, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("response.body")) + " : ");
        this.textBody = new StyledTextComposite((Composite)groupMailTemplate, 19202);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.verticalSpan = 50;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.textBody.setLayoutData(gridData);
        this.textBody.setColor(new Color((Device)groupMailTemplate.getDisplay(), new RGB(0, 0, 255)));
        this.textBody.setKeywords(MailTemplateParameterConstant.getParameterList());
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        line.setLayoutData((Object)gridData);
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        MailTemplateInfoData info = null;
        info = this.mailTemplateId != null ? new GetMailTemplate().getMailTemplate(this.mailTemplateId) : new MailTemplateInfoData();
        this.setInputData(info);
    }

    public MailTemplateInfoData getInputData() {
        return this.inputData;
    }

    protected void setInputData(MailTemplateInfoData mailTemplate) {
        this.inputData = mailTemplate;
        if (mailTemplate.getMailTemplateId() != null) {
            this.textMailTemplateId.setText(mailTemplate.getMailTemplateId());
        }
        if (mailTemplate.getDescription() != null) {
            this.textDescription.setText(mailTemplate.getDescription());
        }
        if (mailTemplate.getSubject() != null) {
            this.textSubject.setText(mailTemplate.getSubject());
        }
        if (mailTemplate.getBody() != null) {
            this.textBody.setText(mailTemplate.getBody());
        }
        if (this.referenceFlg) {
            this.textMailTemplateId.setEnabled(false);
            this.textDescription.setEnabled(false);
            this.textSubject.setEnabled(false);
            this.textBody.setEnabled(false);
        }
    }

    protected MailTemplateInfoData createInputData() {
        MailTemplateInfoData info = new MailTemplateInfoData();
        if (this.textMailTemplateId.getText() == null || "".equals(this.textMailTemplateId.getText().trim())) {
            this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.mail.template.9"));
            return null;
        }
        info.setMailTemplateId(this.textMailTemplateId.getText());
        if (this.textDescription.getText() != null && !"".equals(this.textDescription.getText().trim())) {
            info.setDescription(this.textDescription.getText());
        }
        if (this.textSubject.getText() != null && !"".equals(this.textSubject.getText().trim())) {
            info.setSubject(this.textSubject.getText());
        }
        if (this.textBody.getText() != null && !"".equals(this.textBody.getText().trim())) {
            info.setBody(this.textBody.getText());
        }
        return info;
    }

    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return this.validateResult;
    }

    protected boolean action() {
        boolean result = false;
        MailTemplateInfoData info = this.getInputData();
        if (info != null) {
            result = this.mailTemplateId == null ? new AddMailTemplate().add(info) : new ModifyMailTemplate().modify(info);
        }
        return result;
    }

    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

    private void setValidateResult(String id, String message) {
        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.referenceFlg) {
            super.createButtonsForButtonBar(parent);
        } else {
            this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
        }
    }
}

