/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.notify.action.DeleteNotify;
import com.clustercontrol.notify.composite.NotifyListComposite;
import com.clustercontrol.notify.dialog.NotifyCreateDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class NotifyListDialog
extends CommonDialog {
    private NotifyListComposite notifyList = null;
    private Button buttonAdd = null;
    private Button buttonModify = null;
    private Button buttonDelete = null;

    public NotifyListDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Point getInitialSize() {
        return new Point(800, 350);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString("dialog.notify.list"));
        GridLayout layout = new GridLayout(8, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 8;
        parent.setLayout((Layout)layout);
        this.notifyList = new NotifyListComposite(parent, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 7;
        this.notifyList.setLayoutData(gridData);
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        this.buttonAdd = this.createButton(composite, Messages.getString("add"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog dialog = new NotifyCreateDialog(NotifyListDialog.this.getParentShell());
                if (dialog.open() == 0) {
                    NotifyListDialog.this.notifyList.update();
                }
            }
        });
        new Label(composite, 0);
        this.buttonModify = this.createButton(composite, Messages.getString("modify"));
        this.buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String notifyId = null;
                Table table = NotifyListDialog.this.notifyList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        notifyId = (String)((ArrayList)item[0].getData()).get(0);
                    }
                    catch (Exception exception) {}
                }
                if (notifyId != null) {
                    NotifyCreateDialog dialog = new NotifyCreateDialog(NotifyListDialog.this.getParentShell(), notifyId, false);
                    if (dialog.open() == 0) {
                        int selectIndex = table.getSelectionIndex();
                        NotifyListDialog.this.notifyList.update();
                        table.setSelection(selectIndex);
                    }
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString("warning"), (String)Messages.getString("message.notify.8"));
                }
            }
        });
        new Label(composite, 0);
        this.buttonDelete = this.createButton(composite, Messages.getString("delete"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String notifyId = null;
                Table table = NotifyListDialog.this.notifyList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        notifyId = (String)((ArrayList)item[0].getData()).get(0);
                    }
                    catch (Exception exception) {}
                }
                if (notifyId != null) {
                    Object[] args = new String[]{notifyId};
                    if (MessageDialog.openConfirm(null, (String)Messages.getString("confirmed"), (String)Messages.getString("message.notify.7", args))) {
                        boolean result = new DeleteNotify().delete(notifyId);
                        if (result) {
                            MessageDialog.openInformation(null, (String)Messages.getString("successful"), (String)Messages.getString("message.notify.5", args));
                            NotifyListDialog.this.notifyList.update();
                        } else {
                            MessageDialog.openError(null, (String)Messages.getString("failed"), (String)Messages.getString("message.notify.6", args));
                        }
                    }
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString("warning"), (String)Messages.getString("message.notify.9"));
                }
            }
        });
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    protected ValidateResult validate() {
        return super.validate();
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(label);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }
}

