/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.composite;

import com.clustercontrol.notify.action.GetNotify;
import com.clustercontrol.notify.dialog.NotifyCreateDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NotifyIdListComposite
extends Composite {
    private String m_text = null;
    private Label m_labelNotifyId = null;
    private Combo m_comboNotifyId = null;
    private Button m_buttonRefer = null;

    public NotifyIdListComposite(Composite parent, int style, boolean labelFlg) {
        super(parent, style);
        this.m_text = Messages.getString("notify.id");
        this.initialize(parent, labelFlg);
    }

    public NotifyIdListComposite(Composite parent, int style, String text) {
        super(parent, style);
        this.m_text = text;
        this.initialize(parent, true);
    }

    private void initialize(Composite parent, boolean labelFlg) {
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = labelFlg ? 15 : 10;
        this.setLayout((Layout)layout);
        if (labelFlg) {
            this.m_labelNotifyId = new Label((Composite)this, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 5;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.m_labelNotifyId.setLayoutData((Object)gridData);
            this.m_labelNotifyId.setText(String.valueOf(this.m_text) + " : ");
        }
        this.m_comboNotifyId = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboNotifyId.setLayoutData((Object)gridData);
        this.m_buttonRefer = new Button((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonRefer.setLayoutData((Object)gridData);
        this.m_buttonRefer.setText(Messages.getString("refer"));
        this.m_buttonRefer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String notifyId = NotifyIdListComposite.this.m_comboNotifyId.getText();
                if (notifyId != null && !"".equals(notifyId.trim())) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    NotifyCreateDialog dialog = new NotifyCreateDialog(shell, notifyId, true);
                    dialog.open();
                }
            }
        });
        this.update();
    }

    public void update() {
        this.m_comboNotifyId.add("");
        ArrayList list = new GetNotify().getNotifyIdList();
        if (list != null) {
            int index = 0;
            while (index < list.size()) {
                this.m_comboNotifyId.add((String)list.get(index));
                ++index;
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.m_comboNotifyId.setEnabled(enabled);
        this.m_buttonRefer.setEnabled(enabled);
    }

    public String getText() {
        return this.m_comboNotifyId.getText();
    }

    public void setText(String string) {
        this.m_comboNotifyId.setText(string);
    }
}

