/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTruthValueInfo;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TruthValueInfoComposite
extends Composite {
    public static final int WIDTH_TITLE = 5;
    public static final int WIDTH_VALUE = 2;
    private String m_itemTrue = null;
    private String m_itemFalse = null;
    private Combo m_comboTrue = null;
    private Combo m_comboFalse = null;
    private Combo m_comboFailurePriority = null;

    public TruthValueInfoComposite(Composite parent, int style, boolean rangeFlg, String itemTrue, String itemFalse) {
        super(parent, style);
        this.m_itemTrue = itemTrue;
        this.m_itemFalse = itemFalse;
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("successful.select.value")) + " : ");
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("value"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("priority"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(this.m_itemTrue) + " : ");
        this.m_comboTrue = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboTrue.setLayoutData((Object)gridData);
        this.m_comboTrue.add(PriorityConstant.STRING_CRITICAL);
        this.m_comboTrue.add(PriorityConstant.STRING_WARNING);
        this.m_comboTrue.add(PriorityConstant.STRING_INFO);
        this.m_comboTrue.add(PriorityConstant.STRING_UNKNOWN);
        this.m_comboTrue.setText(PriorityConstant.STRING_INFO);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(this.m_itemFalse) + " : ");
        this.m_comboFalse = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboFalse.setLayoutData((Object)gridData);
        this.m_comboFalse.add(PriorityConstant.STRING_CRITICAL);
        this.m_comboFalse.add(PriorityConstant.STRING_WARNING);
        this.m_comboFalse.add(PriorityConstant.STRING_INFO);
        this.m_comboFalse.add(PriorityConstant.STRING_UNKNOWN);
        this.m_comboFalse.setText(PriorityConstant.STRING_CRITICAL);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("failure.select.value")) + " : ");
        this.m_comboFailurePriority = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboFailurePriority.setLayoutData((Object)gridData);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_WARNING);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_INFO);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_comboFailurePriority.setText(PriorityConstant.STRING_WARNING);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    public void setInputData(MonitorInfo info) {
        if (info != null) {
            ArrayList list = info.getJudgementInfo();
            if (list != null) {
                int index = 0;
                while (index < list.size()) {
                    MonitorTruthValueInfo truthValueInfo = (MonitorTruthValueInfo)list.get(index);
                    if (truthValueInfo != null) {
                        if (truthValueInfo.getTruthValue() == 1) {
                            this.m_comboTrue.setText(PriorityConstant.typeToString(truthValueInfo.getPriority()));
                        } else if (truthValueInfo.getTruthValue() == 0) {
                            this.m_comboFalse.setText(PriorityConstant.typeToString(truthValueInfo.getPriority()));
                        }
                    }
                    ++index;
                }
            }
            this.m_comboFailurePriority.setText(PriorityConstant.typeToString(info.getFailurePriority()));
        }
    }

    public ValidateResult createInputData(MonitorInfo info) {
        ArrayList<MonitorTruthValueInfo> valueList = new ArrayList<MonitorTruthValueInfo>();
        MonitorTruthValueInfo valueInfo = new MonitorTruthValueInfo();
        valueInfo.setMonitorId(info.getMonitorId());
        valueInfo.setMonitorTypeId(info.getMonitorTypeId());
        valueInfo.setTruthValue(1);
        valueInfo.setPriority(PriorityConstant.stringToType(this.m_comboTrue.getText()));
        valueList.add(valueInfo);
        valueInfo = new MonitorTruthValueInfo();
        valueInfo.setMonitorId(info.getMonitorId());
        valueInfo.setMonitorTypeId(info.getMonitorTypeId());
        valueInfo.setTruthValue(0);
        valueInfo.setPriority(PriorityConstant.stringToType(this.m_comboFalse.getText()));
        valueList.add(valueInfo);
        info.setJudgementInfo(valueList);
        info.setFailurePriority(PriorityConstant.stringToType(this.m_comboFailurePriority.getText()));
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.m_comboTrue.setEnabled(enabled);
        this.m_comboFalse.setEnabled(enabled);
        this.m_comboFailurePriority.setEnabled(enabled);
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }
}

