/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.vafada.swtcalendar.SWTCalendar;
import org.vafada.swtcalendar.SWTCalendarEvent;
import org.vafada.swtcalendar.SWTCalendarListener;

public class CalendarDialog
extends CommonDialog {
    private SWTCalendar swtcal = null;
    private Date dateBuffer;
    private Date dateBefore;
    private Date date;

    public CalendarDialog(Shell parent) {
        super(parent);
    }

    protected void customizeDialog(Composite composite) {
        composite.getShell().setText(Messages.getString("calendar"));
        GridLayout gridLayout = new GridLayout(1, true);
        composite.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        this.swtcal = new SWTCalendar(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.swtcal.setLayoutData(gridData);
        this.swtcal.addSWTCalendarListener(new SWTCalendarListener(){

            public void dateChanged(SWTCalendarEvent calendarEvent) {
                CalendarDialog.this.dateBuffer = calendarEvent.getCalendar().getTime();
            }
        });
        if (this.dateBefore != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.dateBefore);
            this.swtcal.setCalendar(calendar);
        }
    }

    public void setDate(Date date) {
        this.dateBefore = date;
    }

    public Date getDate() {
        return this.date;
    }

    protected void cancelPressed() {
        this.date = this.dateBefore;
        super.cancelPressed();
    }

    protected void okPressed() {
        if (this.dateBuffer != null) {
            this.date = this.dateBuffer;
        }
        super.okPressed();
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        Calendar work = Calendar.getInstance();
        work.setTime(this.date);
        work.getTime();
        Calendar startDate = Calendar.getInstance();
        startDate.set(1, 1970);
        startDate.set(2, 0);
        startDate.set(5, 1);
        startDate.set(11, 0);
        startDate.set(12, 0);
        startDate.set(13, 0);
        startDate.set(14, 0);
        startDate.getTime();
        Calendar endDate = Calendar.getInstance();
        endDate.set(1, 2199);
        endDate.set(2, 11);
        endDate.set(5, 31);
        endDate.set(11, 23);
        endDate.set(12, 59);
        endDate.set(13, 59);
        endDate.set(14, 999);
        endDate.getTime();
        if (work.after(startDate) && work.before(endDate)) {
            result = null;
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            DateFormat format = DateFormat.getDateInstance();
            Object[] args1 = new String[]{format.format(startDate.getTime()), format.format(endDate.getTime())};
            result.setMessage(Messages.getString("message.hinemos.5", args1));
        }
        return result;
    }
}

