/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefine;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TextCellEditor;

public class IntegerPropertyDefine
extends PropertyDefine
implements Serializable {
    private static final long serialVersionUID = 3562301924650606249L;

    public IntegerPropertyDefine() {
        this.m_cellEditor = new TextCellEditor();
    }

    public String getColumnText(Object value) {
        if (value instanceof Integer) {
            return value.toString();
        }
        return "";
    }

    public Object getValue(Property element) {
        Object value = element.getValue();
        if (value instanceof Integer) {
            return value.toString();
        }
        return "";
    }

    public void modify(Property element, Object value) {
        try {
            if (((String)value).length() == 0) {
                element.setValue("");
            } else if (element.getLowerBound() <= Integer.parseInt((String)value) && Integer.parseInt((String)value) <= element.getUpperBound()) {
                Integer check = new Integer((String)value);
                element.setValue(check);
            } else {
                Object[] args = new String[]{String.valueOf(element.getLowerBound()), String.valueOf(element.getUpperBound())};
                MessageDialog.openWarning(null, (String)Messages.getString("message.hinemos.1"), (String)Messages.getString("message.hinemos.8", args));
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void initEditer() {
    }
}

