/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.composite.CommonTableTreeContentProvider;
import com.clustercontrol.composite.CommonTableTreeLabelProvider;
import com.clustercontrol.composite.CommonTableViewerSorter;
import com.clustercontrol.composite.ICommonTableLabelProvider;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableColumn;

public class CommonTableTreeViewer
extends TableTreeViewer {
    protected ArrayList m_tableColumnList = null;
    protected boolean m_sortType = true;

    public CommonTableTreeViewer(Composite parent) {
        super(parent);
        this.setLabelProvider((IBaseLabelProvider)new CommonTableTreeLabelProvider(this));
        this.setContentProvider((IContentProvider)new CommonTableTreeContentProvider());
    }

    public CommonTableTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.setLabelProvider((IBaseLabelProvider)new CommonTableTreeLabelProvider(this));
        this.setContentProvider((IContentProvider)new CommonTableTreeContentProvider());
    }

    public CommonTableTreeViewer(TableTree tableTree) {
        super(tableTree);
        this.setLabelProvider((IBaseLabelProvider)new CommonTableTreeLabelProvider(this));
        this.setContentProvider((IContentProvider)new CommonTableTreeContentProvider());
    }

    public void createTableColumn(ArrayList tableColumnList, int sortColumnIndex, int sortOrder) {
        this.m_tableColumnList = tableColumnList;
        int i = 0;
        while (i < this.m_tableColumnList.size()) {
            TableColumnInfo tableColumnInfo = (TableColumnInfo)this.m_tableColumnList.get(i);
            TableColumn column = new TableColumn(this.getTableTree().getTable(), tableColumnInfo.getStyle(), i);
            column.setText(tableColumnInfo.getName());
            column.setWidth(tableColumnInfo.getWidth());
            if (i == sortColumnIndex) {
                int order = sortOrder;
                tableColumnInfo.setOrder(order);
                this.setSorter(new CommonTableViewerSorter(i, order));
            }
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableColumn column = (TableColumn)e.getSource();
                    ArrayList tableColumnList = CommonTableTreeViewer.this.getTableColumnList();
                    int i = 0;
                    while (i < tableColumnList.size()) {
                        TableColumnInfo tableColumnInfo = (TableColumnInfo)tableColumnList.get(i);
                        if (tableColumnInfo.getName().compareTo(column.getText()) == 0) {
                            int order = tableColumnInfo.getOrder() * -1;
                            tableColumnInfo.setOrder(order);
                            CommonTableTreeViewer.this.setSorter(new CommonTableViewerSorter(i, order));
                            break;
                        }
                        ++i;
                    }
                }
            });
            ++i;
        }
    }

    protected void doUpdateItem(Item item, Object element) {
        IBaseLabelProvider prov = this.getLabelProvider();
        ICommonTableLabelProvider tprov = null;
        if (prov instanceof ICommonTableLabelProvider) {
            tprov = (ICommonTableLabelProvider)prov;
            int columnCount = this.getTableTree().getTable().getColumnCount();
            TableTreeItem ti = (TableTreeItem)item;
            int column = 0;
            while (column < columnCount || column == 0) {
                String text = "";
                Image image = null;
                Color color = null;
                if (tprov != null) {
                    text = tprov.getColumnText(element, column);
                    image = tprov.getColumnImage(element, column);
                    color = tprov.getColumnColor(element, column);
                }
                ti.setText(column, text);
                if (ti.getImage(column) != image) {
                    ti.setImage(column, image);
                }
                if (color != null) {
                    ti.setBackground(color);
                }
                ++column;
            }
            if (prov instanceof IColorProvider) {
                IColorProvider cprov = (IColorProvider)prov;
                ti.setForeground(cprov.getForeground(element));
                ti.setBackground(cprov.getBackground(element));
            }
            if (prov instanceof IFontProvider) {
                IFontProvider fprov = (IFontProvider)prov;
                ti.setFont(fprov.getFont(element));
            }
        } else {
            super.doUpdateItem(item, element);
        }
    }

    public ArrayList getTableColumnList() {
        return this.m_tableColumnList;
    }

    public int getTableColumnIndex(int type) {
        int index = -1;
        int i = 0;
        while (i < this.m_tableColumnList.size()) {
            TableColumnInfo tableColumn = (TableColumnInfo)this.m_tableColumnList.get(i);
            if (type == tableColumn.getType()) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }
}

