/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.dialog;

import com.clustercontrol.accesscontrol.action.AddUserProperty;
import com.clustercontrol.accesscontrol.action.GetUserProperty;
import com.clustercontrol.accesscontrol.action.ModifyUserProperty;
import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import java.util.ArrayList;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class UserDialog
extends CommonDialog {
    private String uid = "";
    private boolean isModifyDialog = false;
    private PropertySheet propertySheet = null;

    public UserDialog(Shell parent, String uid, boolean isModifyDialog) {
        super(parent);
        this.uid = uid;
        this.isModifyDialog = isModifyDialog;
    }

    protected Point getInitialSize() {
        return new Point(500, 600);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString("dialog.accesscontrol.user.create.modify"));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("attribute")) + " : ");
        TableTree table = new TableTree(parent, 68354);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.propertySheet = new PropertySheet(table);
        this.propertySheet.setCopy(true);
        Property property = null;
        property = this.isModifyDialog ? new GetUserProperty().getProperty(this.uid, 1) : new GetUserProperty().getProperty(this.uid, 0);
        this.propertySheet.setInput(property);
        this.propertySheet.expandAll();
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        ArrayList values = PropertyUtil.getPropertyValue(this.getInputData(), "uid");
        String value = (String)values.get(0);
        if (value.compareTo("") == 0) {
            result = new ValidateResult();
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.accesscontrol.1"));
            result.setValid(false);
            return result;
        }
        return result;
    }

    protected boolean action() {
        boolean result = false;
        Property property = this.getInputData();
        if (property != null) {
            result = !this.isModifyDialog ? new AddUserProperty().add(property) : new ModifyUserProperty().edit(property);
        }
        return result;
    }

    public boolean isModifyDialog() {
        return this.isModifyDialog;
    }

    public Property getInputData() {
        return (Property)this.propertySheet.getInput();
    }

    public void setInputData(Property property) {
        this.propertySheet.setInput(property);
    }

    public String getUid() {
        return this.uid;
    }

    protected String getOkButtonText() {
        if (this.isModifyDialog()) {
            return Messages.getString("modify");
        }
        return Messages.getString("register");
    }

    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

    protected void okPressed() {
        ValidateResult result = this.validate();
        if (result == null || result.isValid()) {
            if (this.isModifyDialog) {
                super.okPressed();
            } else {
                this.action();
            }
        } else {
            this.displayError(result);
        }
    }
}

