/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.dialog;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginDialog
extends Dialog {
    protected Text m_uidText = null;
    protected Text m_passwordText = null;
    protected String m_uid = null;
    protected String m_password = null;
    protected Text m_urlText = null;
    protected String m_url = null;
    protected Shell m_shell = null;

    public LoginDialog(Shell parent) {
        super(parent);
    }

    protected Control createContents(Composite parent) {
        Button button;
        String cancelText;
        Button button2;
        Composite composite = (Composite)super.createContents(parent);
        this.customizeDialog((Composite)this.getDialogArea());
        String okText = this.getOkButtonText();
        if (okText != null && (button2 = this.getButton(0)) != null) {
            button2.setText(okText);
        }
        if ((cancelText = this.getCancelButtonText()) != null && (button = this.getButton(1)) != null) {
            button.setText(cancelText);
        }
        return composite;
    }

    protected void customizeDialog(Composite parent) {
        this.m_shell = this.getShell();
        this.m_shell.setText(Messages.getString("dialog.accesscontrol.login"));
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 10;
        layout.marginWidth = 12;
        layout.marginHeight = 10;
        layout.fill = true;
        parent.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label uidTitle = new Label(composite, 0);
        uidTitle.setText(String.valueOf(Messages.getString("user.id")) + " : ");
        uidTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_uidText = new Text(composite, 2048);
        this.m_uidText.setLayoutData((Object)new RowData(150, 15));
        this.m_uidText.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label passwordTitle = new Label(composite, 0);
        passwordTitle.setText(String.valueOf(Messages.getString("password")) + " : ");
        passwordTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_passwordText = new Text(composite, 0x400800);
        this.m_passwordText.setLayoutData((Object)new RowData(150, 15));
        this.m_passwordText.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label urlTitle = new Label(composite, 0);
        urlTitle.setText(String.valueOf(Messages.getString("connection.url")) + " : ");
        urlTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_urlText = new Text(composite, 2048);
        this.m_urlText.setLayoutData((Object)new RowData(150, 15));
        this.m_urlText.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        new Label(parent, 258);
        Display display = this.m_shell.getDisplay();
        this.m_shell.setLocation((display.getBounds().width - this.m_shell.getSize().x) / 2, (display.getBounds().height - this.m_shell.getSize().y) / 2);
        this.reflectData();
        this.m_passwordText.setFocus();
    }

    protected String getOkButtonText() {
        return Messages.getString("login");
    }

    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

    private void reflectData() {
        this.m_urlText.setText(this.readPrefURL());
        this.m_uidText.setText(this.readPrefUID());
    }

    protected void okPressed() {
        ValidateResult result = this.validate();
        if (result == null || result.isValid()) {
            super.okPressed();
        } else {
            this.displayError(result);
        }
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        if (this.m_uidText.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.accesscontrol.1"));
            return result;
        }
        this.setUserid(this.m_uidText.getText());
        if (this.m_passwordText.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.accesscontrol.2"));
            return result;
        }
        this.setPassword(this.m_passwordText.getText());
        if (this.m_urlText.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.hinemos.9"));
            return result;
        }
        this.setUrl(this.m_urlText.getText());
        return null;
    }

    protected void displayError(ValidateResult result) {
        MessageDialog.openWarning(null, (String)result.getID(), (String)result.getMessage());
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getUserid() {
        return this.m_uid;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setUserid(String uid) {
        this.m_uid = uid;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    private String readPrefURL() {
        IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
        String url = store.getString("ejbUrl");
        if (url.compareTo("") == 0) {
            url = "jnp://localhost:1099";
        }
        return url;
    }

    private String readPrefUID() {
        IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
        String uid = store.getString("ejbUid");
        if (uid.compareTo("") == 0) {
            uid = "hinemos";
        }
        return uid;
    }
}

