/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.sql.factory;

import com.clustercontrol.monitor.run.factory.RunMonitorStringValueType;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoLocal;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoPK;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoUtil;
import com.clustercontrol.sql.util.AccessDB;
import com.clustercontrol.util.Messages;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunMonitorSqlString
extends RunMonitorStringValueType {
    protected static Log m_log = LogFactory.getLog(RunMonitorSqlString.class);
    public static final String MESSAGE_ID_UNKNOWN = "100";
    protected MonitorSqlInfoLocal m_sql = null;
    protected String m_url = null;
    protected String m_user = null;
    protected String m_password = null;
    protected String m_query = null;
    protected String m_jdbcDriver = null;
    protected String m_unKnownMessage = null;
    protected String m_messageOrg = null;

    public void run(String monitorTypeId, String monitorId) throws FinderException, RemoveException, JMSException, NamingException, CreateException {
        this.m_monitorTypeId = monitorTypeId;
        this.m_monitorId = monitorId;
        this.m_now = new Date();
        try {
            boolean run = this.setMonitorInfo(this.m_monitorTypeId, this.m_monitorId);
            if (!run) {
                return;
            }
            this.setJudgementInfo();
            this.setCheckInfo();
            boolean ret = this.collect(null);
            int checkResult = this.getCheckResult(ret);
            this.m_nodeDate = new Date().getTime();
            this.notify(true, this.m_facilityId, checkResult, new Date(this.m_nodeDate));
        }
        catch (FinderException e) {
            m_log.error((Object)("run():" + e.getMessage()));
            throw e;
        }
        catch (JMSException e) {
            m_log.error((Object)("run():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.error((Object)("run():" + e.getMessage()));
            throw e;
        }
        catch (CreateException e) {
            m_log.error((Object)("run():" + e.getMessage()));
            throw e;
        }
        finally {
            this.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean collect(String facilityId) {
        boolean result = false;
        AccessDB access = null;
        ResultSet rSet = null;
        try {
            access = new AccessDB(this.m_jdbcDriver, this.m_url, this.m_user, this.m_password);
            if (this.m_query.length() >= 6) {
                String work = this.m_query.substring(0, 6);
                if (work.equalsIgnoreCase("SELECT")) {
                    rSet = access.read(this.m_query);
                    rSet.first();
                    this.m_value = rSet.getString(1);
                    rSet.last();
                    int number = rSet.getRow();
                    NumberFormat numberFormat = NumberFormat.getNumberInstance();
                    this.m_messageOrg = Messages.getString((String)"record.value") + " : " + this.m_value + ", " + Messages.getString((String)"records.number") + " : " + numberFormat.format(number);
                    result = true;
                } else {
                    m_log.debug((Object)("collect(): " + Messages.getString((String)"message.sql.5")));
                    this.m_unKnownMessage = Messages.getString((String)"message.sql.5");
                    this.m_messageOrg = Messages.getString((String)"sql.string") + " : " + this.m_query;
                }
            } else {
                m_log.debug((Object)("collect(): " + Messages.getString((String)"message.sql.5")));
                this.m_unKnownMessage = Messages.getString((String)"message.sql.5");
                this.m_messageOrg = Messages.getString((String)"sql.string") + " : " + this.m_query;
            }
        }
        catch (ClassNotFoundException e) {
            this.m_unKnownMessage = Messages.getString((String)"message.sql.6");
            this.m_messageOrg = Messages.getString((String)"sql.string") + " : " + this.m_query + " (" + e.getMessage() + ")";
        }
        catch (SQLException e) {
            this.m_unKnownMessage = Messages.getString((String)"message.sql.7");
            this.m_messageOrg = Messages.getString((String)"sql.string") + " : " + this.m_query + " (" + e.getMessage() + ")";
        }
        finally {
            try {
                if (rSet != null) {
                    rSet.close();
                }
                if (access != null) {
                    access.terminate();
                }
            }
            catch (SQLException e) {
                m_log.error((Object)"collect(): ", (Throwable)e);
            }
        }
        return result;
    }

    public void setCheckInfo() throws FinderException, NamingException {
        MonitorSqlInfoPK pk = new MonitorSqlInfoPK(this.m_monitorId, this.m_monitorTypeId);
        this.m_sql = MonitorSqlInfoUtil.getLocalHome().findByPrimaryKey(pk);
        this.m_url = this.m_sql.getConnection_url().trim();
        this.m_user = this.m_sql.getConnection_user().trim();
        this.m_password = this.m_sql.getConnection_password().trim();
        this.m_query = this.m_sql.getQuery().trim();
        this.m_jdbcDriver = this.m_sql.getJdbc_driver().trim();
    }

    public String getMessageId(int id) {
        String messageId = super.getMessageId(id);
        if (messageId == null || "".equals(messageId)) {
            return MESSAGE_ID_UNKNOWN;
        }
        return messageId;
    }

    public String getMessage(int id) {
        String message = super.getMessage(id);
        if (message == null || "".equals(message)) {
            return this.m_unKnownMessage;
        }
        return message;
    }

    public String getMessageOrg(int id) {
        return this.m_messageOrg;
    }
}

