/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.port.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.port.action.DeletePort;
import com.clustercontrol.port.action.GetPort;
import com.clustercontrol.port.action.ModifyPort;
import com.clustercontrol.port.composite.PortListComposite;
import com.clustercontrol.port.dialog.PortCreateDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PortListDialog
extends CommonDialog {
    private PortListComposite portList = null;
    private Button buttonAdd = null;
    private Button buttonModify = null;
    private Button buttonDelete = null;
    private Button buttonValid = null;
    private Button buttonInvalid = null;

    public PortListDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Point getInitialSize() {
        return new Point(800, 400);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.port.list"));
        GridLayout layout = new GridLayout(8, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 8;
        parent.setLayout((Layout)layout);
        this.portList = new PortListComposite(parent, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 7;
        this.portList.setLayoutData(gridData);
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        this.buttonAdd = this.createButton(composite, Messages.getString((String)"add"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MonitorInfo info;
                PortCreateDialog dialog = new PortCreateDialog(PortListDialog.this.getParentShell());
                if (dialog.open() == 0 && (info = dialog.getInputData()) != null) {
                    PortListDialog.this.portList.update();
                }
            }
        });
        new Label(composite, 0);
        this.buttonModify = this.createButton(composite, Messages.getString((String)"modify"));
        this.buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String monitorId = null;
                Table table = PortListDialog.this.portList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        monitorId = (String)((ArrayList)item[0].getData()).get(0);
                    }
                    catch (Exception exception) {}
                }
                if (monitorId != null) {
                    PortCreateDialog dialog = new PortCreateDialog(PortListDialog.this.getParentShell(), monitorId);
                    if (dialog.open() == 0) {
                        int selectIndex = table.getSelectionIndex();
                        PortListDialog.this.portList.update();
                        table.setSelection(selectIndex);
                    }
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.monitor.1"));
                }
            }
        });
        new Label(composite, 0);
        this.buttonDelete = this.createButton(composite, Messages.getString((String)"delete"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String monitorId = null;
                Table table = PortListDialog.this.portList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        monitorId = (String)((ArrayList)item[0].getData()).get(0);
                    }
                    catch (Exception exception) {}
                }
                if (monitorId != null) {
                    Object[] args = new String[]{monitorId};
                    if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.monitor.39", (Object[])args))) {
                        boolean result = new DeletePort().delete(monitorId);
                        if (result) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.37", (Object[])args));
                            PortListDialog.this.portList.update();
                        } else {
                            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.monitor.38", (Object[])args));
                        }
                    }
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.monitor.1"));
                }
            }
        });
        new Label(composite, 0);
        new Label(composite, 0);
        this.buttonValid = this.createButton(composite, Messages.getString((String)"valid"));
        this.buttonValid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PortListDialog.this.setValid(1);
            }
        });
        this.buttonInvalid = this.createButton(composite, Messages.getString((String)"invalid"));
        this.buttonInvalid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PortListDialog.this.setValid(0);
            }
        });
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    protected ValidateResult validate() {
        return super.validate();
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(label);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, Messages.getString((String)"close"), false);
    }

    public void setValid(int valid) {
        ArrayList<String> list = this.portList.getSelectionData();
        if (list != null && list.size() > 0) {
            StringBuilder monitorIds = new StringBuilder();
            int i = 0;
            while (i < list.size()) {
                if (i > 0) {
                    monitorIds.append(", ");
                }
                monitorIds.append(list.get(i));
                ++i;
            }
            Object[] confirmArgs = new String[]{monitorIds.toString()};
            String message = valid == 1 ? Messages.getString((String)"message.monitor.47", (Object[])confirmArgs) : Messages.getString((String)"message.monitor.48", (Object[])confirmArgs);
            if (!MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)message)) {
                return;
            }
            int i2 = 0;
            while (i2 < list.size()) {
                String monitorId = list.get(i2);
                if (monitorId != null && !monitorId.equals("")) {
                    MonitorInfo info = new GetPort().getPort(monitorId);
                    info.setValid(valid);
                    boolean result = new ModifyPort().modify(info);
                    if (!result) {
                        Object[] args = new String[]{monitorId};
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.monitor.36", (Object[])args));
                    }
                }
                ++i2;
            }
            int selectIndex = this.portList.getTableViewer().getTable().getSelectionIndex();
            this.portList.update();
            this.portList.getTableViewer().getTable().setSelection(selectIndex);
        } else {
            MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.monitor.1"));
        }
    }
}

