/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.StoppableThread;

public class OutputMultiplexor {
    protected static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$multiplex$OutputMultiplexor == null ? (class$org$jboss$remoting$transport$multiplex$OutputMultiplexor = OutputMultiplexor.class$("org.jboss.remoting.transport.multiplex.OutputMultiplexor")) : class$org$jboss$remoting$transport$multiplex$OutputMultiplexor);
    protected static final int MARKER = 255;
    private List writeQueue = Collections.synchronizedList(new LinkedList());
    private SocketId previousDestinationId = SocketId.INITIAL_OUTPUT_SOCKET_ID;
    private int markerCount = 0;
    private MultiplexingManager manager;
    private OutputStream os;
    private Message pendingMessage;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$OutputMultiplexor;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$OutputMultiplexor$OutputThread;

    protected OutputMultiplexor(MultiplexingManager manager, OutputStream os) {
        this.manager = manager;
        this.os = os;
    }

    public OutputThread getAnOutputThread() {
        return new OutputThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SocketId socketId, byte[] content) throws IOException {
        log.debug("OutputMultiplexor.write(): queueing " + content.length + " bytes for socket " + socketId.getPort());
        List list = this.writeQueue;
        synchronized (list) {
            this.writeQueue.add(new Message(socketId, content));
            this.writeQueue.notifyAll();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Message {
        private SocketId socketId;
        private byte[] content;

        public Message(SocketId socketId, byte[] content) {
            this.socketId = socketId;
            this.content = content;
        }

        public SocketId getSocketid() {
            return this.socketId;
        }

        public byte[] getContent() {
            return this.content;
        }
    }

    class OutputThread
    extends StoppableThread {
        private final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$multiplex$OutputMultiplexor$OutputThread == null ? (class$org$jboss$remoting$transport$multiplex$OutputMultiplexor$OutputThread = OutputMultiplexor.class$("org.jboss.remoting.transport.multiplex.OutputMultiplexor$OutputThread")) : class$org$jboss$remoting$transport$multiplex$OutputMultiplexor$OutputThread);
        private int dataOutCount = 0;
        private boolean socketIsOpen = true;
        private boolean trace = this.log.isTraceEnabled();

        public void shutdown() {
            super.shutdown();
            this.interrupt();
        }

        protected void doInit() {
            this.log.info("output thread starting");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun() {
            while (this.socketIsOpen && (!OutputMultiplexor.this.writeQueue.isEmpty() || this.isRunning())) {
                try {
                    List list = OutputMultiplexor.this.writeQueue;
                    synchronized (list) {
                        if (OutputMultiplexor.this.writeQueue.isEmpty()) {
                            OutputMultiplexor.this.writeQueue.wait();
                        }
                        OutputMultiplexor.this.pendingMessage = (Message)OutputMultiplexor.this.writeQueue.remove(0);
                    }
                    SocketId remoteSocketId = OutputMultiplexor.this.pendingMessage.getSocketid();
                    int length = OutputMultiplexor.this.pendingMessage.getContent().length;
                    this.encode(remoteSocketId, OutputMultiplexor.this.pendingMessage.getContent(), OutputMultiplexor.this.os);
                    this.log.debug("output thread wrote: " + length + " bytes to socket " + remoteSocketId.getPort());
                    this.dataOutCount += length;
                    if (!OutputThread.interrupted()) continue;
                    throw new InterruptedException();
                }
                catch (InterruptedException e) {
                    this.handleError("output thread: interrupted", e);
                }
                catch (SocketException e) {
                    this.handleError("output thread: socket exception", e);
                }
                catch (IOException e) {
                    this.handleError("output thread: i/o error", e);
                }
            }
            this.log.debug("output thread: socketIsConnected: " + this.socketIsOpen);
            this.log.debug("output thread: writeQueue.isEmpty(): " + OutputMultiplexor.this.writeQueue.isEmpty());
            this.log.debug("output thread: running: " + this.running);
            this.log.debug("output thread: pendingMessage ==  " + OutputMultiplexor.this.pendingMessage);
        }

        protected void doShutDown() {
            this.log.info("output thread: data bytes out: " + this.dataOutCount);
            this.log.info("output thread shutting down");
            try {
                while (OutputMultiplexor.this.pendingMessage != null) {
                    this.log.info("waiting for encode() to write final message");
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ignored) {
                this.log.debug(ignored);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void encode(SocketId destinationId, byte[] bytes, OutputStream os) throws IOException {
            try {
                int i;
                if (!destinationId.equals(OutputMultiplexor.this.previousDestinationId)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("encode(): writing: MARKER");
                        byte[] byteArray = destinationId.toByteArray();
                        for (i = 0; i < byteArray.length; ++i) {
                            this.log.debug("encode(): writing: " + byteArray[i]);
                        }
                        this.log.debug("encode(): writing: MARKER");
                    }
                    OutputMultiplexor.this.previousDestinationId = destinationId;
                    os.write(255);
                    os.write(destinationId.toByteArray());
                    os.write(255);
                }
                int length = bytes.length;
                this.log.debug("encode(): writing " + length + " bytes to socketId " + destinationId.getPort());
                for (i = 0; i < length; ++i) {
                    int b = 0xFF & bytes[i];
                    if (b != 255) {
                        if (OutputMultiplexor.this.markerCount > 0) {
                            this.log.debug("wrote " + OutputMultiplexor.this.markerCount + " MARKER's");
                        }
                        this.log.debug("writing byte: " + b);
                        OutputMultiplexor.this.markerCount = 0;
                    } else {
                        OutputMultiplexor.this.markerCount++;
                    }
                    os.write(b);
                    if (b != 255) continue;
                    os.write(255);
                }
                if (OutputMultiplexor.this.markerCount > 0) {
                    this.log.debug("wrote " + OutputMultiplexor.this.markerCount + " MARKER's");
                }
                OutputMultiplexor.this.markerCount = 0;
            }
            finally {
                OutputMultiplexor.this.pendingMessage = null;
            }
        }

        protected void handleError(String message, Throwable e) {
            if (e instanceof SocketException) {
                this.socketIsOpen = false;
                super.shutdown();
                return;
            }
            if (this.log != null) {
                this.log.debug(message, e);
            }
        }
    }
}

