/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.invocation.SecurityActions;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        return TCLAction.UTIL.getContextClassLoader();
    }

    static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public ClassLoader getContextClassLoader(Thread thread) {
                return thread.getContextClassLoader();
            }

            public void setContextClassLoader(ClassLoader cl) {
                Thread.currentThread().setContextClassLoader(cl);
            }

            public void setContextClassLoader(Thread thread, ClassLoader cl) {
                thread.setContextClassLoader(cl);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){
            private final PrivilegedAction getTCLPrivilegedAction;
            {
                this.getTCLPrivilegedAction = new PrivilegedAction(this){
                    private final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                };
            }

            public ClassLoader getContextClassLoader() {
                return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
            }

            public ClassLoader getContextClassLoader(Thread thread) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(this, thread){
                    private final /* synthetic */ Thread val$thread;
                    private final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$thread = val$thread;
                    }

                    public Object run() {
                        return this.val$thread.getContextClassLoader();
                    }
                });
            }

            public void setContextClassLoader(ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(this, cl){
                    private final /* synthetic */ ClassLoader val$cl;
                    private final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$cl = val$cl;
                    }

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$cl);
                        return null;
                    }
                });
            }

            public void setContextClassLoader(Thread thread, ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(this, thread, cl){
                    private final /* synthetic */ Thread val$thread;
                    private final /* synthetic */ ClassLoader val$cl;
                    private final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$thread = val$thread;
                        this.val$cl = val$cl;
                    }

                    public Object run() {
                        this.val$thread.setContextClassLoader(this.val$cl);
                        return null;
                    }
                });
            }
        };

        public ClassLoader getContextClassLoader();

        public ClassLoader getContextClassLoader(Thread var1);

        public void setContextClassLoader(ClassLoader var1);

        public void setContextClassLoader(Thread var1, ClassLoader var2);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static ClassLoader getContextClassLoader() {
                return UTIL.getTCLAction().getContextClassLoader();
            }

            static ClassLoader getContextClassLoader(Thread thread) {
                return UTIL.getTCLAction().getContextClassLoader(thread);
            }

            static void setContextClassLoader(ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(cl);
            }

            static void setContextClassLoader(Thread thread, ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(thread, cl);
            }
        }
    }
}

