/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeMasterBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeMasterPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobNoticeMasterDAOImpl
implements JobNoticeMasterDAO {
    protected static Log m_log = LogFactory.getLog(JobNoticeMasterDAOImpl.class);

    public void init() {
    }

    public void load(JobNoticeMasterPK pk, JobNoticeMasterBean ejb) throws EJBException {
        block13: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_notice_mst WHERE job_id = ? AND notice_type = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getJob_id());
                stmt.setInt(2, pk.getNotice_type());
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setJob_id(res.getString("job_id"));
                    ejb.setNotice_type(res.getInt("notice_type"));
                    ejb.setNotify_id(res.getString("notify_id"));
                    ejb.setPriority(res.getInt("priority"));
                    break block13;
                }
                String msg = "JobNoticeMaster data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    public void store(JobNoticeMasterBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getJob_id() + ", " + ejb.getNotice_type()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE cc_job_notice_mst SET ");
            sql.append("priority = ?, ");
            sql.append("notify_id = ? ");
            sql.append("WHERE job_id = ? AND ");
            sql.append("notice_type = ?");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setInt(1, ejb.getPriority());
            stmt.setString(2, ejb.getNotify_id());
            stmt.setString(3, ejb.getJob_id());
            stmt.setInt(4, ejb.getNotice_type());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("store() error : " + ejb.getJob_id() + ", " + ejb.getNotice_type() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("store() error : " + ejb.getJob_id() + ", " + ejb.getNotice_type() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getJob_id() + ", " + ejb.getNotice_type() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("store() end : " + ejb.getJob_id() + ", " + ejb.getNotice_type()));
    }

    public void remove(JobNoticeMasterPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_job_notice_mst WHERE job_id = ? AND notice_type = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getJob_id());
            stmt.setInt(2, pk.getNotice_type());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    public JobNoticeMasterPK create(JobNoticeMasterBean ejb) throws CreateException, EJBException {
        JobNoticeMasterPK pk;
        m_log.debug((Object)("create() start : " + ejb.getJob_id() + ", " + ejb.getNotice_type()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO cc_job_notice_mst (");
            sql.append("job_id, ");
            sql.append("notice_type, ");
            sql.append("priority, ");
            sql.append("notify_id) ");
            sql.append("VALUES (?,?,?,?)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getJob_id());
            stmt.setInt(2, ejb.getNotice_type());
            stmt.setInt(3, ejb.getPriority());
            stmt.setString(4, ejb.getNotify_id());
            int row = stmt.executeUpdate();
            pk = new JobNoticeMasterPK(ejb.getJob_id(), ejb.getNotice_type());
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getJob_id() + ", " + ejb.getNotice_type() + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("create() error : " + ejb.getJob_id() + ", " + ejb.getNotice_type() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getJob_id() + ", " + ejb.getNotice_type() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getJob_id() + ", " + ejb.getNotice_type()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobNoticeMasterPK> ret = new ArrayList<JobNoticeMasterPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_notice_mst";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                JobNoticeMasterPK pk = new JobNoticeMasterPK(res.getString("job_id"), res.getInt("notice_type"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobNoticeMasterPK findByPrimaryKey(JobNoticeMasterPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_notice_mst WHERE job_id = ? AND notice_type = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getJob_id());
            stmt.setInt(2, pk.getNotice_type());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobNoticeMasterPK jobNoticeMasterPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobNoticeMasterPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    public Collection findByJobId(String job_id) throws FinderException {
        m_log.debug((Object)("findByJobId() start : " + job_id));
        ArrayList<JobNoticeMasterPK> ret = new ArrayList<JobNoticeMasterPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_notice_mst WHERE job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, job_id);
            res = stmt.executeQuery();
            while (res.next()) {
                JobNoticeMasterPK pk = new JobNoticeMasterPK(res.getString("job_id"), res.getInt("notice_type"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("findByJobId() error : " + job_id + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByJobId() error : " + job_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("findByJobId() end : " + job_id));
        return ret;
    }
}

