/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite;

import com.clustercontrol.collectiverun.action.ModifyMaster;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.composite.action.MasterInfoModifyListener;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ParameterComposite
extends Composite {
    private Text id = null;
    private Text name = null;
    private Button typeText1 = null;
    private Button typePassword = null;
    private Button typeSelect = null;
    private Button typeText2 = null;
    private TreeItem selectItem = null;
    private TreeComposite composite = null;

    public ParameterComposite(Composite parent, int style, TreeComposite composite) {
        super(parent, style);
        this.composite = composite;
        this.selectItem = composite.getSelectItem();
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(10, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        GridData gridData = null;
        Label label = null;
        Group group = new Group((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 10;
        group.setLayoutData((Object)gridData);
        group.setText(Messages.getString((String)"parameter"));
        layout = new GridLayout(10, true);
        group.setLayout((Layout)layout);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"parameter.id")) + " : ");
        this.id = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.id.setLayoutData((Object)gridData);
        this.id.addModifyListener((ModifyListener)new MasterInfoModifyListener(this.composite));
        this.id.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"name")) + " : ");
        this.name = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.name.setLayoutData((Object)gridData);
        this.name.addModifyListener((ModifyListener)new MasterInfoModifyListener(this.composite));
        this.name.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        Group typeGroup = new Group((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        typeGroup.setLayoutData((Object)gridData);
        typeGroup.setText(Messages.getString((String)"input.type"));
        layout = new GridLayout(10, true);
        typeGroup.setLayout((Layout)layout);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 0;
        this.typeText1 = new Button((Composite)typeGroup, 16);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        this.typeText1.setLayoutData((Object)gridData);
        this.typeText1.setText(Messages.getString((String)"edit"));
        this.typeText1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    ParameterComposite.this.typeText2.setEnabled(true);
                    ParameterComposite.this.typePassword.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group textGroup = new Group((Composite)typeGroup, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        textGroup.setLayoutData((Object)gridData);
        layout = new GridLayout(10, true);
        textGroup.setLayout((Layout)layout);
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 0;
        this.typeText2 = new Button((Composite)textGroup, 16);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 5;
        this.typeText2.setLayoutData((Object)gridData);
        this.typeText2.setText(Messages.getString((String)"show.text"));
        this.typePassword = new Button((Composite)textGroup, 16);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 5;
        this.typePassword.setLayoutData((Object)gridData);
        this.typePassword.setText(Messages.getString((String)"show.asterisk"));
        label = new Label((Composite)typeGroup, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)typeGroup, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        label.setLayoutData((Object)gridData);
        this.typeSelect = new Button((Composite)typeGroup, 16);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        this.typeSelect.setLayoutData((Object)gridData);
        this.typeSelect.setText(Messages.getString((String)"select"));
        this.typeSelect.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    ParameterComposite.this.typeText2.setEnabled(false);
                    ParameterComposite.this.typePassword.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        label.setLayoutData((Object)gridData);
        Button buttonCreate = new Button((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        buttonCreate.setLayoutData((Object)gridData);
        buttonCreate.setText(Messages.getString((String)"apply"));
        buttonCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValidateResult result = ParameterComposite.this.validate();
                if (result != null) {
                    ParameterComposite.this.displayError(result);
                }
            }
        });
        this.setEnabled();
        this.update();
    }

    public void setEnabled() {
        if (this.composite.getCreateItem() == null) {
            this.id.setEnabled(false);
        } else {
            this.id.setEnabled(true);
        }
    }

    public void update() {
        if (this.selectItem instanceof TreeItem && this.selectItem.getInfo() instanceof ParameterInfo) {
            ParameterInfo info = (ParameterInfo)this.selectItem.getInfo();
            if (info.getId() != null) {
                this.id.setText(info.getId());
            }
            if (info.getName() != null) {
                this.name.setText(info.getName());
            }
            if (info.getParamType() == 0) {
                this.typeText1.setSelection(true);
                this.typeText2.setSelection(true);
            } else if (info.getParamType() == 1) {
                this.typeText1.setSelection(true);
                this.typePassword.setSelection(true);
            } else if (info.getParamType() == 2) {
                this.typeSelect.setSelection(true);
            }
            if (info.getParamType() == 2) {
                this.typeText2.setEnabled(false);
                this.typePassword.setEnabled(false);
            } else {
                this.typeText2.setEnabled(true);
                this.typePassword.setEnabled(true);
            }
        }
        this.composite.setUpdateItem(null);
    }

    public ValidateResult createParameterInfo() {
        ValidateResult result = null;
        if (this.selectItem instanceof TreeItem && this.selectItem.getInfo() instanceof ParameterInfo) {
            ParameterInfo info = (ParameterInfo)this.selectItem.getInfo();
            ParameterInfo cloneInfo = (ParameterInfo)info.clone();
            ItemInfo parentInfo = this.selectItem.getParent().getInfo();
            if (this.id.getText().length() <= 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.collective.run.6"));
                return result;
            }
            cloneInfo.setId(this.id.getText());
            if (this.id.isEnabled() && TreeItemUtil.findId((String)cloneInfo.getId(), (TreeItem)this.selectItem.getParent())) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                Object[] args = new String[]{Messages.getString((String)"parameter.id"), cloneInfo.getId()};
                result.setMessage(Messages.getString((String)"message.collective.run.16", (Object[])args));
                return result;
            }
            if (this.name.getText().length() <= 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.collective.run.3"));
                return result;
            }
            cloneInfo.setName(this.name.getText());
            if (this.typeText1.getSelection()) {
                if (this.typeText2.getSelection()) {
                    cloneInfo.setParamType(0);
                } else {
                    cloneInfo.setParamType(1);
                }
            } else {
                cloneInfo.setParamType(2);
            }
            ModifyMaster modify = new ModifyMaster();
            if (modify.update((ItemInfo)cloneInfo, parentInfo)) {
                this.selectItem.setInfo((ItemInfo)cloneInfo);
                this.composite.setCreateItem(null);
                this.composite.setUpdateItem(null);
                this.composite.getTreeViewer().refresh((Object)this.selectItem);
            } else {
                Object[] args = new Object[]{cloneInfo.getName()};
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.collective.run.13", (Object[])args));
            }
        }
        return null;
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createParameterInfo();
        if (result != null) {
            return result;
        }
        return null;
    }

    protected void displayError(ValidateResult result) {
        MessageDialog.openWarning(null, (String)result.getID(), (String)result.getMessage());
    }

    public TreeItem getSelectItem() {
        return this.selectItem;
    }

    public void setSelectItem(TreeItem selectItem) {
        this.selectItem = selectItem;
    }
}

