/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.util;

import com.clustercontrol.performance.action.RealtimeController;
import com.clustercontrol.performance.composite.RealtimeGraphComposite;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import java.util.Date;
import java.util.Iterator;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;

public class RealtimeCollectThread
extends Thread {
    private TimeSeries[] m_timeseries;
    private int interval;
    private int requestInterval;
    private RealtimeController clientRealTimeController;
    private CollectedDataInfo dataInfo;
    private String facilityID;
    private String itemCode;
    private String itemId;
    private int deviceIndex;
    private String deviceName;
    private String displayType;
    private Date timestamp;
    private int collectTimestampId;
    private RealtimeCollectorInfo collectorInfo = null;
    private RealtimeGraphComposite graphComposite = null;

    public RealtimeCollectThread(Date timestamp, int collectTimestampId, TimeSeries[] m_timeseries, String itemCode, String itemId, int deviceIndex, String deviceName, String displayType, int interval, int requestInterval, String facilityID, boolean check, RealtimeGraphComposite graphComposite) {
        if (timestamp != null) {
            this.timestamp = timestamp;
        }
        if (collectTimestampId >= 0) {
            this.collectTimestampId = collectTimestampId;
        }
        if (m_timeseries != null) {
            this.m_timeseries = m_timeseries;
        }
        if (itemCode != null) {
            this.itemCode = itemCode;
        }
        this.deviceIndex = deviceIndex;
        this.deviceName = deviceName;
        if (displayType != null) {
            this.displayType = displayType;
        }
        if (itemId != null) {
            this.itemId = itemId;
        }
        if (interval >= 0) {
            this.interval = interval;
        }
        if (requestInterval >= 0) {
            this.requestInterval = requestInterval;
        }
        if (facilityID != null) {
            this.facilityID = facilityID;
        }
        if (graphComposite != null) {
            this.graphComposite = graphComposite;
        }
        this.clientRealTimeController = RealtimeController.getInstance();
    }

    public void run() {
        this.clientRealTimeController.setCollectorInfo(this.collectorInfo);
        this.clientRealTimeController.startCollect(this.timestamp, this.collectTimestampId, this.interval, this.requestInterval, this, this.itemCode, this.itemId, this.deviceIndex, this.deviceName, this.displayType, this.facilityID, false, this.graphComposite);
    }

    public void setCollectorInfo(RealtimeCollectorInfo collectorInfo) {
        this.collectorInfo = collectorInfo;
    }

    public void setGraph() {
        this.graphComposite.setValueaxisRange(this.collectorInfo.getGraphPlotNum(), this.interval);
    }

    public boolean setDataList(Iterator itr, String displayType) {
        boolean isRun = true;
        double graphLineValue = 0.0;
        double sumOfDataInfoValueSum = 0.0;
        int graphLineNum = this.m_timeseries.length;
        double[] collectedValue = new double[graphLineNum];
        Date[] graphLineDate = new Date[graphLineNum];
        int i = 0;
        while (itr.hasNext()) {
            this.dataInfo = (CollectedDataInfo)itr.next();
            collectedValue[i] = this.dataInfo.getValue();
            graphLineDate[i] = this.dataInfo.getDate();
            ++i;
        }
        int j = 0;
        while (j < graphLineNum) {
            if (displayType.equals("SelectedScope") || displayType.equals("SubScope")) {
                graphLineValue = collectedValue[graphLineNum - j - 1];
            } else if (displayType.equals("Detail")) {
                sumOfDataInfoValueSum = graphLineValue = sumOfDataInfoValueSum + collectedValue[graphLineNum - j - 1];
            }
            if (this.m_timeseries != null) {
                if (!Double.isNaN(graphLineValue)) {
                    this.m_timeseries[graphLineNum - j - 1].addOrUpdate((RegularTimePeriod)new Second(graphLineDate[graphLineNum - j - 1]), graphLineValue);
                }
            } else {
                isRun = false;
            }
            ++j;
        }
        return isRun;
    }
}

