/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.dialog;

import com.clustercontrol.dialog.DateTimeDialog;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RealtimeSetDialog2
extends Dialog {
    private static int plotNum;
    private Composite composite = null;
    private Composite composite2 = null;
    private Group group4 = null;
    private Combo combo = null;
    private Combo combo1 = null;
    private int comboSetting;
    private int comboIndex;
    private RealtimeCollectorInfo collectorInfo = null;
    private RealtimeCollectorItemInfo collectorItemInfo = null;
    private int arrayNum;
    private Group plotGroup;
    private Group rangeGroup;
    private Button radioButton00;
    private Button radioButton01;
    private Text startTimeText = null;
    private Label startTimeLabel = null;
    private Label endTimeTopLabel = null;
    private Text endTimeText = null;
    private Label endTimeLabel = null;
    private Button startTimeButton;
    private Button endTimeButton;
    private Date startTime = null;
    private Date endTime = null;
    private Date startTimeLocal;
    private Date endTimeLocal;
    private boolean isRange = false;
    private boolean isInterval = false;
    private Shell parent;
    private SimpleDateFormat dateFormat;
    private boolean isPlotAuto = false;
    private int interval;

    public RealtimeSetDialog2(Shell parent) {
        super(parent);
        Display display = parent.getDisplay();
        parent.setLocation((display.getBounds().width - parent.getSize().x) / 2, (display.getBounds().height - parent.getSize().y) / 2);
        this.parent = parent;
        this.initialize();
    }

    private void initialize() {
        this.dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    public void update() {
        this.collectorItemInfo.refreshItemInfoForDialog();
        this.interval = this.collectorInfo.getInterval();
        if (this.collectorInfo.getCollectStartTime() != null) {
            this.startTime = this.collectorInfo.getCollectStartTime();
            this.endTime = this.collectorInfo.getCollectEndTime();
            if (this.endTime == null) {
                this.endTime = new Date();
            }
            if (this.collectorInfo.getGraphStartTime() == null) {
                this.startTimeLocal = this.startTime;
                this.endTimeLocal = new Date(this.startTime.getTime() + (long)(this.interval * 1000 * 200));
                if (this.endTimeLocal.after(this.endTime)) {
                    this.endTimeLocal = this.endTime;
                }
                this.collectorInfo.setGraphPlotNum(0);
            } else {
                this.startTimeLocal = this.collectorInfo.getGraphStartTime();
                this.endTimeLocal = this.collectorInfo.getGraphEndTime();
                if (this.endTimeLocal.after(this.endTime)) {
                    this.endTimeLocal = this.endTime;
                }
            }
            this.isRange = true;
        } else {
            this.isRange = false;
        }
        switch (this.collectorInfo.getInterval()) {
            case 5: {
                this.comboSetting = 0;
                break;
            }
            case 15: {
                this.comboSetting = 1;
                break;
            }
            case 30: {
                this.comboSetting = 2;
                break;
            }
            case 60: {
                this.comboSetting = 3;
            }
        }
        switch (this.collectorInfo.getGraphPlotNum()) {
            case 12: {
                this.comboIndex = 0;
                break;
            }
            case 24: {
                this.comboIndex = 1;
                break;
            }
            case 100: {
                this.comboIndex = 2;
                break;
            }
            case 200: {
                this.comboIndex = 3;
            }
        }
    }

    protected Point getInitialSize() {
        return new Point(450, 270);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("PLOT_AND_SPAN"));
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = (Composite)super.createDialogArea(parent);
        this.composite.setLayout((Layout)new FormLayout());
        this.createComposite2();
        return this.composite;
    }

    private void createComposite2() {
        this.composite2 = new Composite(this.composite, 0);
        FormData composite2Data = new FormData();
        composite2Data.top = new FormAttachment(0, 0);
        composite2Data.bottom = new FormAttachment(100, 0);
        composite2Data.right = new FormAttachment(100, 0);
        composite2Data.left = new FormAttachment(0, 0);
        this.composite2.setLayoutData((Object)composite2Data);
        GridLayout gridLayout00 = new GridLayout();
        GridData gridDataGroup = new GridData(768);
        this.collectorItemInfo.getItemCodeForDialog(0);
        this.plotGroup = new Group(this.composite2, 0);
        gridDataGroup = new GridData(768);
        this.plotGroup.setLayoutData((Object)gridDataGroup);
        this.plotGroup.setText(Messages.getString("PLOT"));
        gridLayout00 = new GridLayout();
        gridLayout00.numColumns = 3;
        this.plotGroup.setLayout((Layout)gridLayout00);
        if (this.collectorInfo.getGraphPlotNum() == 0) {
            this.isPlotAuto = true;
            this.comboIndex = 0;
        } else {
            this.isPlotAuto = false;
        }
        this.radioButton00 = new Button((Composite)this.plotGroup, 16);
        this.radioButton00.setText(Messages.getString("FIXED"));
        GridData gridData00 = new GridData(1040);
        gridData00.horizontalSpan = 1;
        this.radioButton00.setLayoutData((Object)gridData00);
        this.radioButton00.setSelection(!this.isPlotAuto);
        this.radioButton00.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RealtimeSetDialog2.this.isPlotAuto = false;
                RealtimeSetDialog2.this.combo1.setEnabled(true);
                RealtimeSetDialog2.this.endTimeTopLabel.setEnabled(false);
                RealtimeSetDialog2.this.endTimeText.setEnabled(false);
                RealtimeSetDialog2.this.endTimeButton.setEnabled(false);
                if (RealtimeSetDialog2.this.combo1.getSelectionIndex() == 0) {
                    plotNum = 12;
                } else if (RealtimeSetDialog2.this.combo1.getSelectionIndex() == 1) {
                    plotNum = 24;
                } else if (RealtimeSetDialog2.this.combo1.getSelectionIndex() == 2) {
                    plotNum = 100;
                } else if (RealtimeSetDialog2.this.combo1.getSelectionIndex() == 3) {
                    plotNum = 200;
                }
                if (RealtimeSetDialog2.this.isRange) {
                    RealtimeSetDialog2.this.endTimeLocal = new Date(RealtimeSetDialog2.this.startTimeLocal.getTime() + (long)(RealtimeSetDialog2.this.interval * 1000 * plotNum));
                    if (RealtimeSetDialog2.this.endTimeLocal.after(RealtimeSetDialog2.this.endTime)) {
                        RealtimeSetDialog2.this.endTimeLocal = RealtimeSetDialog2.this.endTime;
                    }
                    RealtimeSetDialog2.this.endTimeText.setText(RealtimeSetDialog2.this.dateFormat.format(RealtimeSetDialog2.this.endTimeLocal));
                }
            }
        });
        this.combo1 = new Combo((Composite)this.plotGroup, 8);
        GridData gridDataCombo = new GridData(2);
        gridDataCombo.horizontalSpan = 1;
        this.combo1.setLayoutData((Object)gridDataCombo);
        this.combo1.add(String.valueOf(12) + Messages.getString("PLOT"));
        this.combo1.add(String.valueOf(24) + Messages.getString("PLOT"));
        this.combo1.add(String.valueOf(100) + Messages.getString("PLOT"));
        this.combo1.add(String.valueOf(200) + Messages.getString("PLOT"));
        this.combo1.select(this.comboIndex);
        this.combo1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RealtimeSetDialog2.this.comboIndex = RealtimeSetDialog2.this.combo1.getSelectionIndex();
                if (RealtimeSetDialog2.this.combo1.getSelectionIndex() == 0) {
                    plotNum = 12;
                } else if (RealtimeSetDialog2.this.combo1.getSelectionIndex() == 1) {
                    plotNum = 24;
                } else if (RealtimeSetDialog2.this.combo1.getSelectionIndex() == 2) {
                    plotNum = 100;
                } else if (RealtimeSetDialog2.this.combo1.getSelectionIndex() == 3) {
                    plotNum = 200;
                }
                if (RealtimeSetDialog2.this.isRange) {
                    RealtimeSetDialog2.this.endTimeLocal = new Date(RealtimeSetDialog2.this.startTimeLocal.getTime() + (long)(RealtimeSetDialog2.this.interval * 1000 * plotNum));
                    if (RealtimeSetDialog2.this.endTimeLocal.after(RealtimeSetDialog2.this.endTime)) {
                        RealtimeSetDialog2.this.endTimeLocal = RealtimeSetDialog2.this.endTime;
                    }
                    RealtimeSetDialog2.this.endTimeText.setText(RealtimeSetDialog2.this.dateFormat.format(RealtimeSetDialog2.this.endTimeLocal));
                }
            }
        });
        this.radioButton01 = new Button((Composite)this.plotGroup, 16);
        this.radioButton01.setText(Messages.getString("AUTO"));
        gridData00 = new GridData(1040);
        gridData00.horizontalSpan = 3;
        this.radioButton01.setLayoutData((Object)gridData00);
        this.radioButton01.setSelection(this.isPlotAuto);
        this.radioButton01.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RealtimeSetDialog2.this.isPlotAuto = true;
                RealtimeSetDialog2.this.combo1.setEnabled(false);
                if (RealtimeSetDialog2.this.isRange && !RealtimeSetDialog2.this.endTimeTopLabel.getEnabled()) {
                    RealtimeSetDialog2.this.endTimeTopLabel.setEnabled(true);
                    RealtimeSetDialog2.this.endTimeText.setEnabled(true);
                    RealtimeSetDialog2.this.endTimeButton.setEnabled(true);
                    RealtimeSetDialog2.this.endTimeLocal = new Date(RealtimeSetDialog2.this.startTimeLocal.getTime() + (long)(RealtimeSetDialog2.this.interval * 1000 * plotNum));
                    if (RealtimeSetDialog2.this.endTimeLocal.after(RealtimeSetDialog2.this.endTime)) {
                        RealtimeSetDialog2.this.endTimeLocal = RealtimeSetDialog2.this.endTime;
                    }
                }
            }
        });
        if (this.collectorInfo.getGraphPlotNum() == 0) {
            this.combo1.setEnabled(false);
        }
        this.rangeGroup = new Group(this.composite2, 0);
        gridDataGroup = new GridData(768);
        this.rangeGroup.setLayoutData((Object)gridDataGroup);
        this.rangeGroup.setText(Messages.getString("SPAN"));
        gridLayout00 = new GridLayout();
        if (this.isRange) {
            this.rangeGroup.setEnabled(true);
            gridLayout00.numColumns = 4;
        } else {
            this.rangeGroup.setEnabled(false);
            gridLayout00.numColumns = 3;
        }
        this.rangeGroup.setLayout((Layout)gridLayout00);
        this.startTimeLabel = new Label((Composite)this.rangeGroup, 0);
        this.startTimeLabel.setText(String.valueOf(Messages.getString("START")) + ":");
        GridData gridData004 = new GridData(1040);
        gridData004.horizontalSpan = 1;
        this.startTimeLabel.setLayoutData((Object)gridData004);
        if (!this.isRange) {
            this.startTimeLabel.setEnabled(false);
        }
        this.startTimeText = new Text((Composite)this.rangeGroup, 2056);
        if (this.isRange) {
            this.startTimeText.setText(this.dateFormat.format(this.startTimeLocal));
        } else {
            this.startTimeText.setText("*********NR**********");
            this.startTimeText.setEnabled(false);
        }
        gridData004 = new GridData(1040);
        gridData004.horizontalSpan = 1;
        this.startTimeText.setLayoutData((Object)gridData004);
        this.startTimeButton = new Button((Composite)this.rangeGroup, 0);
        this.startTimeButton.setText(Messages.getString("REFER"));
        if (!this.isRange) {
            this.startTimeButton.setEnabled(false);
        }
        gridData004 = new GridData(1040);
        gridData004.horizontalSpan = 1;
        this.startTimeButton.setLayoutData((Object)gridData004);
        this.startTimeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Date date = RealtimeSetDialog2.this.startTimeLocal;
                DateTimeDialog dialog = new DateTimeDialog(RealtimeSetDialog2.this.parent);
                dialog.setDate(date);
                dialog.open();
                date = dialog.getDate();
                Date startTimeTemp = new Date(RealtimeSetDialog2.this.startTime.getTime() - 1000L);
                if (RealtimeSetDialog2.this.isPlotAuto) {
                    if (date != null && date.after(startTimeTemp) && date.before(RealtimeSetDialog2.this.endTimeLocal)) {
                        RealtimeSetDialog2.this.startTimeLocal = date;
                        RealtimeSetDialog2.this.startTimeText.setText(RealtimeSetDialog2.this.dateFormat.format(date));
                    }
                } else if (date != null && date.after(startTimeTemp) && date.before(RealtimeSetDialog2.this.endTime)) {
                    RealtimeSetDialog2.this.startTimeLocal = date;
                    RealtimeSetDialog2.this.startTimeText.setText(RealtimeSetDialog2.this.dateFormat.format(RealtimeSetDialog2.this.startTimeLocal));
                    RealtimeSetDialog2.this.endTimeLocal = new Date(RealtimeSetDialog2.this.startTimeLocal.getTime() + (long)(RealtimeSetDialog2.this.interval * 1000 * plotNum));
                    if (RealtimeSetDialog2.this.endTimeLocal.after(RealtimeSetDialog2.this.endTime)) {
                        RealtimeSetDialog2.this.endTimeLocal = RealtimeSetDialog2.this.endTime;
                    }
                    RealtimeSetDialog2.this.endTimeText.setText(RealtimeSetDialog2.this.dateFormat.format(RealtimeSetDialog2.this.endTimeLocal));
                }
                dialog = null;
            }
        });
        if (this.isRange) {
            this.startTimeLabel = new Label((Composite)this.rangeGroup, 0);
            this.startTimeLabel.setText(String.valueOf(this.dateFormat.format(this.startTime)) + Messages.getString("AFTER"));
            gridData004 = new GridData(1040);
            gridData004.horizontalSpan = 1;
            this.startTimeLabel.setLayoutData((Object)gridData004);
        }
        this.endTimeTopLabel = new Label((Composite)this.rangeGroup, 0);
        this.endTimeTopLabel.setText(String.valueOf(Messages.getString("END")) + ":");
        this.endTimeTopLabel.setLayoutData((Object)gridData004);
        if (!this.isRange || !this.isPlotAuto) {
            this.endTimeTopLabel.setEnabled(false);
        }
        gridData004 = new GridData(1040);
        gridData004.horizontalSpan = 1;
        this.endTimeTopLabel.setLayoutData((Object)gridData004);
        this.endTimeText = new Text((Composite)this.rangeGroup, 2056);
        if (this.isRange) {
            this.endTimeText.setText(this.dateFormat.format(this.endTimeLocal));
        } else {
            this.endTimeText.setText("*********NR**********");
        }
        if (!this.isPlotAuto) {
            this.endTimeText.setEnabled(false);
        }
        this.endTimeButton = new Button((Composite)this.rangeGroup, 0);
        this.endTimeButton.setText(Messages.getString("REFER"));
        if (!this.isRange || !this.isPlotAuto) {
            this.endTimeButton.setEnabled(false);
        }
        gridData004 = new GridData(1040);
        gridData004.horizontalSpan = 1;
        this.endTimeButton.setLayoutData((Object)gridData004);
        this.endTimeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Date date = RealtimeSetDialog2.this.endTimeLocal;
                DateTimeDialog dialog = new DateTimeDialog(RealtimeSetDialog2.this.parent);
                dialog.setDate(date);
                dialog.open();
                date = dialog.getDate();
                if (date != null && date.after(RealtimeSetDialog2.this.startTimeLocal) && date.before(RealtimeSetDialog2.this.endTime)) {
                    RealtimeSetDialog2.this.endTimeLocal = date;
                    RealtimeSetDialog2.this.endTimeText.setText(RealtimeSetDialog2.this.dateFormat.format(date));
                }
                dialog = null;
            }
        });
        if (this.isRange) {
            this.endTimeLabel = new Label((Composite)this.rangeGroup, 0);
            this.endTimeLabel.setText(String.valueOf(this.dateFormat.format(this.endTime)) + Messages.getString("BEFORE"));
            gridData004 = new GridData(1040);
            gridData004.horizontalSpan = 1;
            this.endTimeLabel.setLayoutData((Object)gridData004);
        }
        this.composite2.setLayout((Layout)new GridLayout());
    }

    private void createIntervalGroup() {
        this.group4 = new Group(this.composite2, 0);
        GridData gridDataGroup4 = new GridData(768);
        this.group4.setLayoutData((Object)gridDataGroup4);
        this.group4.setText(Messages.getString("GRAPH_REFRESH_INTERVAL_IN_JP"));
        GridLayout gridLayoutRefresh = new GridLayout();
        this.group4.setLayout((Layout)gridLayoutRefresh);
        this.combo = new Combo((Composite)this.group4, 8);
        GridData gridDataRefresh = new GridData(1040);
        this.combo.setLayoutData((Object)gridDataRefresh);
        if (this.isInterval) {
            this.combo.add(Messages.getString("5SEC"));
            this.combo.add(Messages.getString("15SEC"));
            this.combo.add(Messages.getString("30SEC"));
            this.combo.add(Messages.getString("1MIN"));
            this.combo.select(this.comboSetting);
        }
        this.combo.setEnabled(this.isInterval);
    }

    protected void okPressed() {
        this.collectorItemInfo.copyItemInfoForDialog();
        if (this.isInterval) {
            if (this.combo.getSelectionIndex() == 0) {
                this.collectorInfo.setInterval(5);
                this.collectorInfo.setRequestInterval(5);
            } else if (this.combo.getSelectionIndex() == 1) {
                this.collectorInfo.setInterval(15);
                this.collectorInfo.setRequestInterval(15);
            } else if (this.combo.getSelectionIndex() == 2) {
                this.collectorInfo.setInterval(30);
                this.collectorInfo.setRequestInterval(30);
            } else if (this.combo.getSelectionIndex() == 3) {
                this.collectorInfo.setInterval(60);
                this.collectorInfo.setRequestInterval(60);
            }
        }
        if (this.isPlotAuto) {
            this.collectorInfo.setGraphPlotNum(0);
        } else if (this.combo1.getSelectionIndex() == 0) {
            this.collectorInfo.setGraphPlotNum(12);
        } else if (this.combo1.getSelectionIndex() == 1) {
            this.collectorInfo.setGraphPlotNum(24);
        } else if (this.combo1.getSelectionIndex() == 2) {
            this.collectorInfo.setGraphPlotNum(100);
        } else if (this.combo1.getSelectionIndex() == 3) {
            this.collectorInfo.setGraphPlotNum(200);
        }
        if (this.startTimeLocal != null) {
            this.collectorInfo.setGraphStartTime(this.startTimeLocal);
        }
        if (this.endTimeLocal != null) {
            this.collectorInfo.setGraphEndTime(this.endTimeLocal);
        }
        super.okPressed();
    }

    public void setCollectorInfo(RealtimeCollectorInfo collectorInfo) {
        this.collectorInfo = collectorInfo;
    }

    public void setCollectorItemInfo(RealtimeCollectorItemInfo collectorItemInfo) {
        this.collectorItemInfo = collectorItemInfo;
    }

    public void setInterval(boolean isInterval) {
        this.isInterval = isInterval;
    }
}

