/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.composite;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.action.DrawRecordGraphAction;
import com.clustercontrol.performance.bean.GraphProperty;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.ejb.bmp.RecordCollectorData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Paint;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class RecordGraphComposite
extends Composite {
    private Composite composite = null;
    private ScrollBar scrollBar;
    private int interval;
    private int periodSecond;
    private double lowerBoundBase;
    private DrawRecordGraphAction m_action;
    private int m_plot = 30;
    private Frame m_graphFrame;
    private String m_title;
    private String m_timeAxisLabel;
    private String m_valueAxisLabel;
    private JFreeChart m_jfreechart;
    private TimeSeriesCollection m_timeSeriesCollection;
    private final int GRAPH_MAX = 10;
    private TimeSeries[] m_timeseries;
    private GraphProperty graphProperty;
    static /* synthetic */ Class class$0;

    public RecordGraphComposite(Composite parent) {
        super(parent, 256);
        this.initialize();
    }

    public void setMasterData(RecordCollectorData collectorData, List itemInfoList, FacilityTreeItem facilityTree) {
        this.m_action.setData(collectorData, itemInfoList, facilityTree);
    }

    public void drawGraph(GraphProperty graphProperty) {
        this.graphProperty = graphProperty;
        this.clearData();
        this.m_action.drawGraph(graphProperty.getTargetFacility(), graphProperty.getTargetItem().getCollectorItemID(), graphProperty.getGraphType());
    }

    public int getGraphType() {
        return this.m_action.getGraphType();
    }

    public CollectorItemInfo getTargetItem() {
        return this.m_action.getTargetItem();
    }

    public FacilityTreeItem getTargetFacility() {
        return this.m_action.getTargetFacility();
    }

    private void initialize() {
        this.setLayout((Layout)new FillLayout());
        this.m_timeSeriesCollection = new TimeSeriesCollection();
        this.m_timeseries = new TimeSeries[10];
        int i = 0;
        while (i < this.m_timeseries.length) {
            this.m_timeseries[i] = new TimeSeries("", Second.class);
            ++i;
        }
        this.composite = new Composite((Composite)this, 0x1000000);
        GridData graphGridData = new GridData();
        graphGridData.horizontalAlignment = 4;
        graphGridData.verticalAlignment = 4;
        graphGridData.grabExcessHorizontalSpace = true;
        graphGridData.grabExcessVerticalSpace = true;
        GridLayout graphLayout = new GridLayout(1, true);
        this.composite.setLayout((Layout)graphLayout);
        graphLayout.marginHeight = 0;
        graphLayout.marginWidth = 0;
        this.composite.setLayoutData((Object)graphGridData);
        this.scrollBar = this.getHorizontalBar();
        this.scrollBar.setIncrement(10);
        this.m_action = new DrawRecordGraphAction();
        this.scrollBar.addSelectionListener((SelectionListener)this.m_action);
        this.m_action.setComposite(this);
    }

    private void createChart(int graphType, boolean rangeFixed) {
        StandardXYItemRenderer renderer;
        boolean showDetail = graphType == 2;
        this.m_jfreechart = ChartFactory.createTimeSeriesChart((String)this.m_title, (String)this.m_timeAxisLabel, (String)this.m_valueAxisLabel, (XYDataset)this.m_timeSeriesCollection, (boolean)showDetail, (boolean)true, (boolean)false);
        double range = Math.min((double)this.periodSecond * 1000.0, (double)this.interval * 1000.0 * (double)this.m_plot);
        this.setRange(0.0, range);
        XYPlot xyplot = this.m_jfreechart.getXYPlot();
        if (graphType == 1 || graphType == 3) {
            renderer = new StandardXYItemRenderer();
            if (graphType == 3) {
                renderer.setSeriesPaint(0, (Paint)Color.BLACK);
                renderer.setSeriesPaint(1, (Paint)Color.BLUE);
                renderer.setSeriesPaint(2, (Paint)Color.GREEN);
                renderer.setSeriesPaint(3, (Paint)Color.PINK);
                renderer.setSeriesPaint(4, (Paint)Color.CYAN);
                renderer.setSeriesPaint(5, (Paint)Color.LIGHT_GRAY);
                renderer.setSeriesPaint(6, (Paint)Color.MAGENTA);
                renderer.setSeriesPaint(7, (Paint)Color.ORANGE);
                renderer.setSeriesPaint(8, (Paint)Color.YELLOW);
                renderer.setSeriesPaint(9, (Paint)Color.GRAY);
            }
            xyplot.setRenderer((XYItemRenderer)renderer);
        } else {
            renderer = new XYAreaRenderer();
            xyplot.setRenderer((XYItemRenderer)renderer);
        }
        if (rangeFixed) {
            ValueAxis valueaxis = xyplot.getRangeAxis();
            valueaxis.setRange(0.0, 100.0);
        }
        ChartPanel chartPanel = new ChartPanel(this.m_jfreechart);
        if (this.m_graphFrame == null) {
            this.m_graphFrame = SWT_AWT.new_Frame((Composite)this.composite);
        }
        this.m_graphFrame.add((Component)chartPanel);
    }

    public void createGraph(String title, String timeAxisLabel, String valueAxisLabel, int graphType, boolean rangeFixed, int interval, Date startDate, Date stopDate) {
        this.m_title = title;
        this.m_timeAxisLabel = timeAxisLabel;
        this.m_valueAxisLabel = valueAxisLabel;
        this.setTimeScale(interval, startDate, stopDate);
        if (this.m_graphFrame != null) {
            this.m_graphFrame.removeAll();
            this.m_graphFrame = null;
        }
        this.createChart(graphType, rangeFixed);
    }

    public void setGraphData(String name, List dataSet) {
        TimeSeries timeseries = this.m_timeSeriesCollection.getSeries(name);
        if (timeseries == null) {
            timeseries = new TimeSeries(name, Second.class);
            this.m_timeSeriesCollection.addSeries(timeseries);
        }
        for (CollectedDataInfo data : dataSet) {
            if (Double.isNaN(data.getValue()) || !(data.getValue() >= 0.0)) continue;
            timeseries.addOrUpdate((RegularTimePeriod)new Second(data.getDate()), data.getValue());
        }
    }

    public void setSubscopeGraphData(int index, List dataSet) {
        String name = ((CollectedDataInfo)dataSet.get(0)).getFacilityID();
        TimeSeries timeseries = this.m_timeSeriesCollection.getSeries(name);
        if (timeseries == null) {
            this.m_timeSeriesCollection.addSeries(this.m_timeseries[index]);
        }
        for (CollectedDataInfo data : dataSet) {
            if (Double.isNaN(data.getValue()) || !(data.getValue() >= 0.0)) continue;
            this.m_timeseries[index].addOrUpdate((RegularTimePeriod)new Second(data.getDate()), data.getValue());
        }
    }

    public void clearData() {
        this.m_timeSeriesCollection.removeAllSeries();
    }

    private void setTimeScale(int interval, Date startDate, Date endDate) {
        this.interval = interval;
        this.lowerBoundBase = startDate.getTime() + (long)(interval * 1000);
        long upperBound = endDate.getTime();
        this.periodSecond = (int)(((double)upperBound - this.lowerBoundBase) / 1000.0);
        this.scrollBar.setMaximum(this.periodSecond);
        this.scrollBar.setThumb(interval * this.m_plot);
    }

    public void setRange(double lowerBound, double upperBound) {
        ValueAxis domainAxis = this.m_jfreechart.getXYPlot().getDomainAxis();
        domainAxis.setRange(this.lowerBoundBase + lowerBound, this.lowerBoundBase + upperBound);
    }

    public int getPlot() {
        return this.m_plot;
    }

    public void setPlot(int plot) {
        this.m_plot = plot;
    }

    public GraphProperty getGraphProperty() {
        return this.graphProperty;
    }
}

