/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.properties;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.IConfiguredSiteAdapter;

public class ConfiguredSitePropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    public ConfiguredSitePropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        IConfiguredSiteAdapter adapter = (IConfiguredSiteAdapter)this.getElement();
        IConfiguredSite csite = adapter.getConfiguredSite();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.addProperty(composite, UpdateUIMessages.ConfiguredSitePropertyPage_path, csite.getSite().getURL().toString());
        this.addProperty(composite, UpdateUIMessages.ConfiguredSitePropertyPage_type, this.getLocationType(csite));
        this.addProperty(composite, UpdateUIMessages.ConfiguredSitePropertyPage_enabled, csite.isEnabled() ? UpdateUIMessages.ConfiguredSitePropertyPage_yes : UpdateUIMessages.ConfiguredSitePropertyPage_no);
        return composite;
    }

    private String getLocationType(IConfiguredSite csite) {
        if (csite.isExtensionSite()) {
            return UpdateUIMessages.ConfiguredSitePropertyPage_extension;
        }
        if (csite.isProductSite()) {
            return UpdateUIMessages.ConfiguredSitePropertyPage_product;
        }
        return UpdateUIMessages.ConfiguredSitePropertyPage_unknown;
    }

    private void addProperty(Composite parent, String key, String value) {
        Label label = new Label(parent, 0);
        label.setText(key);
        label = new Label(parent, 0);
        label.setText(value);
        GridData gd = new GridData(768);
        label.setLayoutData((Object)gd);
    }
}

