/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.parser;

import org.jfree.xml.parser.RootXmlReadHandler;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractXmlReadHandler
implements XmlReadHandler {
    protected RootXmlReadHandler rootHandler;
    protected String tagName;
    private boolean firstCall = true;

    public void init(RootXmlReadHandler rootXmlReadHandler, String string) {
        if (rootXmlReadHandler == null) {
            throw new NullPointerException("Root handler must not be null");
        }
        if (string == null) {
            throw new NullPointerException("Tag name must not be null");
        }
        this.rootHandler = rootXmlReadHandler;
        this.tagName = string;
    }

    public final void startElement(String string, Attributes attributes) throws XmlReaderException, SAXException {
        if (this.firstCall) {
            if (!this.tagName.equals(string)) {
                throw new SAXException("Expected <" + this.tagName + ">, found <" + string + ">");
            }
            this.firstCall = false;
            this.startParsing(attributes);
        } else {
            XmlReadHandler xmlReadHandler = this.getHandlerForChild(string, attributes);
            if (xmlReadHandler == null) {
                System.err.println("Unknown tag <" + string + ">");
                return;
            }
            xmlReadHandler.init(this.getRootHandler(), string);
            this.rootHandler.recurse(xmlReadHandler, string, attributes);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public final void endElement(String string) throws SAXException {
        if (this.tagName.equals(string)) {
            try {
                this.doneParsing();
                this.rootHandler.unwind(string);
            }
            catch (XmlReaderException xmlReaderException) {
                throw new SAXException(xmlReaderException);
            }
        }
    }

    protected void startParsing(Attributes attributes) throws SAXException {
    }

    protected void doneParsing() throws SAXException, XmlReaderException {
    }

    protected XmlReadHandler getHandlerForChild(String string, Attributes attributes) throws XmlReaderException, SAXException {
        return null;
    }

    public String getTagName() {
        return this.tagName;
    }

    public RootXmlReadHandler getRootHandler() {
        return this.rootHandler;
    }
}

