/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.util.HashMap;
import java.util.Iterator;
import org.jfree.util.Configuration;
import org.jfree.xml.factory.objects.ClassComparator;
import org.jfree.xml.factory.objects.ClassFactory;
import org.jfree.xml.factory.objects.ObjectDescription;

public abstract class ClassFactoryImpl
implements ClassFactory {
    private HashMap classes = new HashMap();
    private ClassComparator comparator = new ClassComparator();
    private Configuration config;

    public ClassComparator getComparator() {
        return this.comparator;
    }

    public ObjectDescription getDescriptionForClass(Class clazz) {
        ObjectDescription objectDescription = (ObjectDescription)this.classes.get(clazz);
        if (objectDescription == null) {
            return null;
        }
        return objectDescription.getInstance();
    }

    public ObjectDescription getSuperClassObjectDescription(Class clazz, ObjectDescription objectDescription) {
        Iterator iterator = this.classes.keySet().iterator();
        while (iterator.hasNext()) {
            Class clazz2 = (Class)iterator.next();
            if (!clazz2.isAssignableFrom(clazz)) continue;
            ObjectDescription objectDescription2 = (ObjectDescription)this.classes.get(clazz2);
            if (objectDescription == null) {
                objectDescription = objectDescription2;
                continue;
            }
            if (!this.comparator.isComparable(objectDescription.getObjectClass(), objectDescription2.getObjectClass()) || this.comparator.compare(objectDescription.getObjectClass(), objectDescription2.getObjectClass()) >= 0) continue;
            objectDescription = objectDescription2;
        }
        if (objectDescription == null) {
            return null;
        }
        return objectDescription.getInstance();
    }

    protected void registerClass(Class clazz, ObjectDescription objectDescription) {
        this.classes.put(clazz, objectDescription);
        if (this.config != null) {
            objectDescription.configure(this.config);
        }
    }

    public Iterator getRegisteredClasses() {
        return this.classes.keySet().iterator();
    }

    public void configure(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("The given configuration is null");
        }
        if (this.config != null) {
            return;
        }
        this.config = configuration;
        Iterator iterator = this.classes.values().iterator();
        while (iterator.hasNext()) {
            ObjectDescription objectDescription = (ObjectDescription)iterator.next();
            objectDescription.configure(configuration);
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClassFactoryImpl)) {
            return false;
        }
        ClassFactoryImpl classFactoryImpl = (ClassFactoryImpl)object;
        return this.classes.equals(classFactoryImpl.classes);
    }

    public int hashCode() {
        return this.classes.hashCode();
    }
}

