/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.text.TextFragment;
import org.jfree.ui.Size2D;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Log;
import org.jfree.util.LogContext;

public class TextLine
implements Serializable {
    private List fragments;
    protected static final LogContext logger = Log.createContext(class$org$jfree$text$TextLine == null ? (class$org$jfree$text$TextLine = TextLine.class$("org.jfree.text.TextLine")) : class$org$jfree$text$TextLine);
    static /* synthetic */ Class class$org$jfree$text$TextLine;

    public TextLine() {
        this.fragments = new ArrayList();
    }

    public TextLine(String string) {
        this(string, TextFragment.DEFAULT_FONT);
    }

    public TextLine(String string, Font font) {
        this.fragments = new ArrayList();
        TextFragment textFragment = new TextFragment(string, font);
        this.fragments.add(textFragment);
    }

    public TextLine(String string, Font font, Paint paint) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'text' argument.");
        }
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.fragments = new ArrayList();
        TextFragment textFragment = new TextFragment(string, font, paint);
        this.fragments.add(textFragment);
    }

    public void addFragment(TextFragment textFragment) {
        this.fragments.add(textFragment);
    }

    public void removeFragment(TextFragment textFragment) {
        this.fragments.remove(textFragment);
    }

    public void draw(Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor, float f3, float f4, double d) {
        float f5 = f;
        float f6 = this.calculateBaselineOffset(graphics2D, textAnchor);
        Iterator iterator = this.fragments.iterator();
        while (iterator.hasNext()) {
            TextFragment textFragment = (TextFragment)iterator.next();
            Size2D size2D = textFragment.calculateDimensions(graphics2D);
            textFragment.draw(graphics2D, f5, f2 + f6, TextAnchor.BASELINE_LEFT, f3, f4, d);
            f5 += (float)size2D.getWidth();
        }
    }

    public Size2D calculateDimensions(Graphics2D graphics2D) {
        double d = 0.0;
        double d2 = 0.0;
        Iterator iterator = this.fragments.iterator();
        while (iterator.hasNext()) {
            TextFragment textFragment = (TextFragment)iterator.next();
            Size2D size2D = textFragment.calculateDimensions(graphics2D);
            d += size2D.getWidth();
            d2 = Math.max(d2, size2D.getHeight());
            if (!logger.isDebugEnabled()) continue;
            logger.debug("width = " + d + ", height = " + d2);
        }
        return new Size2D(d, d2);
    }

    public TextFragment getFirstTextFragment() {
        TextFragment textFragment = null;
        if (this.fragments.size() > 0) {
            textFragment = (TextFragment)this.fragments.get(0);
        }
        return textFragment;
    }

    public TextFragment getLastTextFragment() {
        TextFragment textFragment = null;
        if (this.fragments.size() > 0) {
            textFragment = (TextFragment)this.fragments.get(this.fragments.size() - 1);
        }
        return textFragment;
    }

    private float calculateBaselineOffset(Graphics2D graphics2D, TextAnchor textAnchor) {
        float f = 0.0f;
        TextFragment textFragment = this.getFirstTextFragment();
        if (textFragment != null) {
            f = textFragment.calculateBaselineOffset(graphics2D, textAnchor);
        }
        return f;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof TextLine) {
            TextLine textLine = (TextLine)object;
            return ((Object)this.fragments).equals(textLine.fragments);
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

