/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.factory;

import com.clustercontrol.calendar.ejb.session.CalendarControllerLocal;
import com.clustercontrol.calendar.ejb.session.CalendarControllerUtil;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.monitor.message.LogOutputJobRunInfo;
import com.clustercontrol.monitor.message.LogOutputNotifyInfo;
import com.clustercontrol.monitor.run.bean.MonitorJudgementInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.util.MonitorTransactionManager;
import com.clustercontrol.priority.util.PriorityJudgment;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.util.deadlock.ApplicationDeadlockException;

public abstract class RunMonitor {
    private static final int RETRY_MAX = 1;
    protected static Log m_log = LogFactory.getLog(RunMonitor.class);
    public static final String MESSAGE_INFO = Messages.getString((String)"message.info");
    public static final String MESSAGE_WARNING = Messages.getString((String)"message.warning");
    public static final String MESSAGE_CRITICAL = Messages.getString((String)"message.critical");
    public static final String MESSAGE_UNKNOWN = Messages.getString((String)"message.unknown");
    protected MonitorInfoLocal m_monitor;
    protected String m_monitorTypeId;
    protected String m_monitorId;
    protected String m_notifyId;
    protected String m_facilityId;
    protected int m_failurePriority = -1;
    protected Date m_now;
    protected long m_scopeDate;
    protected long m_nodeDate;
    protected int m_responseTime;
    protected LogOutputNotifyInfo m_notifyInfo;
    protected RepositoryControllerLocal m_repository;
    private SendQueue m_queue;
    protected int m_monitorBlock;
    protected int m_timeout;
    protected int m_jobRun;
    protected boolean m_isNode;
    protected HashMap<Integer, ArrayList<String>> m_priorityMap;
    protected TreeMap<Integer, MonitorJudgementInfo> m_judgementInfoList;

    public RunMonitor() throws NamingException, JMSException, CreateException {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String monitorTypeId, String monitorId) throws FinderException, RemoveException, JMSException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException, CreateException {
        this.m_monitorTypeId = monitorTypeId;
        this.m_monitorId = monitorId;
        TransactionManager tm = null;
        Transaction tx = null;
        Transaction oldTx = null;
        boolean result = false;
        int count = 0;
        boolean deadlock = false;
        try {
            tm = MonitorTransactionManager.getInstance().getTransactionManager();
            if (tm.getTransaction() != null) {
                oldTx = tm.suspend();
            }
            try {
                do {
                    try {
                        ++count;
                        result = false;
                        deadlock = false;
                        if (tm.getTransaction() == null) {
                            tm.begin();
                            tx = tm.getTransaction();
                        }
                        if (!(result = this.runMonitorInfo())) continue;
                        tx.commit();
                    }
                    catch (TransactionRolledbackLocalException e) {
                        if (e.getCausedByException() instanceof ApplicationDeadlockException) {
                            deadlock = true;
                            if (count <= 1) {
                                m_log.debug((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
                            } else {
                                m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
                            }
                            if (tx == null) continue;
                            if (!result) {
                                tx.rollback();
                            }
                            tx = null;
                            continue;
                        }
                        m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
                        throw e;
                    }
                } while (deadlock && count <= 1);
            }
            catch (NotSupportedException e) {
                m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
                throw e;
            }
            catch (RollbackException e) {
                m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
                throw e;
            }
            catch (HeuristicMixedException e) {
                m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
                throw e;
            }
            catch (HeuristicRollbackException e) {
                m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
                throw e;
            }
            catch (SystemException e) {
                m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
                throw e;
            }
            finally {
                if (tx != null) {
                    if (!result) {
                        tx.rollback();
                    }
                    tx = null;
                }
            }
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            this.terminate();
            if (oldTx != null) {
                try {
                    tm.resume(oldTx);
                }
                catch (InvalidTransactionException e) {
                    m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
                    throw e;
                }
                catch (IllegalStateException e) {
                    m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
                    throw e;
                }
                catch (SystemException e) {
                    m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
                    throw e;
                }
            }
            throw throwable;
        }
        this.terminate();
        if (oldTx != null) {
            try {
                tm.resume(oldTx);
            }
            catch (InvalidTransactionException e) {
                m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
                throw e;
            }
            catch (IllegalStateException e) {
                m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
                throw e;
            }
            catch (SystemException e) {
                m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
                throw e;
            }
        }
    }

    public boolean runMonitorInfo() throws FinderException, RemoveException, JMSException, NamingException, CreateException {
        this.m_now = new Date();
        this.m_priorityMap = new HashMap();
        this.m_priorityMap.put(3, new ArrayList());
        this.m_priorityMap.put(2, new ArrayList());
        this.m_priorityMap.put(0, new ArrayList());
        this.m_priorityMap.put(1, new ArrayList());
        try {
            boolean run = this.setMonitorInfo(this.m_monitorTypeId, this.m_monitorId);
            if (!run) {
                return true;
            }
            this.setJudgementInfo();
            this.setCheckInfo();
            ArrayList facilityList = this.m_repository.getNodeFacilityIdList(this.m_facilityId, 0);
            if (facilityList.size() == 0) {
                if (this.m_repository.isNode(this.m_facilityId)) {
                    this.m_isNode = true;
                    facilityList.add(this.m_facilityId);
                } else {
                    return true;
                }
            }
            ArrayList<Integer> priorityList = new ArrayList<Integer>();
            String facilityId = null;
            for (int index = 0; index < facilityList.size(); ++index) {
                facilityId = (String)facilityList.get(index);
                if (facilityId == null || "".equals(facilityId)) continue;
                boolean ret = this.collect(facilityId);
                int checkResult = this.getCheckResult(ret);
                if (1 == this.m_monitorBlock || 2 == this.m_monitorBlock) {
                    int priority = this.getPriority(checkResult);
                    priorityList.add(priority);
                    this.setPriorityMap(priority, facilityId);
                }
                if (this.m_nodeDate > this.m_scopeDate) {
                    this.m_scopeDate = this.m_nodeDate;
                }
                if (0 != this.m_monitorBlock && (1 != this.m_monitorBlock || !this.m_isNode) && 2 != this.m_monitorBlock) continue;
                this.notify(true, facilityId, checkResult, new Date(this.m_nodeDate));
            }
            if (!(this.m_isNode || 1 != this.m_monitorBlock && 2 != this.m_monitorBlock)) {
                Integer priority = PriorityJudgment.judgment(priorityList);
                if (priority == null) {
                    priority = this.m_failurePriority;
                }
                Date generationDate = null;
                generationDate = this.m_scopeDate > 0L ? new Date(this.m_scopeDate) : this.m_now;
                this.notify(false, this.m_facilityId, priority, generationDate);
            }
            return true;
        }
        catch (FinderException e) {
            m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
            throw e;
        }
        catch (CreateException e) {
            m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
            throw e;
        }
        catch (JMSException e) {
            m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
            throw e;
        }
    }

    public abstract void setJudgementInfo();

    public abstract void setCheckInfo() throws FinderException, NamingException;

    public abstract boolean collect(String var1);

    public abstract int getCheckResult(boolean var1);

    public int getPriority(int key) {
        MonitorJudgementInfo info = this.m_judgementInfoList.get(key);
        if (info != null) {
            return info.getPriority();
        }
        return this.m_failurePriority;
    }

    public String getNotifyId() {
        return this.m_notifyId;
    }

    public String getMessageId(int key) {
        MonitorJudgementInfo info = this.m_judgementInfoList.get(key);
        if (info != null && info.getMessageId() != null) {
            return info.getMessageId();
        }
        return "";
    }

    public String getMessage(int key) {
        MonitorJudgementInfo info = this.m_judgementInfoList.get(key);
        if (info != null && info.getMessage() != null) {
            return info.getMessage();
        }
        return "";
    }

    public abstract String getMessageOrg(int var1);

    public String getMessageIdForScope(int priority) {
        Set<Integer> set = this.m_judgementInfoList.keySet();
        for (Integer key : set) {
            MonitorJudgementInfo info = this.m_judgementInfoList.get(key);
            if (priority != info.getPriority() || info.getMessageId() == null) continue;
            return info.getMessageId();
        }
        return "";
    }

    public String getMessageForScope(int priority) {
        if (priority == 3) {
            return MESSAGE_INFO;
        }
        if (priority == 2) {
            return MESSAGE_WARNING;
        }
        if (priority == 0) {
            return MESSAGE_CRITICAL;
        }
        return MESSAGE_UNKNOWN;
    }

    public String getMessageOrgForScope(int priority) {
        ArrayList<String> info = this.m_priorityMap.get(3);
        ArrayList<String> warning = this.m_priorityMap.get(2);
        ArrayList<String> critical = this.m_priorityMap.get(0);
        ArrayList<String> unknown = this.m_priorityMap.get(1);
        StringBuffer summary = new StringBuffer();
        summary.append(Messages.getString((String)"info") + ":" + info.size() + Messages.getString((String)"record") + ", ");
        summary.append(Messages.getString((String)"warning") + ":" + warning.size() + Messages.getString((String)"record") + ", ");
        summary.append(Messages.getString((String)"critical") + ":" + critical.size() + Messages.getString((String)"record") + ", ");
        summary.append(Messages.getString((String)"unknown") + ":" + unknown.size() + Messages.getString((String)"record"));
        StringBuffer detail = new StringBuffer();
        detail.append(this.getItemListString("\n" + Messages.getString((String)"info"), info));
        detail.append(this.getItemListString("\n" + Messages.getString((String)"warning"), warning));
        detail.append(this.getItemListString("\n" + Messages.getString((String)"critical"), critical));
        detail.append(this.getItemListString("\n" + Messages.getString((String)"unknown"), unknown));
        return summary.toString() + detail.toString();
    }

    public LogOutputJobRunInfo getJobRunInfo(int key) {
        MonitorJudgementInfo info;
        if (this.m_jobRun == 0) {
            return null;
        }
        LogOutputJobRunInfo jobRunInfo = null;
        if (key != -1 && (info = this.m_judgementInfoList.get(key)) != null) {
            jobRunInfo = new LogOutputJobRunInfo();
            jobRunInfo.setJobRun(info.getJobRun());
            jobRunInfo.setJobId(info.getJobId());
            jobRunInfo.setJobInhibitionFlg(info.getJobInhibitionFlg());
            jobRunInfo.setJobFailurePriority(info.getJobFailurePriority());
        }
        return jobRunInfo;
    }

    public LogOutputJobRunInfo getJobRunInfoForScope(int priority) {
        if (this.m_jobRun == 0) {
            return null;
        }
        LogOutputJobRunInfo jobRunInfo = null;
        if (priority != -1) {
            Set<Integer> set = this.m_judgementInfoList.keySet();
            for (Integer key : set) {
                MonitorJudgementInfo info = this.m_judgementInfoList.get(key);
                if (info == null || priority != info.getPriority()) continue;
                jobRunInfo = new LogOutputJobRunInfo();
                jobRunInfo.setJobRun(info.getJobRun());
                jobRunInfo.setJobId(info.getJobId());
                jobRunInfo.setJobInhibitionFlg(info.getJobInhibitionFlg());
                jobRunInfo.setJobFailurePriority(info.getJobFailurePriority());
                return jobRunInfo;
            }
        }
        return jobRunInfo;
    }

    protected boolean setMonitorInfo(String monitorTypeId, String monitorId) throws FinderException, NamingException, CreateException {
        MonitorInfoPK pk = new MonitorInfoPK(monitorId, monitorTypeId);
        this.m_monitor = MonitorInfoUtil.getLocalHome().findByPrimaryKey(pk);
        this.m_notifyId = this.m_monitor.getNotifyId();
        if ((this.m_notifyId == null || "".equals(this.m_notifyId)) && this.m_monitor.getMonitorType() != 2) {
            return false;
        }
        String calendarId = this.m_monitor.getCalendarId();
        if (calendarId != null && !"".equals(calendarId)) {
            CalendarControllerLocal calendar = CalendarControllerUtil.getLocalHome().create();
            try {
                if (!calendar.isRun(calendarId, this.m_now).booleanValue()) {
                    m_log.debug((Object)("setMonitorInfo() : \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ",\u30ab\u30ec\u30f3\u30c0ID\uff1a" + calendarId + "\u3002\u975e\u7a3c\u50cd\u65e5\u306e\u70ba\u3001\u76e3\u8996\u306f\u5b9f\u884c\u3055\u308c\u307e\u305b\u3093\u3002"));
                    return false;
                }
            }
            catch (FinderException e) {
                m_log.info((Object)("setMonitorInfo() : \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + "\u3002\u30ab\u30ec\u30f3\u30c0ID\u300c" + calendarId + "\u300d\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002"));
                return false;
            }
        }
        this.m_facilityId = this.m_monitor.getFacilityId();
        this.m_monitorBlock = this.m_monitor.getMonitorBlock();
        this.m_timeout = this.m_monitor.getTimeout();
        this.m_failurePriority = this.m_monitor.getFailurePriority();
        this.m_jobRun = this.m_monitor.getJobRun();
        return true;
    }

    protected void notify(boolean isNode, String facilityId, int result, Date generationDate) throws FinderException, JMSException, NamingException {
        String notifyId = this.getNotifyId();
        if (notifyId == null || "".equals(notifyId)) {
            return;
        }
        if (this.m_notifyInfo == null) {
            this.m_notifyInfo = new LogOutputNotifyInfo();
            this.m_notifyInfo.setPluginId(this.m_monitorTypeId);
            this.m_notifyInfo.setMonitorId(this.m_monitorId);
            this.m_notifyInfo.setApplication(this.m_monitor.getApplication());
        }
        this.m_notifyInfo.setNotifyId(notifyId);
        String facilityPath = this.m_repository.getFacilityPath(facilityId, null);
        this.m_notifyInfo.setFacilityId(facilityId);
        this.m_notifyInfo.setScopeText(facilityPath);
        int priority = -1;
        String messageId = "";
        String message = "";
        String messageOrg = "";
        LogOutputJobRunInfo jobRunInfo = null;
        if (isNode) {
            priority = this.getPriority(result);
            messageId = this.getMessageId(result);
            message = this.getMessage(result);
            messageOrg = this.getMessageOrg(result);
            jobRunInfo = this.getJobRunInfo(result);
        } else {
            priority = result;
            messageId = this.getMessageIdForScope(result);
            message = this.getMessageForScope(result);
            messageOrg = this.getMessageOrgForScope(result);
            jobRunInfo = this.getJobRunInfoForScope(result);
        }
        this.m_notifyInfo.setPriority(priority);
        this.m_notifyInfo.setMessageId(messageId);
        this.m_notifyInfo.setMessage(message);
        this.m_notifyInfo.setMessageOrg(messageOrg);
        this.m_notifyInfo.setJobRun(jobRunInfo);
        this.m_notifyInfo.setGenerationDate(generationDate);
        this.m_queue.put((Serializable)this.m_notifyInfo);
    }

    protected void setPriorityMap(Integer priority, String facilityId) throws NamingException, FinderException {
        ArrayList<String> list = this.m_priorityMap.get(priority);
        if (list != null) {
            String facilityName = this.m_repository.getFacilityPath(facilityId, null);
            list.add(facilityName);
            this.m_priorityMap.put(priority, list);
        }
    }

    protected String getItemListString(String item, ArrayList list) {
        int length = list.size();
        if (length > 0) {
            StringBuffer result = new StringBuffer();
            result.append(item + ":" + "\n");
            for (int i = 0; i < length; ++i) {
                result.append("\t" + list.get(i));
                if (i >= length - 1) continue;
                result.append("\n");
            }
            return result.toString();
        }
        return "";
    }

    private void initialize() throws NamingException, JMSException, CreateException {
        this.m_queue = new SendQueue("queue/clustercontrol/Monitor/EventLog");
        try {
            this.m_repository = RepositoryControllerUtil.getLocalHome().create();
        }
        catch (CreateException e) {
            m_log.error((Object)("initialize():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.error((Object)("initialize():" + e.getMessage()));
            throw e;
        }
    }

    protected void terminate() throws JMSException, RemoveException {
        try {
            if (this.m_queue != null) {
                this.m_queue.terminate();
            }
            this.m_queue = null;
            if (this.m_repository != null) {
                this.m_repository.remove();
            }
            this.m_repository = null;
        }
        catch (JMSException e) {
            m_log.error((Object)("terminate():" + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            m_log.error((Object)("terminate():" + e.getMessage()));
            throw e;
        }
    }
}

