/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.performanceMGR.bean.DeviceData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeviceDAO {
    protected static Log m_log = LogFactory.getLog(DeviceDAO.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int numberDevicePieces(String collectorId, String facilityId, String Oid) throws EJBException {
        m_log.debug((Object)("selectCountDevice() start :" + collectorId + " " + facilityId + " " + Oid));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        int ret = 0;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT COUNT (*) AS INDEX FROM DEVICE WHERE COLLECTORID=? AND FACILITYID = ? AND OBJECTID LIKE ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, collectorId);
                stmt.setString(2, facilityId);
                stmt.setString(3, Oid);
                res = stmt.executeQuery();
                if (res.next()) {
                    ret = res.getInt("INDEX");
                }
            }
            catch (SQLException e) {
                m_log.error((Object)("selectDevice() error :" + collectorId + " " + facilityId + " " + Oid + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("selectDevice() error :" + collectorId + " " + facilityId + " " + Oid + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("selectDevice() error :" + collectorId + " " + facilityId + " " + Oid + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (res != null) {
            res.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("selectDevice() end :" + collectorId + " " + facilityId + " " + Oid));
        return ret;
    }

    public void insertDeviceData(String collcetorID, DeviceData dData) throws EJBException, CreateException {
        m_log.debug((Object)("insertDeviceData() start :" + collcetorID + " " + dData.getFacilityId() + " " + dData.getOid()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "INSERT INTO DEVICE (collectorID, facilityID,objectID,index,device_name,device_type)values (?,?,?,?,?,?);";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, collcetorID);
            stmt.setString(2, dData.getFacilityId());
            stmt.setString(3, dData.getOid());
            stmt.setInt(4, dData.getDeviceIndex());
            stmt.setString(5, dData.getDeviceName());
            stmt.setString(6, dData.getDeviceType());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("insertDeviceData() error :" + dData.toString() + " SQLException" + msg));
                throw new CreateException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("insertDeviceData() error :" + dData.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("insertDeviceData() error :" + dData.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("insertDeviceData() start :" + collcetorID + " " + dData.getFacilityId() + " " + dData.getOid()));
    }

    public Collection selectDeviceByCollectorID(String collectorID) throws EJBException {
        m_log.debug((Object)("selectDeviceByCollectorID() start :" + collectorID));
        ArrayList<DeviceData> ret = new ArrayList<DeviceData>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM DEVICE WHERE COLLECTORID=?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, collectorID);
            res = stmt.executeQuery();
            while (res.next()) {
                DeviceData dData = new DeviceData();
                dData.setFacilityId(res.getString("FACILITYID"));
                dData.setOid(res.getString("OBJECTID"));
                dData.setDeviceIndex(res.getInt("INDEX"));
                dData.setDeviceName(res.getString("DEVICE_NAME"));
                dData.setDeviceType(res.getString("DEVICE_TYPE"));
                ret.add(dData);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("selectDeviceByCollectorID() error :" + collectorID + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("selectDeviceByCollectorID() error :" + collectorID + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("selectDeviceByCollectorID() end :" + collectorID));
        return ret;
    }

    public void deleteDeviceDataByCollectorID(String collectorID) throws EJBException {
        m_log.debug((Object)("deleteDeviceDataByCollectorID() start :" + collectorID));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM DEVICE WHERE COLLECTORID = ? ";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, collectorID);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            m_log.error((Object)("deleteDeviceDataByCollectorID() error :" + collectorID + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("deleteDeviceDataByCollectorID() error :" + collectorID + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("deleteDeviceDataByCollectorID() end :" + collectorID));
    }
}

