/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFileVirtualizer
extends JRAbstractLRUVirtualizer {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$fill$JRFileVirtualizer == null ? (class$net$sf$jasperreports$engine$fill$JRFileVirtualizer = JRFileVirtualizer.class$("net.sf.jasperreports.engine.fill.JRFileVirtualizer")) : class$net$sf$jasperreports$engine$fill$JRFileVirtualizer));
    public static final String PROPERTY_TEMP_FILES_SET_DELETE_ON_EXIT = "net.sf.jasperreports.virtulazer.temp.files.set.delete.on.exit";
    private final String directory;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRFileVirtualizer;

    public JRFileVirtualizer(int maxSize) {
        this(maxSize, null);
    }

    public JRFileVirtualizer(int maxSize, String directory) {
        super(maxSize);
        this.directory = directory;
    }

    private String makeFilename(JRVirtualizable o) {
        String uid = o.getUID();
        return "virt" + uid;
    }

    private String makeFilename(String virtualId) {
        return "virt" + virtualId;
    }

    protected void pageOut(JRVirtualizable o) throws IOException {
        String filename = this.makeFilename(o);
        File file = new File(this.directory, filename);
        if (file.createNewFile()) {
            if (JRProperties.getBooleanProperty(PROPERTY_TEMP_FILES_SET_DELETE_ON_EXIT)) {
                file.deleteOnExit();
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                BufferedOutputStream bufferedOut = new BufferedOutputStream(fos);
                this.writeData(o, bufferedOut);
            }
            catch (FileNotFoundException e) {
                log.error((Object)"Error virtualizing object", (Throwable)e);
                throw new JRRuntimeException(e);
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        } else if (!this.isReadOnly(o)) {
            throw new IllegalStateException("Cannot virtualize data because the file \"" + filename + "\" already exists.");
        }
    }

    protected void pageIn(JRVirtualizable o) throws IOException {
        String filename = this.makeFilename(o);
        File file = new File(this.directory, filename);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            BufferedInputStream bufferedIn = new BufferedInputStream(fis);
            this.readData(o, bufferedIn);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"Error devirtualizing object", (Throwable)e);
            throw new JRRuntimeException(e);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        if (!this.isReadOnly(o)) {
            file.delete();
        }
    }

    protected void dispose(String virtualId) {
        String filename = this.makeFilename(virtualId);
        File file = new File(this.directory, filename);
        file.delete();
    }

    public synchronized void cleanup() {
        this.disposeAll();
        this.reset();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

