/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MaintenanceProperties {
    protected static Log m_log = LogFactory.getLog(MaintenanceProperties.class);
    private static final String DELETE_BUF_SIZE_PATH = "delete.buf.size";
    private static MaintenanceProperties instance = null;
    private static int deleteBufSize = 100;

    private MaintenanceProperties() {
        this.setValue();
    }

    public static MaintenanceProperties getInstance() {
        if (instance == null) {
            instance = new MaintenanceProperties();
        }
        return instance;
    }

    private void setValue() {
        Properties properties = new Properties();
        try {
            String homedir = System.getProperty("jboss.server.home.dir");
            String propertyFile = homedir + File.separator + "conf" + File.separator + "maintenance.properties";
            properties.load(new FileInputStream(propertyFile));
            String deleteBufSizeString = properties.getProperty(DELETE_BUF_SIZE_PATH, new Integer(deleteBufSize).toString());
            try {
                deleteBufSize = Integer.parseInt(deleteBufSizeString);
            }
            catch (NumberFormatException e) {
                m_log.warn((Object)("setValue() delete.buf.size parse failed :" + e.getMessage()));
            }
        }
        catch (FileNotFoundException e) {
            m_log.warn((Object)("setValue() maintenance.properties not found : " + e.getMessage()));
        }
        catch (IOException e) {
            m_log.error((Object)("setValue(): " + e.getMessage()));
        }
    }

    public int getDeleteBufSize() {
        return deleteBufSize;
    }
}

