/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.Messages;
import org.eclipse.ui.views.markers.internal.SelectionProviderAdapter;
import org.eclipse.ui.views.markers.internal.TableContentProvider;
import org.eclipse.ui.views.markers.internal.TableSortAction;
import org.eclipse.ui.views.markers.internal.TableSortDialog;
import org.eclipse.ui.views.markers.internal.TableSorter;
import org.eclipse.ui.views.markers.internal.TableViewLabelProvider;

public abstract class TableView
extends ViewPart {
    private TableContentProvider content;
    private static final String TAG_COLUMN_WIDTH = "columnWidth";
    private static final String TAG_VERTICAL_POSITION = "verticalPosition";
    private static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    public static final String SORT_ACTION_ID = "sort";
    public static final String FILTERS_ACTION_ID = "filters";
    private TableViewer viewer;
    private IMemento memento;
    private Map actions = new HashMap();
    private ISelectionProvider selectionProvider = new SelectionProviderAdapter();
    private TableSorter sorter;
    static /* synthetic */ Class class$0;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    void haltTableUpdates() {
        this.content.cancelPendingChanges();
    }

    void change(Collection toRefresh) {
        this.content.change(toRefresh);
    }

    void setContents(Collection contents, IProgressMonitor mon) {
        this.content.set(contents, mon);
    }

    protected ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    protected abstract void viewerSelectionChanged(IStructuredSelection var1);

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer(this.createTable(parent));
        this.createColumns(this.viewer.getTable());
        this.content = new TableContentProvider(this.viewer, Messages.format("TableView.populating", new Object[]{this.getTitle()}), this.getProgressService());
        this.viewer.setContentProvider((IContentProvider)this.content);
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableViewLabelProvider(this.getVisibleFields()));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                TableView.this.viewerSelectionChanged(selection);
            }
        });
        this.setSorter(this.getSorter());
        this.createActions();
        this.viewer.setInput(this.getViewerInput());
        this.viewer.setSelection((ISelection)this.restoreSelection(this.memento));
        Scrollable scrollable = (Scrollable)this.viewer.getControl();
        ScrollBar bar = scrollable.getVerticalBar();
        if (bar != null) {
            bar.setSelection(this.restoreVerticalScrollBarPosition(this.memento));
        }
        if ((bar = scrollable.getHorizontalBar()) != null) {
            bar.setSelection(this.restoreHorizontalScrollBarPosition(this.memento));
        }
        MenuManager mgr = this.initContextMenu();
        Menu menu = mgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mgr, this.getSelectionProvider());
        this.getSite().setSelectionProvider(this.getSelectionProvider());
        this.initActionBars(this.getViewSite().getActionBars());
        this.registerGlobalActions(this.getViewSite().getActionBars());
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TableView.this.handleOpenEvent(event);
            }
        });
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TableView.this.handleKeyPressed(e);
            }
        });
    }

    protected void setSelection(IStructuredSelection selection) {
        this.getSelectionProvider().setSelection((ISelection)selection);
    }

    void setSorter(TableSorter sorter2) {
        TableSorter newSorter;
        this.sorter = newSorter = new TableSorter(sorter2);
        this.content.setSorter(newSorter);
        newSorter.saveState(this.getDialogSettings());
        this.sorterChanged();
    }

    protected Table createTable(Composite parent) {
        Table table = new Table(parent, 66306);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        return table;
    }

    public ColumnPixelData[] getSavedColumnData() {
        ColumnPixelData[] defaultData = this.getDefaultColumnLayouts();
        ColumnPixelData[] result = new ColumnPixelData[defaultData.length];
        int i = 0;
        while (i < defaultData.length) {
            Integer widthInt;
            ColumnPixelData cfr_ignored_0 = result[i];
            int width = defaultData[i].width;
            ColumnPixelData defaultPixelData = defaultData[i];
            if (defaultPixelData.resizable && this.memento != null && (widthInt = this.memento.getInteger(TAG_COLUMN_WIDTH + i)) != null && widthInt > 0) {
                width = widthInt;
            }
            result[i] = new ColumnPixelData(width, defaultPixelData.resizable, defaultPixelData.addTrim);
            ++i;
        }
        return result;
    }

    public ColumnPixelData[] getColumnData() {
        ColumnPixelData[] defaultData = this.getSavedColumnData();
        Table table = this.getTable();
        if (table != null && (table.isDisposed() || table.getBounds().width == 0)) {
            table = null;
        }
        TableColumn[] column = null;
        if (table != null) {
            column = table.getColumns();
        }
        ColumnPixelData[] result = new ColumnPixelData[defaultData.length];
        int i = 0;
        while (i < defaultData.length) {
            TableColumn col;
            ColumnPixelData cfr_ignored_0 = result[i];
            ColumnPixelData defaultPixelData = defaultData[i];
            int width = defaultData[i].width;
            if (column != null && i < column.length && (col = column[i]).getWidth() > 0) {
                width = col.getWidth();
            }
            result[i] = new ColumnPixelData(width, defaultPixelData.resizable, defaultPixelData.addTrim);
            ++i;
        }
        return result;
    }

    protected void createColumns(Table table) {
        SelectionListener headerListener = this.getHeaderListener();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        IField[] fields = this.getVisibleFields();
        ColumnPixelData[] columnWidths = this.getSavedColumnData();
        int i = 0;
        while (i < fields.length) {
            layout.addColumnData((ColumnLayoutData)columnWidths[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setText(fields[i].getColumnHeaderText());
            tc.setImage(fields[i].getColumnHeaderImage());
            tc.addSelectionListener(headerListener);
            ++i;
        }
    }

    protected void createActions() {
        if (this.getSortDialog() != null) {
            this.putAction(SORT_ACTION_ID, (IAction)new TableSortAction(this, this.getSortDialog()));
        }
    }

    protected IAction getAction(String id) {
        return (IAction)this.actions.get(id);
    }

    protected void putAction(String id, IAction action) {
        this.actions.put(id, action);
    }

    protected MenuManager initContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TableView.this.getViewer().cancelEditing();
                TableView.this.fillContextMenu(mgr);
            }
        });
        return mgr;
    }

    protected abstract void initToolBar(IToolBarManager var1);

    protected void initActionBars(IActionBars actionBars) {
        this.initMenu(actionBars.getMenuManager());
        this.initToolBar(actionBars.getToolBarManager());
    }

    protected void initMenu(IMenuManager menu) {
        IAction filtersAction;
        IAction sortAction = this.getAction(SORT_ACTION_ID);
        if (sortAction != null) {
            menu.add(sortAction);
        }
        if ((filtersAction = this.getAction(FILTERS_ACTION_ID)) != null) {
            menu.add(filtersAction);
        }
    }

    protected abstract void registerGlobalActions(IActionBars var1);

    protected abstract void fillContextMenu(IMenuManager var1);

    public void setFocus() {
        TableViewer viewer = this.getViewer();
        if (viewer != null && !viewer.getControl().isDisposed()) {
            viewer.getControl().setFocus();
        }
    }

    protected TableSorter getSorter() {
        if (this.sorter == null) {
            int[] priorities = new int[this.getFields().length];
            int[] directions = new int[this.getFields().length];
            int i = 0;
            while (i < this.getFields().length) {
                priorities[i] = i;
                ++i;
            }
            Arrays.fill(directions, 1);
            this.sorter = new TableSorter(this.getFields(), priorities, directions);
            this.sorter.restoreState(this.getDialogSettings());
        }
        return this.sorter;
    }

    protected IField[] getFields() {
        IField[] vProps = this.getVisibleFields();
        IField[] hProps = this.getHiddenFields();
        IField[] fields = new IField[vProps.length + hProps.length];
        System.arraycopy(vProps, 0, fields, 0, vProps.length);
        System.arraycopy(hProps, 0, fields, vProps.length, hProps.length);
        return fields;
    }

    protected abstract Object getViewerInput();

    protected abstract IField[] getVisibleFields();

    protected abstract IField[] getHiddenFields();

    protected abstract IDialogSettings getDialogSettings();

    protected TableViewer getViewer() {
        return this.viewer;
    }

    protected Table getTable() {
        TableViewer v = this.getViewer();
        if (v == null) {
            return null;
        }
        return v.getTable();
    }

    protected SelectionListener getHeaderListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = TableView.this.getViewer().getTable().indexOf((TableColumn)e.widget);
                if (column == TableView.this.getSorter().getTopPriority()) {
                    TableView.this.getSorter().reverseTopPriority();
                } else {
                    TableView.this.getSorter().setTopPriority(column);
                }
                TableView.this.setSorter(TableView.this.getSorter());
            }
        };
    }

    protected abstract ColumnPixelData[] getDefaultColumnLayouts();

    protected TableSortDialog getSortDialog() {
        if (this.getSorter() != null) {
            return new TableSortDialog((IShellProvider)this.getSite(), this.getSorter());
        }
        return null;
    }

    protected void sorterChanged() {
        this.viewer.setSorter((ViewerSorter)this.getSorter());
        final TableViewer viewer = this.getViewer();
        if (viewer == null) {
            return;
        }
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                viewer.getControl().setRedraw(false);
                viewer.refresh(false);
                viewer.getControl().setRedraw(true);
            }
        });
    }

    protected abstract void handleKeyPressed(KeyEvent var1);

    protected abstract void handleOpenEvent(OpenEvent var1);

    public void saveState(IMemento memento) {
        super.saveState(memento);
        ColumnPixelData[] data = this.getColumnData();
        int i = 0;
        while (i < data.length) {
            ColumnPixelData data2 = data[i];
            memento.putInteger(TAG_COLUMN_WIDTH + i, data2.width);
            ++i;
        }
        this.saveSelection(memento);
        Scrollable scrollable = (Scrollable)this.viewer.getControl();
        ScrollBar bar = scrollable.getVerticalBar();
        int position = bar != null ? bar.getSelection() : 0;
        memento.putInteger(TAG_VERTICAL_POSITION, position);
        bar = scrollable.getHorizontalBar();
        position = bar != null ? bar.getSelection() : 0;
        memento.putInteger(TAG_HORIZONTAL_POSITION, position);
    }

    protected abstract void saveSelection(IMemento var1);

    protected abstract IStructuredSelection restoreSelection(IMemento var1);

    private int restoreVerticalScrollBarPosition(IMemento memento) {
        if (memento == null) {
            return 0;
        }
        Integer position = memento.getInteger(TAG_VERTICAL_POSITION);
        return position == null ? 0 : position;
    }

    private int restoreHorizontalScrollBarPosition(IMemento memento) {
        if (memento == null) {
            return 0;
        }
        Integer position = memento.getInteger(TAG_HORIZONTAL_POSITION);
        return position == null ? 0 : position;
    }

    protected IWorkbenchSiteProgressService getProgressService() {
        Object siteService;
        IWorkbenchSiteProgressService service = null;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((siteService = iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            service = (IWorkbenchSiteProgressService)siteService;
        }
        return service;
    }
}

