/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.ImageFactory;
import org.eclipse.ui.views.markers.internal.Messages;
import org.eclipse.ui.views.markers.internal.TaskMarker;

public class FieldPriority
implements IField {
    static final String DESCRIPTION_IMAGE_PATH = "obj16/header_priority.gif";
    static final String HIGH_PRIORITY_IMAGE_PATH = "obj16/hprio_tsk.gif";
    static final String LOW_PRIORITY_IMAGE_PATH = "obj16/lprio_tsk.gif";
    private String description = Messages.getString("priority.description");
    private Image image = ImageFactory.getImage("obj16/header_priority.gif");

    public String getDescription() {
        return this.description;
    }

    public Image getDescriptionImage() {
        return this.image;
    }

    public String getColumnHeaderText() {
        return "";
    }

    public Image getColumnHeaderImage() {
        return this.image;
    }

    public String getValue(Object obj) {
        return "";
    }

    public Image getImage(Object obj) {
        if (obj == null || !(obj instanceof TaskMarker)) {
            return null;
        }
        try {
            int priority = ((TaskMarker)obj).getPriority();
            if (priority == 2) {
                return ImageFactory.getImage(HIGH_PRIORITY_IMAGE_PATH);
            }
            if (priority == 0) {
                return ImageFactory.getImage(LOW_PRIORITY_IMAGE_PATH);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return null;
    }

    public int compare(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null || !(obj1 instanceof TaskMarker) || !(obj2 instanceof TaskMarker)) {
            return 0;
        }
        int priority1 = ((TaskMarker)obj1).getPriority();
        int priority2 = ((TaskMarker)obj2).getPriority();
        return priority1 - priority2;
    }
}

