/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.internal.resources.mapping.ResourceMapping;
import org.eclipse.core.internal.resources.mapping.ResourceMappingContext;
import org.eclipse.core.internal.resources.mapping.ResourceTraversal;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CompositeResourceMapping
extends ResourceMapping {
    private final Object modelObject;
    private final ResourceMapping[] mappings;
    private final IProject[] projects;

    public CompositeResourceMapping(Object modelObject, ResourceMapping[] mappings) {
        this.modelObject = modelObject;
        this.mappings = mappings;
        this.projects = this.getProjects(mappings);
    }

    private IProject[] getProjects(ResourceMapping[] mappings) {
        HashSet<IProject> result = new HashSet<IProject>();
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            result.addAll(Arrays.asList(mapping.getProjects()));
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public Object getModelObject() {
        return this.modelObject;
    }

    public IProject[] getProjects() {
        return this.projects;
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        ResourceTraversal[] resourceTraversalArray;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(null, 100 * this.mappings.length);
            ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
            int i = 0;
            while (i < this.mappings.length) {
                ResourceMapping mapping = this.mappings[i];
                result.addAll(Arrays.asList(mapping.getTraversals(context, (IProgressMonitor)new SubProgressMonitor(monitor, 100))));
                ++i;
            }
            resourceTraversalArray = result.toArray(new ResourceTraversal[result.size()]);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return resourceTraversalArray;
    }
}

