/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public class ChooseWorkspaceData {
    private static final int RECENT_MAX_LENGTH = 5;
    private static final String PERS_FOLDER = "org.eclipse.ui.ide";
    private static final String PERS_FILENAME = "recentWorkspaces.xml";
    private static final int PERS_ENCODING_VERSION = 1;
    private static final int PERS_ENCODING_VERSION_CONFIG_PREFS = 2;
    private boolean showDialog = true;
    private String initialDefault;
    private String selection;
    private String[] recentWorkspaces;

    public ChooseWorkspaceData(String initialDefault) {
        this.readPersistedData();
        this.setInitialDefault(initialDefault);
    }

    public ChooseWorkspaceData(URL instanceUrl) {
        this.readPersistedData();
        if (instanceUrl != null) {
            this.setInitialDefault(new File(instanceUrl.getFile()).toString());
        }
    }

    public String getInitialDefault() {
        if (this.initialDefault == null) {
            this.setInitialDefault(String.valueOf(System.getProperty("user.dir")) + File.separator + "workspace");
        }
        return this.initialDefault;
    }

    private void setInitialDefault(String dir) {
        if (dir == null || dir.length() <= 0) {
            this.initialDefault = null;
            return;
        }
        dir = new Path(dir).toOSString();
        while (dir.charAt(dir.length() - 1) == File.separatorChar) {
            dir = dir.substring(0, dir.length() - 1);
        }
        this.initialDefault = dir;
    }

    public String getSelection() {
        return this.selection;
    }

    public boolean getShowDialog() {
        return this.showDialog;
    }

    public String[] getRecentWorkspaces() {
        return this.recentWorkspaces;
    }

    public void workspaceSelected(String dir) {
        this.selection = dir;
    }

    public void toggleShowDialog() {
        this.showDialog = !this.showDialog;
    }

    public void writePersistedData() {
        IEclipsePreferences node = new ConfigurationScope().getNode(PERS_FOLDER);
        node.putBoolean("SHOW_WORKSPACE_SELECTION_DIALOG", this.showDialog);
        node.putInt("MAX_RECENT_WORKSPACES", this.recentWorkspaces.length);
        if (this.selection != null) {
            String oldEntry = this.recentWorkspaces[0];
            this.recentWorkspaces[0] = this.selection;
            int i = 1;
            while (i < this.recentWorkspaces.length && oldEntry != null) {
                if (this.selection.equals(oldEntry)) break;
                String tmp = this.recentWorkspaces[i];
                this.recentWorkspaces[i] = oldEntry;
                oldEntry = tmp;
                ++i;
            }
        }
        String encodedRecentWorkspaces = ChooseWorkspaceData.encodeStoredWorkspacePaths(this.recentWorkspaces);
        node.put("RECENT_WORKSPACES", encodedRecentWorkspaces);
        node.putInt("RECENT_WORKSPACES_PROTOCOL", 2);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    /*
     * Exception decompiling
     */
    private boolean readPersistedData_file() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [8 : 290->293)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean getShowDialogValue() {
        ChooseWorkspaceData data = new ChooseWorkspaceData("");
        return data.readPersistedData() ? data.showDialog : true;
    }

    public static void setShowDialogValue(boolean showDialog) {
        ChooseWorkspaceData data = new ChooseWorkspaceData("");
        data.showDialog = showDialog;
        data.writePersistedData();
    }

    public boolean readPersistedData() {
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ConfigurationScope(), PERS_FOLDER);
        int protocol = store.getInt("RECENT_WORKSPACES_PROTOCOL");
        if (protocol == 0 && this.readPersistedData_file()) {
            return true;
        }
        this.showDialog = store.getBoolean("SHOW_WORKSPACE_SELECTION_DIALOG");
        int max = store.getInt("MAX_RECENT_WORKSPACES");
        max = Math.max(max, 5);
        String workspacePathPref = store.getString("RECENT_WORKSPACES");
        this.recentWorkspaces = ChooseWorkspaceData.decodeStoredWorkspacePaths(max, workspacePathPref);
        return true;
    }

    private static String encodeStoredWorkspacePaths(String[] recent) {
        StringBuffer buff = new StringBuffer();
        String path = null;
        int i = 0;
        while (i < recent.length) {
            if (recent[i] == null) break;
            if (path != null) {
                buff.append(",");
            }
            path = recent[i];
            buff.append(path);
            ++i;
        }
        return buff.toString();
    }

    private static String[] decodeStoredWorkspacePaths(int max, String prefValue) {
        String[] paths = new String[max];
        if (prefValue == null || prefValue.length() <= 0) {
            return paths;
        }
        StringTokenizer tokenizer = new StringTokenizer(prefValue, ",");
        int i = 0;
        while (i < paths.length && tokenizer.hasMoreTokens()) {
            paths[i] = tokenizer.nextToken();
            ++i;
        }
        return paths;
    }

    private static boolean compatibleFileProtocol(IMemento memento) {
        IMemento protocolMemento = memento.getChild("protocol");
        if (protocolMemento == null) {
            return false;
        }
        Integer version = protocolMemento.getInteger("version");
        return version != null && version == 1;
    }

    private static URL getPersistenceUrl(URL baseUrl, boolean create) {
        if (baseUrl == null) {
            return null;
        }
        try {
            URL url = new URL(baseUrl, PERS_FOLDER);
            File dir = new File(url.getFile());
            if (!(dir.exists() || create && dir.mkdir())) {
                return null;
            }
            url = new URL(dir.toURL(), PERS_FILENAME);
            File persFile = new File(url.getFile());
            if (!(persFile.exists() || create && persFile.createNewFile())) {
                return null;
            }
            return persFile.toURL();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static interface XML {
        public static final String PROTOCOL = "protocol";
        public static final String VERSION = "version";
        public static final String ALWAYS_ASK = "alwaysAsk";
        public static final String SHOW_DIALOG = "showDialog";
        public static final String WORKSPACE = "workspace";
        public static final String RECENT_WORKSPACES = "recentWorkspaces";
        public static final String MAX_LENGTH = "maxLength";
        public static final String PATH = "path";
    }
}

