/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class ProjectLocationMoveDialog
extends SelectionDialog {
    private IProject project;
    private IPath originalPath;
    private Text locationPathField;
    private Label locationLabel;
    private Label statusMessageLabel;
    private Button browseButton;
    private static String LOCATION_LABEL = IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationLabel;
    private static String BROWSE_LABEL = IDEWorkbenchMessages.ProjectLocationSelectionDialog_browseLabel;
    private static String DIRECTORY_DIALOG_LABEL = IDEWorkbenchMessages.ProjectLocationSelectionDialog_directoryLabel;
    private static String INVALID_LOCATION_MESSAGE = IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationError;
    private static String PROJECT_LOCATION_SELECTION_TITLE = IDEWorkbenchMessages.ProjectLocationSelectionDialog_selectionTitle;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private boolean useDefaults = true;

    public ProjectLocationMoveDialog(Shell parentShell, IProject existingProject) {
        super(parentShell);
        this.setTitle(PROJECT_LOCATION_SELECTION_TITLE);
        this.project = existingProject;
        try {
            this.originalPath = this.getProject().getDescription().getLocation();
            this.useDefaults = this.originalPath == null;
        }
        catch (CoreException coreException) {}
    }

    private void applyValidationResult(String errorMsg) {
        if (errorMsg == null) {
            this.statusMessageLabel.setText("");
            this.statusMessageLabel.setToolTipText("");
            this.getOkButton().setEnabled(true);
        } else {
            this.statusMessageLabel.setForeground(JFaceColors.getErrorText((Display)this.statusMessageLabel.getDisplay()));
            this.statusMessageLabel.setText(errorMsg);
            this.statusMessageLabel.setToolTipText(errorMsg);
            this.getOkButton().setEnabled(false);
        }
    }

    private String checkValid() {
        return this.checkValidLocation();
    }

    private String checkValidLocation() {
        if (this.useDefaults) {
            if (this.originalPath == null) {
                return INVALID_LOCATION_MESSAGE;
            }
            return null;
        }
        String locationFieldContents = this.locationPathField.getText();
        if (locationFieldContents.equals("")) {
            return IDEWorkbenchMessages.WizardNewProjectCreationPage_projectLocationEmpty;
        }
        Path path = new Path("");
        if (!path.isValidPath(locationFieldContents)) {
            return INVALID_LOCATION_MESSAGE;
        }
        Path newPath = new Path(locationFieldContents);
        IStatus locationStatus = this.project.getWorkspace().validateProjectLocation(this.project, (IPath)newPath);
        if (!locationStatus.isOK()) {
            return locationStatus.getMessage();
        }
        if (this.originalPath != null && this.originalPath.equals((Object)newPath)) {
            return INVALID_LOCATION_MESSAGE;
        }
        return null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.project_location_selection_dialog_context");
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        this.getOkButton().setEnabled(false);
        return content;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectLocationGroup(composite);
        this.statusMessageLabel = new Label(composite, 64);
        this.statusMessageLabel.setLayoutData((Object)new GridData(1808));
        this.statusMessageLabel.setFont(parent.getFont());
        this.statusMessageLabel.setText(" \n ");
        return composite;
    }

    private void createLocationListener() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ProjectLocationMoveDialog.this.applyValidationResult(ProjectLocationMoveDialog.this.checkValid());
            }
        };
        this.locationPathField.addListener(24, listener);
    }

    private final void createProjectLocationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        projectGroup.setFont(font);
        final Button useDefaultsButton = new Button(projectGroup, 131104);
        useDefaultsButton.setFont(font);
        useDefaultsButton.setText(IDEWorkbenchMessages.ProjectLocationSelectionDialog_useDefaultLabel);
        useDefaultsButton.setSelection(this.useDefaults);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup(projectGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectLocationMoveDialog.this.useDefaults = useDefaultsButton.getSelection();
                ProjectLocationMoveDialog.this.browseButton.setEnabled(!ProjectLocationMoveDialog.this.useDefaults);
                ProjectLocationMoveDialog.this.locationPathField.setEnabled(!ProjectLocationMoveDialog.this.useDefaults);
                ProjectLocationMoveDialog.this.locationLabel.setEnabled(!ProjectLocationMoveDialog.this.useDefaults);
                ProjectLocationMoveDialog.this.setLocationForSelection();
                if (!ProjectLocationMoveDialog.this.useDefaults) {
                    if (ProjectLocationMoveDialog.this.originalPath != null) {
                        ProjectLocationMoveDialog.this.locationPathField.setText(ProjectLocationMoveDialog.this.originalPath.toOSString());
                    } else {
                        ProjectLocationMoveDialog.this.locationPathField.setText("");
                    }
                }
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private Composite createUserSpecifiedProjectLocationGroup(Composite projectGroup, boolean enabled) {
        Font font = projectGroup.getFont();
        this.locationLabel = new Label(projectGroup, 0);
        this.locationLabel.setFont(font);
        this.locationLabel.setText(LOCATION_LABEL);
        this.locationLabel.setEnabled(enabled);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setFont(font);
        this.locationPathField.setEnabled(enabled);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setFont(font);
        this.browseButton.setText(BROWSE_LABEL);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectLocationMoveDialog.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        this.setButtonLayoutData(this.browseButton);
        if (this.originalPath == null) {
            this.setLocationForSelection();
        } else {
            this.locationPathField.setText(this.originalPath.toOSString());
        }
        this.createLocationListener();
        return projectGroup;
    }

    private IProject getProject() {
        return this.project;
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(DIRECTORY_DIALOG_LABEL);
        String dirName = this.locationPathField.getText();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.locationPathField.setText(selectedDirectory);
        }
    }

    protected void okPressed() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getProject().getName());
        if (this.useDefaults) {
            list.add(Platform.getLocation().toString());
        } else {
            list.add(this.locationPathField.getText());
        }
        this.setResult(list);
        super.okPressed();
    }

    private void setLocationForSelection() {
        if (this.useDefaults) {
            IPath defaultPath = Platform.getLocation().append(this.getProject().getName());
            this.locationPathField.setText(defaultPath.toOSString());
        }
    }
}

