/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.service.datalocation.Location;

public class InstancePreferences
extends EclipsePreferences {
    private String qualifier;
    private int segmentCount;
    private IEclipsePreferences loadLevel;
    private IPath location;
    private static Set loadedNodes = new HashSet();
    private static boolean initialized = false;
    private static IPath baseLocation;

    private static IPath getBaseLocation() {
        Location instanceLocation;
        if (baseLocation == null && (instanceLocation = Platform.getInstanceLocation()) != null && (instanceLocation.isSet() || instanceLocation.allowsDefault())) {
            baseLocation = InternalPlatform.getDefault().getMetaArea().getStateLocation("org.eclipse.core.runtime");
        }
        return baseLocation;
    }

    public InstancePreferences() {
        this(null, null);
    }

    private InstancePreferences(EclipsePreferences parent, String name) {
        super(parent, name);
        this.initializeChildren();
        String path = this.absolutePath();
        this.segmentCount = InstancePreferences.getSegmentCount(path);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = InstancePreferences.getSegment(path, 1);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.name());
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadLegacy() {
        block19: {
            path = new Path(this.absolutePath());
            if (path.segmentCount() != 2) {
                return;
            }
            if (Platform.getInstanceLocation() == null) {
                if (InternalPlatform.DEBUG_PREFERENCE_GENERAL == false) return;
                Policy.debug("Cannot load Legacy plug-in preferences since instance location is not set.");
                return;
            }
            bundleName = path.segment(1);
            prefFile = null;
            instanceLocation = Platform.getInstanceLocation();
            if (instanceLocation != null && instanceLocation.isSet()) {
                prefFile = InternalPlatform.getDefault().getMetaArea().getPreferenceLocation(bundleName, false).toFile();
            }
            if (prefFile == null) {
                if (InternalPlatform.DEBUG_PREFERENCE_GENERAL == false) return;
                Policy.debug("Cannot load legacy values because instance location is not set.");
                return;
            }
            if (!prefFile.exists()) {
                if (InternalPlatform.DEBUG_PREFERENCE_GENERAL == false) return;
                Policy.debug("Legacy plug-in preference file not found: " + prefFile);
                return;
            }
            if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                Policy.debug("Loading legacy preferences from " + prefFile);
            }
            input = null;
            values = new Properties();
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(prefFile));
                    values.load(input);
                }
                catch (IOException v0) {
                    if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                        Policy.debug("IOException encountered loading legacy preference file " + prefFile);
                    }
                    var7_7 = null;
                    if (input == null) return;
                    try {
                        input.close();
                        return;
                    }
                    catch (IOException e) {
                        if (InternalPlatform.DEBUG_PREFERENCE_GENERAL == false) return;
                        Policy.debug("IOException encountered closing legacy preference file " + prefFile);
                        e.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable var8_13) {
                var7_8 = null;
                if (input == null) throw var8_13;
                ** try [egrp 2[TRYBLOCK] [3 : 246->254)] { 
lbl49:
                // 1 sources

                input.close();
                throw var8_13;
lbl51:
                // 1 sources

                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCE_GENERAL == false) throw var8_13;
                    Policy.debug("IOException encountered closing legacy preference file " + prefFile);
                    e.printStackTrace();
                }
                throw var8_13;
            }
            {
                var7_9 = null;
                if (input == null) break block19;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 246->254)] { 
lbl59:
            // 1 sources

            input.close();
            break block19;
lbl61:
            // 1 sources

            catch (IOException e) {
                if (!InternalPlatform.DEBUG_PREFERENCE_GENERAL) break block19;
                Policy.debug("IOException encountered closing legacy preference file " + prefFile);
                e.printStackTrace();
            }
        }
        i = values.keySet().iterator();
        while (true) {
            if (!i.hasNext()) {
                if (prefFile.delete() != false) return;
                if (InternalPlatform.DEBUG_PREFERENCE_GENERAL == false) return;
                Policy.debug("Unable to delete legacy preferences file: " + prefFile);
                return;
            }
            key = (String)i.next();
            value = values.getProperty(key);
            if (value == null) continue;
            if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                Policy.debug("Loaded legacy preference: " + key + " -> " + value);
            }
            if (value.equals(oldValue = this.internalPut(key, value))) continue;
            this.makeDirty();
        }
    }

    protected IPath getLocation() {
        if (this.location == null) {
            this.location = this.computeLocation(InstancePreferences.getBaseLocation(), this.qualifier);
        }
        return this.location;
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            IEclipsePreferences node = this;
            int i = 2;
            while (i < this.segmentCount) {
                node = (IEclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initializeChildren() {
        if (initialized) return;
        if (this.parent == null) {
            return;
        }
        try {
            InstancePreferences instancePreferences = this;
            synchronized (instancePreferences) {
                String[] names = this.computeChildren(InstancePreferences.getBaseLocation());
                int i = 0;
                while (true) {
                    block8: {
                        if (i < names.length) break block8;
                        break;
                    }
                    this.addChild(names[i], null);
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            initialized = true;
            throw throwable;
        }
        {
            Object var4_6 = null;
            initialized = true;
            return;
        }
    }

    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Plugin context) {
        return new InstancePreferences(nodeParent, nodeName);
    }
}

