/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.core;

import java.net.URL;
import java.net.URLClassLoader;

public class AntClassLoader
extends URLClassLoader {
    private boolean allowPluginLoading = false;
    protected ClassLoader[] pluginLoaders;
    private static final String ANT_PACKAGES_PREFIX = "org.apache.tools";
    private ClassLoader fContextClassloader = null;

    public AntClassLoader(URL[] urls, ClassLoader[] pluginLoaders) {
        super(urls, ClassLoader.getSystemClassLoader());
        this.pluginLoaders = pluginLoaders;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class result = null;
        if (this.allowPluginLoading || !name.startsWith(ANT_PACKAGES_PREFIX)) {
            result = this.loadClassPlugins(name);
        }
        if (result == null) {
            result = this.loadClassURLs(name);
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    protected Class loadClassURLs(String name) {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected Class loadClassPlugins(String name) {
        if (this.fContextClassloader != null) {
            Thread.currentThread().setContextClassLoader(this.fContextClassloader);
        }
        try {
            Class<?> result = null;
            if (this.pluginLoaders != null) {
                int i = 0;
                while (i < this.pluginLoaders.length && result == null) {
                    try {
                        result = this.pluginLoaders[i].loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    ++i;
                }
            }
            Class<?> clazz = result;
            Object var4_5 = null;
            Thread.currentThread().setContextClassLoader(this);
            return clazz;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Thread.currentThread().setContextClassLoader(this);
            throw throwable;
        }
    }

    public void allowPluginClassLoadersToLoadAntClasses(boolean allowLoading) {
        this.allowPluginLoading = allowLoading;
    }

    public void setPluginContextClassloader(ClassLoader classLoader) {
        this.fContextClassloader = classLoader;
    }
}

