/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.ssl;

import java.io.IOException;
import java.security.KeyStore;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.tomcat.util.net.jsse.JSSE14SocketFactory;
import org.jboss.security.SecurityDomain;

public class JBossSocketFactory
extends JSSE14SocketFactory {
    private SecurityDomain securityDomain;

    public void setAttribute(String name, Object value) {
        if (name.equalsIgnoreCase("securityDomain")) {
            try {
                this.setSecurityDomainName((String)value);
            }
            catch (Exception e) {
                IllegalArgumentException ex = new IllegalArgumentException("Failed to set security domain");
                ex.initCause(e);
                throw ex;
            }
        }
        super.setAttribute(name, value);
    }

    public void setSecurityDomainName(String jndiName) throws NamingException, IOException {
        InitialContext iniCtx = new InitialContext();
        this.securityDomain = (SecurityDomain)iniCtx.lookup(jndiName);
    }

    protected KeyStore getKeystore(String type, String pass) throws IOException {
        return this.securityDomain.getKeyStore();
    }

    protected KeyStore getTrustStore(String type) throws IOException {
        return this.securityDomain.getTrustStore();
    }

    protected TrustManager[] getTrustManagers(String keystoreType, String algorithm) throws Exception {
        TrustManagerFactory tmf = this.securityDomain.getTrustManagerFactory();
        TrustManager[] trustMgrs = null;
        if (tmf != null) {
            trustMgrs = tmf.getTrustManagers();
        }
        return trustMgrs;
    }

    protected KeyManager[] getKeyManagers(String keystoreType, String algorithm, String keyAlias) throws Exception {
        KeyManagerFactory kmf = this.securityDomain.getKeyManagerFactory();
        KeyManager[] keyMgrs = null;
        if (kmf != null) {
            keyMgrs = kmf.getKeyManagers();
        }
        return keyMgrs;
    }
}

