/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.QueryException;
import org.hibernate.loader.custom.SQLQueryReturn;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.SQLLoadable;
import org.hibernate.util.StringHelper;

public class SQLQueryParser {
    private final String sqlQuery;
    private final Map entityPersisterByAlias;
    private final String[] aliases;
    private final String[] suffixes;
    private final SQLLoadableCollection[] collectionPersisters;
    private final String[] collectionAliases;
    private final String[] collectionSuffixes;
    private int parameterCount = 0;
    private final Map namedParameters = new HashMap();
    private final Map returnByAlias;
    private long aliasesFound = 0L;

    public SQLQueryParser(String sqlQuery, Map alias2Persister, Map alias2Return, String[] aliases, String[] collectionAliases, SQLLoadableCollection[] collectionPersisters, String[] suffixes, String[] collectionSuffixes) {
        this.sqlQuery = sqlQuery;
        this.entityPersisterByAlias = alias2Persister;
        this.returnByAlias = alias2Return;
        this.collectionAliases = collectionAliases;
        this.collectionPersisters = collectionPersisters;
        this.suffixes = suffixes;
        this.aliases = aliases;
        this.collectionSuffixes = collectionSuffixes;
    }

    private SQLLoadable getPersisterByResultAlias(String aliasName) {
        return (SQLLoadable)this.entityPersisterByAlias.get(aliasName);
    }

    private Map getPropertyResultByResultAlias(String aliasName) {
        SQLQueryReturn sqr = (SQLQueryReturn)this.returnByAlias.get(aliasName);
        return sqr.getPropertyResultsMap();
    }

    private boolean isEntityAlias(String aliasName) {
        return this.entityPersisterByAlias.containsKey(aliasName);
    }

    private int getPersisterIndex(String aliasName) {
        for (int i = 0; i < this.aliases.length; ++i) {
            if (!aliasName.equals(this.aliases[i])) continue;
            return i;
        }
        return -1;
    }

    public String process() {
        return this.substituteParams(this.substituteBrackets());
    }

    private String substituteBrackets() throws QueryException {
        StringBuffer result = new StringBuffer(this.sqlQuery.length() + 20);
        int curr = 0;
        while (curr < this.sqlQuery.length()) {
            int left = this.sqlQuery.indexOf(123, curr);
            if (left < 0) {
                result.append(this.sqlQuery.substring(curr));
                break;
            }
            result.append(this.sqlQuery.substring(curr, left));
            int right = this.sqlQuery.indexOf(125, left + 1);
            if (right < 0) {
                throw new QueryException("Unmatched braces for alias path", this.sqlQuery);
            }
            String aliasPath = this.sqlQuery.substring(left + 1, right);
            int firstDot = aliasPath.indexOf(46);
            if (firstDot == -1) {
                if (this.isEntityAlias(aliasPath)) {
                    result.append(aliasPath);
                    ++this.aliasesFound;
                } else {
                    result.append('{').append(aliasPath).append('}');
                }
            } else {
                String propertyName;
                String aliasName = aliasPath.substring(0, firstDot);
                int collectionIndex = Arrays.binarySearch(this.collectionAliases, aliasName);
                boolean isCollection = collectionIndex > -1;
                boolean isEntity = this.isEntityAlias(aliasName);
                if (isCollection) {
                    propertyName = aliasPath.substring(firstDot + 1);
                    result.append(this.resolveCollectionProperties(aliasName, propertyName, this.getPropertyResultByResultAlias(aliasName), this.getPersisterByResultAlias(aliasName), this.collectionPersisters[collectionIndex], this.collectionSuffixes[collectionIndex], this.suffixes[this.getPersisterIndex(aliasName)]));
                    ++this.aliasesFound;
                } else if (isEntity) {
                    propertyName = aliasPath.substring(firstDot + 1);
                    result.append(this.resolveProperties(aliasName, propertyName, this.getPropertyResultByResultAlias(aliasName), this.getPersisterByResultAlias(aliasName), this.suffixes[this.getPersisterIndex(aliasName)]));
                    ++this.aliasesFound;
                }
                if (!isEntity && !isCollection) {
                    result.append('{').append(aliasPath).append('}');
                }
            }
            curr = right + 1;
        }
        return result.toString();
    }

    private String resolveCollectionProperties(String aliasName, String propertyName, Map fieldResults, SQLLoadable elementPersister, SQLLoadableCollection currentPersister, String suffix, String persisterSuffix) {
        if ("*".equals(propertyName)) {
            if (!fieldResults.isEmpty()) {
                throw new QueryException("Using return-propertys together with * syntax is not supported.");
            }
            String selectFragment = currentPersister.selectFragment(aliasName, suffix);
            ++this.aliasesFound;
            return new String(selectFragment + ", " + this.resolveProperties(aliasName, propertyName, fieldResults, elementPersister, persisterSuffix));
        }
        if ("element.*".equals(propertyName)) {
            return this.resolveProperties(aliasName, "*", fieldResults, elementPersister, persisterSuffix);
        }
        String[] columnAliases = (String[])fieldResults.get(propertyName);
        if (columnAliases == null) {
            columnAliases = currentPersister.getCollectionPropertyColumnAliases(propertyName, suffix);
        }
        if (columnAliases == null || columnAliases.length == 0) {
            throw new QueryException("No column name found for property [" + propertyName + "] for alias [" + aliasName + "]", this.sqlQuery);
        }
        if (columnAliases.length != 1) {
            throw new QueryException("SQL queries only support properties mapped to a single column - property [" + propertyName + "] is mapped to " + columnAliases.length + " columns.", this.sqlQuery);
        }
        ++this.aliasesFound;
        return columnAliases[0];
    }

    private String resolveProperties(String aliasName, String propertyName, Map fieldResults, SQLLoadable currentPersister, String suffix) {
        if ("*".equals(propertyName)) {
            if (!fieldResults.isEmpty()) {
                throw new QueryException("Using return-propertys together with * syntax is not supported.");
            }
            ++this.aliasesFound;
            return currentPersister.selectFragment(aliasName, suffix);
        }
        String[] columnAliases = (String[])fieldResults.get(propertyName);
        if (columnAliases == null) {
            columnAliases = currentPersister.getSubclassPropertyColumnAliases(propertyName, suffix);
        }
        if (columnAliases == null || columnAliases.length == 0) {
            throw new QueryException("No column name found for property [" + propertyName + "] for alias [" + aliasName + "]", this.sqlQuery);
        }
        if (columnAliases.length != 1) {
            throw new QueryException("SQL queries only support properties mapped to a single column - property [" + propertyName + "] is mapped to " + columnAliases.length + " columns.", this.sqlQuery);
        }
        ++this.aliasesFound;
        return columnAliases[0];
    }

    private String substituteParams(String sqlString) {
        StringBuffer result = new StringBuffer(sqlString.length());
        int curr = 0;
        while (curr < sqlString.length()) {
            int left = sqlString.indexOf(":", curr);
            if (left < 0) {
                result.append(sqlString.substring(curr));
                break;
            }
            result.append(sqlString.substring(curr, left));
            int right = StringHelper.firstIndexOfChar(sqlString, " \n\r\f\t,()=<>&|+-=/*'^![]#~\\", left + 1);
            boolean foundSeperator = right > 0;
            int chopLocation = -1;
            chopLocation = right < 0 ? sqlString.length() : right;
            String param = sqlString.substring(left + 1, chopLocation);
            this.addNamedParameter(param);
            result.append("?");
            if (!foundSeperator) break;
            result.append(sqlString.charAt(right));
            curr = right + 1;
        }
        return result.toString();
    }

    private void addNamedParameter(String name) {
        Integer loc = new Integer(this.parameterCount++);
        Object o = this.namedParameters.get(name);
        if (o == null) {
            this.namedParameters.put(name, loc);
        } else if (o instanceof Integer) {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(o);
            list.add(loc);
            this.namedParameters.put(name, list);
        } else {
            ((List)o).add(loc);
        }
    }

    public Map getNamedParameters() {
        return this.namedParameters;
    }

    public boolean queryHasAliases() {
        return this.aliasesFound > 0L;
    }
}

