/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.NaturalIdentifier;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.impl.SessionImpl;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.util.StringHelper;

public class CriteriaImpl
implements Criteria,
Serializable {
    private FlushMode flushMode;
    private CacheMode cacheMode;
    private FlushMode sessionFlushMode;
    private CacheMode sessionCacheMode;
    private List criterionEntries = new ArrayList();
    private List orderEntries = new ArrayList();
    private Projection projection;
    private Criteria projectionCriteria;
    private Map fetchModes = new HashMap();
    private List subcriteriaList = new ArrayList();
    private final String entityOrClassName;
    private Map lockModes = new HashMap();
    private Integer maxResults;
    private Integer firstResult;
    private Integer timeout;
    private Integer fetchSize;
    private boolean cacheable;
    private String cacheRegion;
    private String comment;
    private transient SessionImplementor session;
    private final String rootAlias;
    private ResultTransformer resultTransformer = Criteria.ROOT_ENTITY;

    public void setSession(SessionImpl session) {
        this.session = session;
    }

    public SessionImplementor getSession() {
        return this.session;
    }

    public Iterator iterateSubcriteria() {
        return this.subcriteriaList.iterator();
    }

    public Criteria setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    public Criteria setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    public Criteria setMaxResults(int maxResults) {
        this.maxResults = new Integer(maxResults);
        return this;
    }

    public Criteria setFirstResult(int firstResult) {
        this.firstResult = new Integer(firstResult);
        return this;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public Criteria setFetchSize(int fetchSize) {
        this.fetchSize = new Integer(fetchSize);
        return this;
    }

    public Criteria setTimeout(int timeout) {
        this.timeout = new Integer(timeout);
        return this;
    }

    public Criteria add(Criterion expression) {
        this.add(this, expression);
        return this;
    }

    public String getAlias() {
        return this.rootAlias;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public Integer getFirstResult() {
        return this.firstResult;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public CriteriaImpl(String entityOrClassName, SessionImplementor session) {
        this(entityOrClassName, "this", session);
    }

    public CriteriaImpl(String entityOrClassName, String alias, SessionImplementor session) {
        this.session = session;
        this.entityOrClassName = entityOrClassName;
        this.cacheable = false;
        this.rootAlias = alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list() throws HibernateException {
        this.before();
        try {
            List list = this.session.list(this);
            return list;
        }
        finally {
            this.after();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll() {
        this.before();
        try {
            ScrollableResults scrollableResults = this.session.scroll(this, ScrollMode.SCROLL_INSENSITIVE);
            return scrollableResults;
        }
        finally {
            this.after();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll(ScrollMode scrollMode) {
        this.before();
        try {
            ScrollableResults scrollableResults = this.session.scroll(this, scrollMode);
            return scrollableResults;
        }
        finally {
            this.after();
        }
    }

    public boolean getCacheable() {
        return this.cacheable;
    }

    public String getCacheRegion() {
        return this.cacheRegion;
    }

    public Criteria setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public Criteria setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion.trim();
        return this;
    }

    public Iterator iterateExpressionEntries() {
        return this.criterionEntries.iterator();
    }

    public Iterator iterateOrderings() {
        return this.orderEntries.iterator();
    }

    public String toString() {
        return "CriteriaImpl(" + this.entityOrClassName + ":" + (this.rootAlias == null ? "" : this.rootAlias) + this.subcriteriaList.toString() + this.criterionEntries.toString() + (this.projection == null ? "" : this.projection.toString()) + ')';
    }

    public Criteria addOrder(Order ordering) {
        this.orderEntries.add(new OrderEntry(ordering, this));
        return this;
    }

    public FetchMode getFetchMode(String path) {
        return (FetchMode)this.fetchModes.get(path);
    }

    public Criteria setFetchMode(String associationPath, FetchMode mode) {
        this.fetchModes.put(associationPath, mode);
        return this;
    }

    public Criteria createAlias(String associationPath, String alias) throws HibernateException {
        new Subcriteria(this, associationPath, alias);
        return this;
    }

    public Criteria add(Criteria criteriaInst, Criterion expression) {
        this.criterionEntries.add(new CriterionEntry(expression, criteriaInst));
        return this;
    }

    public Object uniqueResult() throws HibernateException {
        return AbstractQueryImpl.uniqueElement(this.list());
    }

    public String getEntityOrClassName() {
        return this.entityOrClassName;
    }

    public Criteria createCriteria(String associationPath, String alias) throws HibernateException {
        return new Subcriteria(this, associationPath, alias);
    }

    public Criteria createCriteria(String associationPath) throws HibernateException {
        return new Subcriteria((Criteria)this, associationPath);
    }

    public Criteria setLockMode(LockMode lockMode) {
        return this.setLockMode(this.getAlias(), lockMode);
    }

    public Criteria setLockMode(String alias, LockMode lockMode) {
        this.lockModes.put(alias, lockMode);
        return this;
    }

    public Map getLockModes() {
        return this.lockModes;
    }

    public ResultTransformer getResultTransformer() {
        return this.resultTransformer;
    }

    public Criteria setResultTransformer(ResultTransformer tupleMapper) {
        this.resultTransformer = tupleMapper;
        return this;
    }

    public Criteria setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public Criteria setProjection(Projection projection) {
        this.projection = projection;
        this.projectionCriteria = this;
        this.setResultTransformer(PROJECTION);
        return this;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public Criteria getProjectionCriteria() {
        return this.projectionCriteria;
    }

    protected void before() {
        if (this.flushMode != null) {
            this.sessionFlushMode = this.getSession().getFlushMode();
            this.getSession().setFlushMode(this.flushMode);
        }
        if (this.cacheMode != null) {
            this.sessionCacheMode = this.getSession().getCacheMode();
            this.getSession().setCacheMode(this.cacheMode);
        }
    }

    protected void after() {
        if (this.sessionFlushMode != null) {
            this.getSession().setFlushMode(this.sessionFlushMode);
            this.sessionFlushMode = null;
        }
        if (this.sessionCacheMode != null) {
            this.getSession().setCacheMode(this.sessionCacheMode);
            this.sessionCacheMode = null;
        }
    }

    public boolean isLookupByNaturalKey() {
        if (this.projection != null) {
            return false;
        }
        if (this.subcriteriaList.size() > 0) {
            return false;
        }
        if (this.criterionEntries.size() != 1) {
            return false;
        }
        CriterionEntry ce = (CriterionEntry)this.criterionEntries.get(0);
        return ce.getCriterion() instanceof NaturalIdentifier;
    }

    public static final class OrderEntry
    implements Serializable {
        private final Order order;
        private final Criteria criteria;

        private OrderEntry(Order order, Criteria criteria) {
            this.criteria = criteria;
            this.order = order;
        }

        public Order getOrder() {
            return this.order;
        }

        public Criteria getCriteria() {
            return this.criteria;
        }

        public String toString() {
            return this.order.toString();
        }
    }

    public static final class CriterionEntry
    implements Serializable {
        private final Criterion criterion;
        private final Criteria criteria;

        private CriterionEntry(Criterion criterion, Criteria criteria) {
            this.criteria = criteria;
            this.criterion = criterion;
        }

        public Criterion getCriterion() {
            return this.criterion;
        }

        public Criteria getCriteria() {
            return this.criteria;
        }

        public String toString() {
            return this.criterion.toString();
        }
    }

    public final class Subcriteria
    implements Criteria,
    Serializable {
        private String alias;
        private String path;
        private Criteria parent;
        private LockMode lockMode;

        public Criteria getParent() {
            return this.parent;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            return "Subcriteria(" + this.path + ":" + (this.alias == null ? "" : this.alias) + ')';
        }

        private Subcriteria(Criteria parent, String path, String alias) {
            this.alias = alias;
            this.path = path;
            this.parent = parent;
            CriteriaImpl.this.subcriteriaList.add(this);
        }

        private Subcriteria(Criteria parent, String path) {
            this(parent, path, (String)null);
        }

        public Criteria setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public String getAlias() {
            return this.alias;
        }

        public Criteria add(Criterion expression) {
            CriteriaImpl.this.add(this, expression);
            return this;
        }

        public Criteria createAlias(String associationPath, String alias) throws HibernateException {
            new Subcriteria((Criteria)this, associationPath, alias);
            return this;
        }

        public Criteria addOrder(Order order) {
            CriteriaImpl.this.orderEntries.add(new OrderEntry(order, this));
            return this;
        }

        public Criteria setCacheable(boolean cacheable) {
            CriteriaImpl.this.setCacheable(cacheable);
            return this;
        }

        public Criteria setCacheRegion(String cacheRegion) {
            CriteriaImpl.this.setCacheRegion(cacheRegion);
            return this;
        }

        public Criteria createCriteria(String associationPath) throws HibernateException {
            return new Subcriteria(this, associationPath);
        }

        public List list() throws HibernateException {
            return CriteriaImpl.this.list();
        }

        public ScrollableResults scroll() throws HibernateException {
            return CriteriaImpl.this.scroll();
        }

        public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
            return CriteriaImpl.this.scroll(scrollMode);
        }

        public Object uniqueResult() throws HibernateException {
            return CriteriaImpl.this.uniqueResult();
        }

        public Criteria setFetchMode(String associationPath, FetchMode mode) throws HibernateException {
            CriteriaImpl.this.setFetchMode(StringHelper.qualify(this.path, associationPath), mode);
            return this;
        }

        public Criteria setFlushMode(FlushMode flushMode) {
            CriteriaImpl.this.setFlushMode(flushMode);
            return this;
        }

        public Criteria setCacheMode(CacheMode cacheMode) {
            CriteriaImpl.this.setCacheMode(cacheMode);
            return this;
        }

        public Criteria setFirstResult(int firstResult) {
            CriteriaImpl.this.setFirstResult(firstResult);
            return this;
        }

        public Criteria setMaxResults(int maxResults) {
            CriteriaImpl.this.setMaxResults(maxResults);
            return this;
        }

        public Criteria setTimeout(int timeout) {
            CriteriaImpl.this.setTimeout(timeout);
            return this;
        }

        public Criteria setFetchSize(int fetchSize) {
            CriteriaImpl.this.setFetchSize(fetchSize);
            return this;
        }

        public Criteria createCriteria(String associationPath, String alias) throws HibernateException {
            return new Subcriteria((Criteria)this, associationPath, alias);
        }

        public Criteria setLockMode(LockMode lockMode) {
            this.lockMode = lockMode;
            return this;
        }

        public LockMode getLockMode() {
            return this.lockMode;
        }

        public Criteria setLockMode(String alias, LockMode lockMode) {
            CriteriaImpl.this.setLockMode(alias, lockMode);
            return this;
        }

        public Criteria setResultTransformer(ResultTransformer resultProcessor) {
            CriteriaImpl.this.setResultTransformer(resultProcessor);
            return this;
        }

        public Criteria setComment(String comment) {
            CriteriaImpl.this.setComment(comment);
            return this;
        }

        public Criteria setProjection(Projection projection) {
            CriteriaImpl.this.projection = projection;
            CriteriaImpl.this.projectionCriteria = this;
            this.setResultTransformer(PROJECTION);
            return this;
        }
    }
}

